/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchCriteria;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class SearchController {
    private final SearchManager _searchManager;

    @Autowired
    public SearchController(SearchManager searchManager) {
        this._searchManager = searchManager;
    }

    @RequestMapping(value={"/quicksearch"}, method={RequestMethod.GET})
    @ResponseBody
    public List<QuickSearchResult> getQuickSearchResults(@RequestParam(value="query") String query, @RequestParam(value="opId") String opId) throws Exception {
        query = query.trim();
        List<QuickSearchResult> resultSet = this._searchManager.getQuickSearchResults(query, opId);
        return resultSet;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SearchTypeData> getSearchResults(@RequestParam(value="query") String query, @RequestParam(value="opId") String opId, @RequestBody String searchCriteriaJson) throws Exception {
        query = query.trim();
        if (searchCriteriaJson == null || searchCriteriaJson.isEmpty()) {
            return this._searchManager.getSimpleSearchResults(query, opId);
        }
        SearchCriteria searchCriteria = (SearchCriteria)new ObjectMapper().readValue(searchCriteriaJson, SearchCriteria.class);
        return this._searchManager.getSearchResults(query, searchCriteria, opId);
    }

    @RequestMapping(value={"/simplesearch/summary"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SearchTypeData> getAllQuickSearchResults(@RequestParam(value="query") String query, @RequestParam(value="opId") String opId) throws Exception {
        query = query.trim();
        List<SearchTypeData> searchTypeResults = this._searchManager.getSimpleSearchResults(query, opId);
        return searchTypeResults;
    }
}

