/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.tasks.TaskQueryUtil;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vsphere.client.common.error.ErrorReportArgs;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.security.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tasks"})
public class TasksController {
    private static final Log _logger = LogFactory.getLog(TasksController.class);
    public static final String ALL = "all";
    public static final String RUNNING = "running";
    public static final String FAILED = "failed";
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final int MAX_PAGE_SIZE_COUNT = 100;
    private final DataService _dataService;
    private final ObjectTypesManager _objectTypesManager;
    private final ObjectReferenceService _objectReferenceService;
    private final QueryExecutor _queryExecutor;
    private final ErrorReportService _errorReportService;
    private static Comparator<ClientTaskInfo> startTimeComparator = new Comparator<ClientTaskInfo>(){

        @Override
        public int compare(ClientTaskInfo o1, ClientTaskInfo o2) {
            return o2.queueTime.compareTo(o1.queueTime);
        }
    };

    @Autowired
    public TasksController(DataService dataService, ObjectTypesManager objectTypesManager, @Qualifier(value="objectReferenceService") ObjectReferenceService objReferenceService, QueryExecutor queryExecutor, ErrorReportService errorReportService) {
        this._dataService = dataService;
        this._objectTypesManager = objectTypesManager;
        this._objectReferenceService = objReferenceService;
        this._queryExecutor = queryExecutor;
        this._errorReportService = errorReportService;
    }

    @RequestMapping(value={"/recenttasks"})
    @ResponseBody
    public ClientTaskInfo[] getRecentTasks(@RequestParam(value="taskState", defaultValue="all") String taskState, @RequestParam(value="startedByLoggedInUserOnly", defaultValue="true") boolean startedByLoggedInUserOnly) throws Exception {
        String loggedInUserName = null;
        if (startedByLoggedInUserOnly) {
            UserSession userSession = Util.getUserSession();
            if (userSession == null) {
                throw new IllegalStateException("User is not logged in.");
            }
            loggedInUserName = userSession.userName;
        }
        QuerySpec query = TaskQueryUtil.createTaskQuerySpec(null, false, true, null, loggedInUserName, -1, 0);
        RequestSpec request = new RequestSpec();
        request.querySpec = new QuerySpec[1];
        request.querySpec[0] = query;
        query.name = this._opId;
        Response response = this._dataService.getData(request);
        ClientTaskInfo[] filteredTasks = this.filterTasksBasedOnState(response, taskState);
        Arrays.sort(filteredTasks, startTimeComparator);
        this.process(filteredTasks);
        return filteredTasks;
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public List<ClientTaskInfo> getTasks(@RequestParam(value="objectId", required=false) String objectId, @RequestParam(value="pageSize", defaultValue="-1") int pageSize, @RequestParam(value="requestedPage", defaultValue="0") int requestedPage, @RequestParam(value="requestingPrevPage", defaultValue="false") boolean requestingPrevPage) throws Exception {
        Object objRef = null;
        if (objectId != null) {
            objRef = this._objectReferenceService.getReference(objectId, true);
        }
        if (pageSize > 100) {
            _logger.warn((Object)("Reducing the pageSize task count from " + pageSize + " to " + 100));
            pageSize = 100;
        }
        QuerySpec query = TaskQueryUtil.createTaskQuerySpec(objRef, false, false, null, null, pageSize, requestedPage);
        query.resultSpec.maxResultCount = pageSize;
        ResultSet resultSet = this._queryExecutor.getData(query);
        if (resultSet == null) {
            return null;
        }
        List<ClientTaskInfo> result = this.formatResults(resultSet);
        return result;
    }

    @RequestMapping(value={"/errorStack"})
    @ResponseBody
    public List<String> getErrorStack(@RequestParam(value="eventId", required=false) String eventId, @RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="parentTaskId", required=false) String parentTaskId, @RequestParam(value="serverGuid", required=true) String serverGuid) throws Exception {
        ErrorReportArgs args = new ErrorReportArgs();
        args.eventId = eventId;
        args.taskId = taskId;
        args.parentTaskId = parentTaskId;
        args.serverGuid = serverGuid;
        ErrorStack stack = this._errorReportService.getErrorStack(args);
        LinkedList<String> errorStackMessages = new LinkedList<String>();
        this.addErrorStackMessages(errorStackMessages, stack);
        return errorStackMessages;
    }

    private void addErrorStackMessages(List<String> errorStackMessages, ErrorStack stack) {
        if (stack != null) {
            if (StringUtils.isNotEmpty((CharSequence)stack.message)) {
                errorStackMessages.add(stack.message);
            }
            if (stack.messages != null) {
                for (LocalizableMessage localizableMessage : stack.messages) {
                    errorStackMessages.add(localizableMessage.getMessage());
                }
            }
            if (stack.cause != null) {
                for (LocalizableMessage localizableMessage : stack.cause) {
                    this.addErrorStackMessages(errorStackMessages, (ErrorStack)localizableMessage);
                }
            }
        }
    }

    private List<ClientTaskInfo> formatResults(ResultSet rs) {
        ArrayList<ClientTaskInfo> itemDataResult = new ArrayList<ClientTaskInfo>();
        for (ResultItem ri : rs.items) {
            for (PropertyValue pv : ri.properties) {
                if (!pv.propertyName.equals("info")) continue;
                itemDataResult.add((ClientTaskInfo)pv.value);
            }
        }
        return itemDataResult;
    }

    private void process(ClientTaskInfo[] taskInfos) {
        for (ClientTaskInfo taskInfo : taskInfos) {
            ObjectTypeSpec typespec = this._objectTypesManager.getObjectTypeSpec(taskInfo.entityType);
            if (typespec != null) {
                taskInfo.entityIconId = typespec.icon;
            }
            if (taskInfo.progress == -1 && taskInfo.state.equals((Object)TaskState.SUCCESS)) {
                taskInfo.progress = 100;
            }
            if (taskInfo.taskRef != null) {
                taskInfo.taskUid = this._objectReferenceService.getUid(taskInfo.taskRef);
            }
            if (taskInfo.entity != null) {
                taskInfo.entityUid = this._objectReferenceService.getUid(taskInfo.entity);
            }
            if (taskInfo.result == null) continue;
            taskInfo.resultEntityUid = this._objectReferenceService.getUid(taskInfo.result);
        }
    }

    private ClientTaskInfo[] filterTasksBasedOnState(Response response, String taskState) throws Exception {
        if (response == null || response.resultSet == null || response.resultSet.length == 0) {
            return new ClientTaskInfo[0];
        }
        ArrayList<ClientTaskInfo> tasks = new ArrayList<ClientTaskInfo>();
        for (ResultItem item : response.resultSet[0].items) {
            if (item.properties.length <= 0 || item.properties[0].propertyName != "info" || !(item.properties[0].value instanceof ClientTaskInfo)) continue;
            ClientTaskInfo taskInfo = (ClientTaskInfo)item.properties[0].value;
            if (taskState.equals(ALL)) {
                tasks.add(taskInfo);
            }
            if (taskState.equals(RUNNING) && (taskInfo.state == TaskState.QUEUED || taskInfo.state == TaskState.RUNNING)) {
                tasks.add(taskInfo);
            }
            if (!taskState.equals(FAILED) || taskInfo.state != TaskState.ERROR) continue;
            tasks.add(taskInfo);
        }
        return tasks.toArray(new ClientTaskInfo[tasks.size()]);
    }
}

