/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.usersession.CloneSessionInfo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/usersessionex"}, method={RequestMethod.GET})
public class UserSessionInternalController {
    private static final Log _logger = LogFactory.getLog(UserSessionInternalController.class);
    private boolean internalUser = false;
    private String hostName = null;

    @RequestMapping(value={"/acquireCloneTicket/{serverGuid}"})
    @ResponseBody
    public CloneSessionInfo acquireCloneTicket(@PathVariable(value="serverGuid") String serverGuid) throws Exception {
        String userName = (String)SessionUtil.getData((String)"USER_NAME");
        if (StringUtils.isEmpty((CharSequence)userName)) {
            _logger.error((Object)"acquireCloneTicket called on an inactive session.");
            MixedUtil.throwNotAuthenticatedError(null);
        }
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ManagedObjectReference sessionManagerMOR = service.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sessionManagerMOR);
        String sessionTicket = sessionManager.acquireCloneTicket();
        CloneSessionInfo sessionInfo = new CloneSessionInfo();
        ServerInfoEx serverInfo = VcServiceUtil.toServerInfoEx((VcService)service);
        sessionInfo.setServerInfo((ServerInfo)serverInfo);
        sessionInfo.setSessionTicket(sessionTicket);
        sessionInfo.setUserName(userName);
        Locale locale = ResourceUtil.getLocale();
        if (locale != null) {
            sessionInfo.setLocale(locale.toString());
        }
        return sessionInfo;
    }

    @RequestMapping(value={"/internalinfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getInternalInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("isInternal", String.valueOf(this.internalUser));
        if (this.hostName != null) {
            result.put("hostName", this.hostName);
        }
        return result;
    }
}

