/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.events;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.events.LinkableEntityParser;
import com.vmware.vise.mvc.events.model.EventCause;
import com.vmware.vise.mvc.events.model.EventListItemData;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.StringUtil;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EventFormatter {
    private ObjectReferenceService _objectReferenceService;
    private ObjectTypesManager _objectTypesManager;
    private DocumentBuilderFactory dbFactory = DocumentBuilderFactorySource.INSTANCE.createDocumentBuilderFactory();
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
    private static final Log _logger = LogFactory.getLog(EventFormatter.class);

    public EventFormatter(ObjectReferenceService objectReferenceService, ObjectTypesManager objectTypesManager) {
        this._objectReferenceService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
    }

    private void parseLongDescription(EventListItemData itemData, ClientEventInfo eventInfo) {
        if (StringUtil.isNullOrEmpty((String)eventInfo.longDescription) || !this.looksLikeXml(eventInfo.longDescription)) {
            return;
        }
        try {
            DocumentBuilder dBuilder = this.dbFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(eventInfo.longDescription));
            Document doc = dBuilder.parse(is);
            NodeList descriptionEls = doc.getElementsByTagName("description");
            for (int i = 0; i < descriptionEls.getLength() && i < 1; ++i) {
                itemData.longDescription = descriptionEls.item(i).getTextContent();
            }
            NodeList causeEls = doc.getElementsByTagName("cause");
            EventCause[] causes = new EventCause[causeEls.getLength()];
            for (int i = 0; i < causeEls.getLength(); ++i) {
                NodeList causeChildren = causeEls.item(i).getChildNodes();
                causes[i] = new EventCause();
                for (int j = 0; j < causeChildren.getLength(); ++j) {
                    String nodeName = causeChildren.item(j).getNodeName();
                    String nodeValue = causeChildren.item(j).getTextContent();
                    if (nodeName.equals("description")) {
                        causes[i].description = nodeValue;
                        continue;
                    }
                    if (!nodeName.equals("action")) continue;
                    causes[i].action = nodeValue;
                }
            }
            itemData.causes = causes;
        }
        catch (Exception e) {
            _logger.warn((Object)("Failed to deserialize event long description XML for eventTypeId: " + eventInfo.eventTypeId));
        }
    }

    private boolean looksLikeXml(String longDescription) {
        return longDescription.startsWith("<");
    }

    public void setEventListItemData(EventListItemData itemData, ClientEventInfo eventInfo) {
        LinkableEntityParser l = new LinkableEntityParser();
        itemData.associatedEntities = eventInfo.associatedEntities;
        itemData.linkableEntities = l.getLinkableEntities(eventInfo);
        itemData.linkableFormattedMessage = eventInfo.linkableFormattedMessage;
        itemData.fullFormattedMessage = eventInfo.fullFormattedMessage;
        itemData.categoryKey = eventInfo.categoryKey;
        itemData.categoryName = eventInfo.categoryName;
        itemData.createdTime = eventInfo.createdTime.getTime();
        itemData.createdTimeText = this.dateFormatter.format(eventInfo.createdTime);
        itemData.userName = eventInfo.userName;
        itemData.nativeEventType = eventInfo.eventTypeId;
        itemData.serverGuid = eventInfo.serverGuid;
        itemData.key = eventInfo.key;
        itemData.chainId = eventInfo.chainId;
        this.parseLongDescription(itemData, eventInfo);
        ManagedObjectReference targetEntity = (ManagedObjectReference)eventInfo.targetEntityMor;
        if (targetEntity != null) {
            itemData.targetEntityId = this._objectReferenceService.getUid((Object)targetEntity);
            itemData.targetEntityName = eventInfo.targetEntityName;
            itemData.labelIds = eventInfo.labelIds;
            String targetType = targetEntity.getType();
            ObjectTypeSpec targetEntityTypeSpec = this._objectTypesManager.getObjectTypeSpec(targetType);
            if (targetEntityTypeSpec != null) {
                itemData.targetIcon = targetEntityTypeSpec.icon;
                if (targetType.equals("Folder") && targetEntity.getValue().equals("group-d1")) {
                    itemData.targetIcon = "vsphere-icon-vcenter";
                }
            } else {
                _logger.warn((Object)("No ObjectTypeSpec registered for: " + targetType));
            }
        }
    }
}

