/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.events;

import com.vmware.vim.binding.vim.event.AlarmEventArgument;
import com.vmware.vim.binding.vim.event.ComputeResourceEventArgument;
import com.vmware.vim.binding.vim.event.DatacenterEventArgument;
import com.vmware.vim.binding.vim.event.DatastoreEventArgument;
import com.vmware.vim.binding.vim.event.DvsEventArgument;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.HostEventArgument;
import com.vmware.vim.binding.vim.event.ManagedEntityEventArgument;
import com.vmware.vim.binding.vim.event.NetworkEventArgument;
import com.vmware.vim.binding.vim.event.ResourcePoolEventArgument;
import com.vmware.vim.binding.vim.event.VmEventArgument;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.core.model.event.ClientEventEntityInfo;
import com.vmware.vise.core.model.event.ClientEventInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkableEntityParser {
    public Map<String, ClientEventEntityInfo> getLinkableEntities(ClientEventInfo clientEventInfo) {
        HashMap<String, ClientEventEntityInfo> linkableEntitiesMap = new HashMap<String, ClientEventEntityInfo>();
        Pattern p = Pattern.compile("\\{[^{}]+\\}");
        Matcher m = p.matcher(clientEventInfo.linkableFormattedMessage);
        while (m.find()) {
            String entityString = m.group().substring(m.group().indexOf("{") + 1, m.group().indexOf("}"));
            linkableEntitiesMap.put(entityString, this.getClientEventEntityOf(entityString, clientEventInfo.serverEvent));
        }
        return linkableEntitiesMap;
    }

    private ClientEventEntityInfo getClientEventEntityOf(String entityString, Object serverEvent) {
        String[] fieldStrings = entityString.split("\\.");
        if (serverEvent instanceof EventEx) {
            EventEx event = (EventEx)serverEvent;
            if (event.arguments != null) {
                for (KeyAnyValue property : event.arguments) {
                    if (!property.getKey().equals(entityString)) continue;
                    return this.buildClientEventEntityInfoByEventArgument(property.getValue());
                }
            } else {
                return null;
            }
        }
        Object entityEventArgument = this.getEntityEventArgumentOf(fieldStrings[0], serverEvent);
        return this.buildClientEventEntityInfoByEventArgument(entityEventArgument);
    }

    private ClientEventEntityInfo buildClientEventEntityInfoByEventArgument(Object eventArgument) {
        ClientEventEntityInfo clientEventEntityInfo = null;
        if (eventArgument instanceof ComputeResourceEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((ComputeResourceEventArgument)eventArgument);
        } else if (eventArgument instanceof DatacenterEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DatacenterEventArgument)eventArgument);
        } else if (eventArgument instanceof DatastoreEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DatastoreEventArgument)eventArgument);
        } else if (eventArgument instanceof DvsEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DvsEventArgument)eventArgument);
        } else if (eventArgument instanceof HostEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((HostEventArgument)eventArgument);
        } else if (eventArgument instanceof NetworkEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((NetworkEventArgument)eventArgument);
        } else if (eventArgument instanceof VmEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((VmEventArgument)eventArgument);
        } else if (eventArgument instanceof ManagedEntityEventArgument) {
            ManagedEntityEventArgument managedEntityEventArgument = (ManagedEntityEventArgument)eventArgument;
            clientEventEntityInfo = new ClientEventEntityInfo(managedEntityEventArgument);
        } else if (eventArgument instanceof AlarmEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((AlarmEventArgument)eventArgument);
        } else if (eventArgument instanceof ResourcePoolEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((ResourcePoolEventArgument)eventArgument);
        }
        return clientEventEntityInfo;
    }

    private Object getEntityEventArgumentOf(String entityEventFieldName, Object serverEvent) {
        return this.findFieldFromObjectHierarchy(entityEventFieldName, serverEvent);
    }

    private Object findFieldFromObjectHierarchy(String fieldName, Object obj) {
        Class<?> objClass = obj.getClass();
        while (true) {
            try {
                Field f = objClass.getDeclaredField(fieldName);
                return f.get(obj);
            }
            catch (Exception exception) {
                if ((objClass = objClass.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }
}

