/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapabilityFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(CapabilityFilter.class);
    static final String CAPABILITY = "capability";
    static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String CAPABILITY_PREFIX = "capability.";
    private static final String NEGATION = "!";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;

    public CapabilityFilter(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = CAPABILITY;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        if (filterContext == null) {
            return extensionInfos;
        }
        Set<String> serverGuids = this.getServerGuids(filterContext);
        if (serverGuids.size() == 0) {
            return extensionInfos;
        }
        Object[] requestedCapabilities = CapabilityFilter.getRequestedCapabilites(extensionInfos);
        Map<String, Boolean> capabilityValues = new HashMap<String, Boolean>();
        if (!ArrayUtil.isNullOrEmpty((Object[])requestedCapabilities)) {
            try {
                ResultSet resultSet = this._queryService.select((String[])requestedCapabilities).from(new String[]{ServiceInstance.class.getSimpleName()}).where("@instanceUuid", PropertyPredicate.ComparisonOperator.IN, serverGuids).fetch();
                capabilityValues = CapabilityFilter.extractCapabilityValues((String[])requestedCapabilities, resultSet.getItems());
            }
            catch (Exception e) {
                _logger.error((Object)"Error when doing filter based on capability: ", (Throwable)e);
                return extensionInfos;
            }
        }
        List<ExtensionInfo> result = CapabilityFilter.filterExtensionsByCapability(extensionInfos, capabilityValues);
        return result;
    }

    private Set<String> getServerGuids(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        Object[] objectReferences = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        HashSet<String> serverGuids = new HashSet<String>();
        for (Object contextObject : objectReferences) {
            String serverGuid = this._objRefService.getServerGuid(contextObject);
            if (serverGuid == null) continue;
            serverGuids.add(serverGuid);
        }
        return serverGuids;
    }

    private static Map<String, Boolean> extractCapabilityValues(String[] requestedCapabilities, List<ResourceItem> resourceItems) {
        HashMap<String, Boolean> capabilityValues = new HashMap<String, Boolean>();
        if (!CollectionUtil.isNullOrEmpty(resourceItems)) {
            for (ResourceItem resourceItem : resourceItems) {
                for (String capabilityName : requestedCapabilities) {
                    boolean isSupported = true;
                    if (capabilityValues.containsKey(capabilityName)) {
                        isSupported = (Boolean)capabilityValues.get(capabilityName);
                    }
                    Object capabilityValue = resourceItem.get(capabilityName);
                    boolean value = false;
                    if (capabilityValue == null) {
                        value = false;
                    } else if (capabilityValue instanceof Boolean) {
                        value = Boolean.TRUE.equals(capabilityValue);
                    } else if (capabilityValue instanceof Integer) {
                        value = (Integer)capabilityValue != 0;
                    } else if (capabilityValue instanceof Long) {
                        value = (Long)capabilityValue != 0L;
                    }
                    capabilityValues.put(capabilityName, isSupported &= value);
                }
            }
        } else {
            for (String capabilityName : requestedCapabilities) {
                capabilityValues.put(capabilityName, true);
            }
        }
        return capabilityValues;
    }

    private static String[] getRequestedCapabilites(List<ExtensionInfo> extensionInfos) {
        HashSet<String> requestedCapabilities = new HashSet<String>();
        for (ExtensionInfo extension : extensionInfos) {
            String capability = (String)extension.getMetadata().get(CAPABILITY);
            if (StringUtil.isNullOrEmpty((String)capability)) {
                _logger.error((Object)("Invalid metadata for extension info: " + extension.getId()));
                continue;
            }
            capability = StringUtils.stripStart((String)capability, (String)NEGATION);
            String capabilityProperty = CAPABILITY_PREFIX + capability;
            requestedCapabilities.add(capabilityProperty);
        }
        return requestedCapabilities.toArray(new String[0]);
    }

    private static List<ExtensionInfo> filterExtensionsByCapability(List<ExtensionInfo> extensionInfos, Map<String, Boolean> capabilityMap) {
        ArrayList<ExtensionInfo> filteredExtensions = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extension : extensionInfos) {
            String capability = (String)extension.getMetadata().get(CAPABILITY);
            if (capability == null) {
                _logger.error((Object)("Invalid metadata for extension info: " + extension.getId()));
                continue;
            }
            boolean isNegated = capability.startsWith(NEGATION);
            capability = StringUtils.stripStart((String)capability, (String)NEGATION);
            String capabilityProperty = CAPABILITY_PREFIX + capability;
            boolean isSupported = Boolean.TRUE.equals(capabilityMap.get(capabilityProperty));
            if (!(isNegated ^ isSupported)) continue;
            filteredExtensions.add(extension);
        }
        return filteredExtensions;
    }
}

