/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.FeatureUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FeatureStateFilter
implements ExtensionObjectFilter {
    private static final String FEATURE_METADATA_TAG = "feature";
    private final PropertyInfo[] _filterProperties;
    private final FeatureStateService _featureStateService;

    @Autowired
    public FeatureStateFilter(FeatureStateService featureStateService) {
        this._featureStateService = featureStateService;
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = FEATURE_METADATA_TAG;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo ei : extensionInfos) {
            String featureExpression = (String)ei.getMetadata().get(FEATURE_METADATA_TAG);
            boolean filteredOut = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)featureExpression);
            if (filteredOut) continue;
            result.add(ei);
        }
        return result;
    }
}

