/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderTypeFilter
implements ExtensionObjectFilter {
    private static final String FOLDER_TYPE = "folderType";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String DC_FOLDER_TYPE = "DatacenterFolder";
    private static final String VM_FOLDER_TYPE = "VirtualMachineFolder";
    private static final String DS_FOLDER_TYPE = "DatastoreFolder";
    private static final String HOST_FOLDER_TYPE = "HostFolder";
    private static final String NETWORK_FOLDER_TYPE = "NetworkFolder";
    private static final String ROOT_FOLDER = "RootFolder";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;

    public FolderTypeFilter() {
        PropertyInfo filterProp = new PropertyInfo();
        filterProp.name = FOLDER_TYPE;
        filterProp.type = String.class.getName();
        filterProp.optional = false;
        this._filterProperties = new PropertyInfo[]{filterProp};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        Object[] contextObjects = this.getContextObjects(filterContext);
        if (contextObjects.length != 1) {
            return extensionInfos;
        }
        Object contextObject = contextObjects[0];
        if (!(contextObject instanceof ManagedObjectReference)) {
            return extensionInfos;
        }
        ManagedObjectReference entity = (ManagedObjectReference)contextObject;
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo ei : extensionInfos) {
            String eiFolderType = (String)ei.getMetadata().get(FOLDER_TYPE);
            if (StringUtil.isNullOrWhitespace((String)eiFolderType) || !(eiFolderType = eiFolderType.trim()).equalsIgnoreCase(this.getFolderType(entity))) continue;
            result.add(ei);
        }
        return result;
    }

    private Object[] getContextObjects(Map<String, Object> filterContext) {
        if (filterContext == null) {
            return new Object[0];
        }
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        if (contextObjects == null) {
            return new Object[0];
        }
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        return objectArr;
    }

    private String getFolderType(ManagedObjectReference entity) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)entity)) {
            return ROOT_FOLDER;
        }
        if (ManagedObjectUtil.isDatacenterFolder((ManagedObjectReference)entity)) {
            return DC_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isStorageFolder((ManagedObjectReference)entity)) {
            return DS_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)entity)) {
            return VM_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)entity)) {
            return HOST_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isNetworkFolder((ManagedObjectReference)entity)) {
            return NETWORK_FOLDER_TYPE;
        }
        return "";
    }
}

