/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class GlobalPrivilegeFilter
implements ExtensionObjectFilter {
    private static final String GLOBAL_FILTER_METADATA_TAG = "globalPrivileges";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String GLOBAL_OBJECT = "urn:vri:acl:RootPermissionNode:root";
    private static final String PRECLUSION_SIGN = "!";
    private static final String CACHED_GLOBAL_PRIVILEGES = "cachedGlobalPrivileges";
    private final PropertyInfo[] _filterProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public GlobalPrivilegeFilter(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryServiceFactory, objectReferenceService});
        this._queryService = queryServiceFactory.getQueryService();
        this._objectReferenceService = objectReferenceService;
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = GLOBAL_FILTER_METADATA_TAG;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extensionInfos});
        if (!this.isPrivilegeCheckNeeded(extensionInfos)) {
            return extensionInfos;
        }
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        Set<String> privileges = null;
        ConcurrentMap<String, Boolean> cachedGlobalPrivileges = this.getSessionCache();
        if (cachedGlobalPrivileges == null) {
            cachedGlobalPrivileges = this.createSessionCache();
            privileges = this.getPrivileges();
        }
        for (ExtensionInfo ei : extensionInfos) {
            String[] globalPrivileges = ((String)ei.getMetadata().get(GLOBAL_FILTER_METADATA_TAG)).split(",");
            this.updateCachedPrivileges(cachedGlobalPrivileges, globalPrivileges, privileges);
            if (!this.hasAllPrivileges(cachedGlobalPrivileges, globalPrivileges)) continue;
            result.add(ei);
        }
        return result;
    }

    private void updateCachedPrivileges(ConcurrentMap<String, Boolean> cachedGlobalPrivileges, String[] globalPrivileges, @Nullable Set<String> privileges) {
        Set<String> allPrivileges = privileges;
        for (String globalPrivilege : globalPrivileges) {
            String priv = this.escape(globalPrivilege);
            Boolean hasPrivilege = (Boolean)cachedGlobalPrivileges.get(priv);
            if (hasPrivilege != null) continue;
            if (allPrivileges == null) {
                allPrivileges = this.getPrivileges();
            }
            cachedGlobalPrivileges.putIfAbsent(priv, allPrivileges.contains(priv));
        }
    }

    private boolean hasAllPrivileges(ConcurrentMap<String, Boolean> cachedPrivileges, String[] globalPrivileges) {
        for (String globalPrivilege : globalPrivileges) {
            boolean precluded = this.isPrecluded(globalPrivilege);
            String priv = this.escape(globalPrivilege);
            Boolean hasPrivilege = (Boolean)cachedPrivileges.get(priv);
            if (hasPrivilege == null) {
                return false;
            }
            if (precluded) {
                hasPrivilege = hasPrivilege == false;
            }
            if (hasPrivilege.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Set<String> getPrivileges() {
        Object ref = this._objectReferenceService.getReference(GLOBAL_OBJECT, true);
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Collections.singletonList(ref)));
        String[] resourceModels = new String[]{this._objectReferenceService.getResourceObjectType(ref)};
        String[] props = new String[]{GRANTED_PRIVILEGES_PROP};
        ResultSet resultSet = this._queryService.select(props).from(resourceModels).where(LogicalOperator.AND, filter).fetch();
        String[] results = (String[])((ResourceItem)resultSet.getItems().get(0)).get(GRANTED_PRIVILEGES_PROP);
        HashSet<String> privilegeSet = new HashSet<String>();
        if (results != null) {
            Collections.addAll(privilegeSet, results);
        }
        return privilegeSet;
    }

    private boolean isPrivilegeCheckNeeded(List<ExtensionInfo> extensionInfos) {
        for (ExtensionInfo ei : extensionInfos) {
            if (ei.getMetadata() == null || StringUtil.isNullOrEmpty((String)((String)ei.getMetadata().get(GLOBAL_FILTER_METADATA_TAG)))) continue;
            return true;
        }
        return false;
    }

    private boolean isPrecluded(String privilege) {
        return privilege.startsWith(PRECLUSION_SIGN);
    }

    private String escape(String privilege) {
        return this.isPrecluded(privilege) ? privilege.trim().substring(1) : privilege.trim();
    }

    protected ConcurrentMap<String, Boolean> getSessionCache() {
        return (ConcurrentMap)SessionUtil.getData((String)CACHED_GLOBAL_PRIVILEGES);
    }

    protected ConcurrentMap<String, Boolean> createSessionCache() {
        ConcurrentHashMap<String, Boolean> cache = new ConcurrentHashMap<String, Boolean>(4);
        ConcurrentHashMap prev = (ConcurrentHashMap)SessionUtil.setDataIfAbsent((String)CACHED_GLOBAL_PRIVILEGES, cache);
        if (prev != null) {
            return prev;
        }
        return cache;
    }
}

