/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.mvc.filters.PluginExtensionFilter;
import com.vmware.vise.util.IdVersionPair;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.Validate;

public class LocalPluginExtensionFilter
extends PluginExtensionFilter {
    public LocalPluginExtensionFilter(ExtensionService extensionService) {
        super(extensionService);
    }

    @Override
    protected boolean isValidExtension(ExtensionInfo ei, IdVersionPair pluginRef, PluginPackageInfo pluginPackageInfo, String ctxObjectString) {
        Validate.notNull((Object)ei);
        Validate.notNull((Object)pluginRef);
        Validate.notNull((Object)pluginPackageInfo);
        Validate.notNull((Object)ctxObjectString);
        if (!pluginPackageInfo.isLocalPluginPackage()) {
            return true;
        }
        ConcurrentMap metadata = pluginPackageInfo.getMetadata();
        if (metadata == null) {
            return true;
        }
        String[] guids = (String[])metadata.get("vcServerGuids");
        if (guids == null) {
            return true;
        }
        for (String guid : guids) {
            if (!ctxObjectString.contains(guid)) continue;
            return true;
        }
        return false;
    }
}

