/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.extensionfw.impl.plugin.data.RemotePluginExtensionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrivateExtensionPointsFilter
implements ExtensionObjectFilter {
    private static final Map<RemotePluginExtensionType, List<String>> PRIVATE_EXT_TYPE_TO_WHITELISTED_PLUGIN_ID = new HashMap<RemotePluginExtensionType, List<String>>();
    private static final String APP_DEFENSE_REMOTE_PLUGIN_ID = "com.vmware.appd.shim";

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : extensionInfos) {
            if (!this.isValidExtensionInfo(extensionInfo)) continue;
            result.add(extensionInfo);
        }
        return result;
    }

    private boolean isValidExtensionInfo(ExtensionInfo ei) {
        if (ei.getRemotePluginExtensionInfo() == null || ei.getRemotePluginExtensionInfo().aggregationInfo == null) {
            return true;
        }
        RemotePluginExtensionType extType = ei.getRemotePluginExtensionInfo().extensionType;
        String pluginId = ei.getRemotePluginExtensionInfo().aggregationInfo.aggregatedPluginId;
        return PRIVATE_EXT_TYPE_TO_WHITELISTED_PLUGIN_ID.get(extType) == null || PRIVATE_EXT_TYPE_TO_WHITELISTED_PLUGIN_ID.get(extType).contains(pluginId);
    }

    static {
        PRIVATE_EXT_TYPE_TO_WHITELISTED_PLUGIN_ID.put(RemotePluginExtensionType.DEPLOYMENT_NAVIGATOR_NODE, Collections.singletonList(APP_DEFENSE_REMOTE_PLUGIN_ID));
        PRIVATE_EXT_TYPE_TO_WHITELISTED_PLUGIN_ID.put(RemotePluginExtensionType.DEPLOYMENT_VIEW, Collections.singletonList(APP_DEFENSE_REMOTE_PLUGIN_ID));
    }
}

