/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrivilegeFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(PrivilegeFilter.class);
    private static final String PRIVILEGE_PROPERTY = "privilege";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String PRECLUSION_SIGN = "!";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;

    public PrivilegeFilter(ObjectReferenceService objRefService, QueryServiceFactory queryServiceFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRefService, queryServiceFactory});
        this._queryService = queryServiceFactory.getQueryService();
        this._objRefService = objRefService;
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = PRIVILEGE_PROPERTY;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extensionInfos, filterContext});
        if (!this.isPrivilegeCheckNeeded(extensionInfos)) {
            return extensionInfos;
        }
        Object[] contextObjects = this.findContextObjects(filterContext);
        if (ArrayUtil.isNullOrEmpty((Object[])contextObjects) || contextObjects[0] == null) {
            return Collections.emptyList();
        }
        Map<String, List<Object>> objectsByType = this.groupObjectsByType(contextObjects);
        if (objectsByType.isEmpty()) {
            _logger.error((Object)("No type found for a single context object! objects: " + Arrays.toString(contextObjects)));
            return extensionInfos;
        }
        return this.findValidExtensions(extensionInfos, contextObjects, objectsByType);
    }

    protected List<ManagedObjectReference> findRootFolders() {
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (registry == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedObjectReference> rootFolders = new ArrayList<ManagedObjectReference>();
        for (LinkedVcGroup group : registry.getLinkedVcGroups()) {
            if (group == null) continue;
            for (VcService vc : group.getVcServices()) {
                ServiceInstanceContent sic;
                if (vc == null || (sic = vc.getServiceInstanceContent()) == null) continue;
                rootFolders.add(sic.getRootFolder());
            }
        }
        return rootFolders;
    }

    private List<ExtensionInfo> findValidExtensions(List<ExtensionInfo> extensionInfos, Object[] contextObjects, Map<String, List<Object>> objectsByType) {
        ArrayList<ExtensionInfo> validExtensions = new ArrayList<ExtensionInfo>();
        Map<Object, List<String>> privilegesByObj = this.createPrivilegesByObject(objectsByType);
        for (ExtensionInfo ei : extensionInfos) {
            if (!this.isExtensionValid(ei, privilegesByObj, contextObjects)) continue;
            validExtensions.add(ei);
        }
        return validExtensions;
    }

    private Map<String, List<Object>> groupObjectsByType(Object[] contextObjects) {
        HashMap<String, List<Object>> objectsByType = new HashMap<String, List<Object>>();
        for (Object contextObj : contextObjects) {
            String type2 = this._objRefService.getResourceObjectType(contextObj);
            if (type2 == null) {
                _logger.error((Object)("Unknown type for reference: " + contextObj));
                continue;
            }
            ArrayList<Object> objects = (ArrayList<Object>)objectsByType.get(type2);
            if (objects == null) {
                objects = new ArrayList<Object>();
                objectsByType.put(type2, objects);
            }
            objects.add(contextObj);
        }
        return objectsByType;
    }

    private Map<Object, List<String>> createPrivilegesByObject(Map<String, List<Object>> objectsByType) {
        HashMap<Object, List<String>> privilegesByObj = new HashMap<Object, List<String>>();
        for (Map.Entry<String, List<Object>> entry : objectsByType.entrySet()) {
            ResultSet result = this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{entry.getKey()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, entry.getValue()).fetch();
            for (ResourceItem ri : result.getItems()) {
                privilegesByObj.put(ri.getKey(), Arrays.asList((String[])ri.get("grantedPrivileges")));
            }
        }
        return privilegesByObj;
    }

    private boolean isExtensionValid(ExtensionInfo ei, Map<Object, List<String>> privilegesByObj, Object[] contextObjects) {
        if (ei.getMetadata() == null) {
            return true;
        }
        String privilege = (String)ei.getMetadata().get(PRIVILEGE_PROPERTY);
        if (StringUtil.isNullOrEmpty((String)privilege)) {
            return true;
        }
        for (Object contextObject : contextObjects) {
            List<String> grantedPrivileges = privilegesByObj.get(contextObject);
            if (grantedPrivileges == null) {
                _logger.error((Object)("Null grantedPrivileges for: " + contextObject));
                continue;
            }
            if (this.isPrivilegeGranted(privilege, grantedPrivileges)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrivilegeGranted(String privilege, List<String> grantedPrivileges) {
        String[] privilegeIds = privilege.split(",");
        ArrayList<String> precluded = new ArrayList<String>();
        ArrayList<String> required = new ArrayList<String>();
        for (String privilegeId : privilegeIds) {
            if (privilegeId.startsWith(PRECLUSION_SIGN)) {
                precluded.add(privilegeId.substring(1));
                continue;
            }
            required.add(privilegeId);
        }
        for (String id : precluded) {
            if (grantedPrivileges.indexOf(id) == -1) continue;
            return false;
        }
        for (String id : required) {
            if (grantedPrivileges.indexOf(id) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean isPrivilegeCheckNeeded(List<ExtensionInfo> extensionInfos) {
        for (ExtensionInfo ei : extensionInfos) {
            if (ei.getMetadata() == null || StringUtil.isNullOrEmpty((String)((String)ei.getMetadata().get(PRIVILEGE_PROPERTY)))) continue;
            return true;
        }
        return false;
    }

    private Object[] findContextObjects(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        if (contextObjects == null) {
            return this.findRootFolders().toArray(new Object[0]);
        }
        if (contextObjects instanceof Object[]) {
            return (Object[])contextObjects;
        }
        return new Object[]{contextObjects};
    }
}

