/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TypeFilter
implements ExtensionObjectFilter {
    private static final String OBJECT_TYPE = "objectType";
    public static final String CONTEXT_OBJECTS = "contextObjects";
    public static final String NO_OBJECT = "NO_OBJECT";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final ObjectReferenceService _objRefService;

    @Autowired
    public TypeFilter(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        PropertyInfo filterProp = new PropertyInfo();
        filterProp.name = OBJECT_TYPE;
        filterProp.type = String.class.getName();
        filterProp.optional = false;
        this._filterProperties = new PropertyInfo[]{filterProp};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        if (filterContext == null) {
            return extensionInfos;
        }
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        Set<String> objectTypes = this.getObjectTypes(contextObjects);
        for (ExtensionInfo ei : extensionInfos) {
            String eiType = (String)ei.getMetadata().get(OBJECT_TYPE);
            if (StringUtil.isNullOrEmpty((String)(eiType = eiType.trim()))) continue;
            boolean isNegated = this.isNegatedExpression(eiType);
            String[] eiTypes = this.getEiObjectTypes(eiType);
            boolean match = true;
            for (String objectType : objectTypes) {
                if (this.matchType(objectType, eiTypes, isNegated)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            result.add(ei);
        }
        return result;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    private Set<String> getObjectTypes(Object contextObjects) {
        HashSet<String> objectTypes = new HashSet<String>();
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        for (Object ref : objectArr) {
            String type2 = null;
            type2 = ref instanceof String && NO_OBJECT.equals(ref) ? NO_OBJECT : this._objRefService.getResourceObjectType(ref);
            objectTypes.add(type2);
        }
        return objectTypes;
    }

    private boolean matchType(String objectType, String[] types, boolean isNegated) {
        boolean objectTypeMatches = false;
        for (String type2 : types) {
            if (!objectType.equals(type2)) continue;
            objectTypeMatches = true;
        }
        if (isNegated) {
            return !objectTypeMatches;
        }
        return objectTypeMatches;
    }

    private String[] splitAndTrim(String eiType, String delimiter) {
        String[] types = eiType.split(delimiter);
        for (int i = 0; i < types.length; ++i) {
            types[i] = types[i].trim();
        }
        return types;
    }

    private String[] getEiObjectTypes(String eiType) {
        String expression = null;
        expression = eiType.startsWith("!(") && eiType.endsWith(")") ? eiType.substring(2, eiType.length() - 1) : eiType;
        String[] returnVal = this.splitAndTrim(expression, ",");
        return returnVal;
    }

    private boolean isNegatedExpression(String eiType) {
        return eiType.startsWith("!(") && eiType.endsWith(")");
    }
}

