/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VSphereObjectViewFilter
implements ExtensionObjectFilter {
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final List<String> VSPHERE_OBJECT_VALUES = Arrays.asList(VirtualMachine.class.getSimpleName(), HostSystem.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), VirtualApp.class.getSimpleName(), ResourcePool.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), Network.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), "com.vmware.content.Library", "com.vmware.content.library.Item");
    private static final Set<String> VSPHERE_OBJECTS = new HashSet<String>(VSPHERE_OBJECT_VALUES);
    private static final List<String> VALID_PLUGIN_PACKAGES = Arrays.asList("com.vmware.vsphere.client", "com.vmware.vum.client", "com.vmware.vum.remote", "com.vmware.__defaultPluginPackage__");
    private static final String VSPHERE_TOP_VIEW_PREFIX = "vsphere.core.";
    private static final String VSPHERE_TOP_VIEW_SUFFIX = ".views";
    private final PropertyInfo[] _contextProperties;
    private final ObjectReferenceService _objRefService;

    public VSphereObjectViewFilter(ObjectReferenceService objRefService) {
        this._objRefService = objRefService;
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        Object[] contextObjects = this.getContextObjects(filterContext);
        if (contextObjects.length != 1) {
            return extensionInfos;
        }
        Object contextObject = contextObjects[0];
        String objectType = this._objRefService.getResourceObjectType(contextObject);
        if (!VSPHERE_OBJECTS.contains(objectType)) {
            return extensionInfos;
        }
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extInfo : extensionInfos) {
            String pluginPackageId;
            if (extInfo.getExtendedPointIds() == null) continue;
            boolean isViewHostedByTopLevelvSphereTab = false;
            for (String extendedPointId : extInfo.getExtendedPointIds()) {
                if (!extendedPointId.startsWith(VSPHERE_TOP_VIEW_PREFIX) || !extendedPointId.endsWith(VSPHERE_TOP_VIEW_SUFFIX)) continue;
                isViewHostedByTopLevelvSphereTab = true;
                break;
            }
            if (!isViewHostedByTopLevelvSphereTab) {
                result.add(extInfo);
                continue;
            }
            Map metadata = extInfo.getMetadata();
            Object pckId = metadata.get("pluginPackageId");
            if (!(pckId instanceof String) || !VALID_PLUGIN_PACKAGES.contains(pluginPackageId = (String)pckId)) continue;
            result.add(extInfo);
        }
        return result;
    }

    private Object[] getContextObjects(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        if (contextObjects == null) {
            return new Object[0];
        }
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        return objectArr;
    }
}

