/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.lists.util;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.lists.ColumnDataSourceInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ListUtil {
    private static final Log _logger = LogFactory.getLog(ListUtil.class);
    public static final String[] DEFAULT_PROPERTIES = new String[]{"name", "primaryIconId", "labelIds"};

    public static String[] getPropertiesToFetch(ExtensionService extensionService, String listViewId) {
        ExtensionInfo ei = null;
        try {
            ei = extensionService.getExtensionInfo(listViewId);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when fetching extension info for " + listViewId));
            return DEFAULT_PROPERTIES;
        }
        if (ei == null) {
            return DEFAULT_PROPERTIES;
        }
        if (ei.getHostedPointsIds().length > 1) {
            throw new IllegalArgumentException("Multiple hosted point ids not supported, extension id: " + listViewId);
        }
        String columnPointId = ei.getHostedPointsIds()[0];
        ArrayList properties = new ArrayList();
        List columns = extensionService.getExtensionObjects(columnPointId, null, false);
        for (ColumnDataSourceInfo column : columns) {
            if (column.requestedProperties == null) continue;
            CollectionUtils.mergeArrayIntoCollection((Object)column.requestedProperties, properties);
        }
        if (properties.size() == 0) {
            return DEFAULT_PROPERTIES;
        }
        return properties.toArray(new String[0]);
    }
}

