/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.model.data;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.core.model.annotation.Dto;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

@Dto
public class PropertyPredicateSpec {
    private String property;
    private PredicateComparisonOperator operator;
    private Object comparableValue;
    private boolean ignoreCase;

    public PropertyPredicateSpec() {
    }

    public PropertyPredicateSpec(String property, PredicateComparisonOperator operator, Object comparableValue, boolean ignoreCase) {
        Validate.notEmpty((String)property, (String)"Argument `property' must not be null or empty.");
        Validate.notNull((Object)((Object)operator), (String)"Argument `operator' must not be null.");
        Validate.notNull((Object)comparableValue, (String)"Argument `comparableValue' must not be null.");
        this.property = property;
        this.operator = operator;
        this.comparableValue = comparableValue;
        this.ignoreCase = ignoreCase;
    }

    public String getProperty() {
        return this.property;
    }

    public PredicateComparisonOperator getOperator() {
        return this.operator;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="_type")
    public Object getComparableValue() {
        if (this.comparableValue.getClass().isArray() && (PredicateComparisonOperator.IN.equals((Object)this.operator) || PredicateComparisonOperator.NOT_IN.equals((Object)this.operator))) {
            return Arrays.asList((Object[])this.comparableValue);
        }
        return this.comparableValue;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public PropertyPredicate buildPropertyPredicateFromSpec() {
        Validate.notEmpty((String)this.property);
        Validate.notNull((Object)((Object)this.operator));
        Validate.notNull((Object)this.comparableValue);
        return new PropertyPredicate(this.property, this.getComparisonOperator(), this.getComparableValue(), this.ignoreCase);
    }

    private PropertyPredicate.ComparisonOperator getComparisonOperator() {
        return PropertyPredicate.ComparisonOperator.values()[this.operator.ordinal()];
    }

    @Dto
    public static enum PredicateComparisonOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_OR_EQUAL,
        LESS,
        LESS_OR_EQUAL,
        IN,
        NOT_IN,
        LIKE,
        UNSET;

    }
}

