/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.notifications;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.notifications.NotificationData;
import com.vmware.vise.vim.commons.notifications.NotificationsDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginDeploymentNotificationProvider
implements NotificationsDataProvider {
    private static final Log _logger = LogFactory.getLog(PluginDeploymentNotificationProvider.class);
    private static final String SESSION_PACKAGES_REFS = "PluginPackagesRefs";
    private static final String PLUGIN_NAMES = "pluginNames";
    private final ExtensionService _extensionService;

    public PluginDeploymentNotificationProvider(ExtensionService extensionService) {
        this._extensionService = extensionService;
    }

    public List<NotificationData> getNotificationData() {
        PluginInfo[] allPluginInfos;
        try {
            allPluginInfos = this._extensionService.getFilteredPluginInfos();
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving filtered plugin package infos", (Throwable)e);
            return Collections.emptyList();
        }
        List<String> pluginNames = this.getNewPluginPackageNames(allPluginInfos);
        return this.createNotificationList(pluginNames);
    }

    private List<NotificationData> createNotificationList(List<String> pluginNames) {
        ArrayList<NotificationData> resultList = new ArrayList<NotificationData>();
        NotificationData notification = new NotificationData();
        notification.type = "plugin-deployment-notification";
        notification.notification = new HashMap();
        notification.notification.put(PLUGIN_NAMES, pluginNames);
        resultList.add(notification);
        return resultList;
    }

    private List<String> getNewPluginPackageNames(PluginInfo[] pluginInfos) {
        Set<IdVersionPair> packageRefsAtLogin = this.getDeployedPackagesFromSession();
        HashSet<IdVersionPair> newPluginPackageRefs = new HashSet<IdVersionPair>();
        ArrayList<String> newPluginPackageNames = new ArrayList<String>();
        for (PluginInfo pluginInfo : pluginInfos) {
            IdVersionPair packageRef = pluginInfo.getPackageRef();
            if (packageRef == null || packageRefsAtLogin.contains(packageRef) || newPluginPackageRefs.contains(packageRef)) continue;
            newPluginPackageRefs.add(packageRef);
            newPluginPackageNames.add(this.getPluginPackageName(packageRef));
        }
        return newPluginPackageNames;
    }

    private String getPluginPackageName(IdVersionPair packageRef) {
        PluginPackageInfo pluginPackageInfo = this._extensionService.getPluginPackageInfo(packageRef);
        if (pluginPackageInfo != null && pluginPackageInfo.getName() != null && !pluginPackageInfo.getName().isEmpty()) {
            return pluginPackageInfo.getName();
        }
        return packageRef.getId();
    }

    private Set<IdVersionPair> getDeployedPackagesFromSession() {
        Set packageRefs = (Set)SessionUtil.getData((String)SESSION_PACKAGES_REFS);
        return packageRefs == null ? Collections.emptySet() : packageRefs;
    }
}

