/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator.interpreter;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.mvc.model.ObjectSpec;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.mvc.objectnavigator.util.ObjectNavigatorUtil;
import com.vmware.vise.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CategoryNodeNavReqInterpreter
implements NavigationRequestInterpreter {
    private static final Log _logger = LogFactory.getLog(CategoryNodeNavReqInterpreter.class);
    private final ObjectNavigatorManager _objectNavigatorManager;

    @Autowired
    public CategoryNodeNavReqInterpreter(ObjectNavigatorManager objectNavigatorManager) {
        this._objectNavigatorManager = objectNavigatorManager;
    }

    @Override
    public NavigationResponse interpretNavigationRequest(NavigationRequest navRequest) {
        NavigationResponse navResponse;
        if (!StringUtil.isNullOrEmpty((String)navRequest.contextObject) && navRequest.navigator != null) {
            return null;
        }
        ExtensionInfo rootExtension = ObjectNavigatorUtil.getRootExtension(navRequest.extensionPaths);
        String rootExtensionId = rootExtension != null ? rootExtension.getId() : null;
        List<ObjectNavigatorNodeSpec> nodeSpecs = this._objectNavigatorManager.getNodeSpecs();
        List<ObjectNavigatorNodeSpec> navigableNodeSpecs = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(navRequest.targetViewId, nodeSpecs);
        ObjectNavigatorNodeSpec selectedNode = this._objectNavigatorManager.getNodeByNavigationTargetUid(navRequest.targetViewId, navigableNodeSpecs);
        if (selectedNode == null && !StringUtil.isNullOrEmpty((String)rootExtensionId)) {
            navigableNodeSpecs = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(rootExtensionId, nodeSpecs);
            selectedNode = this._objectNavigatorManager.getNodeByNavigationTargetUid(rootExtensionId, navigableNodeSpecs);
        }
        if (selectedNode == null) {
            return null;
        }
        ObjectNavigatorNodeSpec nodeToBeFocused = this._objectNavigatorManager.getClosestAncestorNodeThatCanBeFocused(selectedNode.getUid(), navigableNodeSpecs);
        if (nodeToBeFocused == null) {
            _logger.warn((Object)("interpretNavigationRequest(): Parent node is not set for selectedNode: " + selectedNode.getUid() + " ,targetViewUId=" + navRequest.targetViewId));
            return null;
        }
        String selectedNodeId = null;
        if (!nodeToBeFocused.getUid().equals(selectedNode.getUid())) {
            selectedNodeId = selectedNode.getUid();
        }
        if ((navResponse = this.createNavigationResponse(nodeToBeFocused)) != null && selectedNodeId != null) {
            HashMap<String, String> viewState = new HashMap<String, String>();
            viewState.put("selectedNodeId", selectedNodeId);
            navResponse.viewState = viewState;
        }
        return navResponse;
    }

    private NavigationResponse createNavigationResponse(ObjectNavigatorNodeSpec nodeToBeFocused) {
        ObjectSpec viewSpec;
        NavigationResponse navResponse = null;
        if (nodeToBeFocused != null && (viewSpec = nodeToBeFocused.getViewOpenedUponFocus()) != null) {
            viewSpec.setUid(nodeToBeFocused.getUid());
            navResponse = new NavigationResponse();
            navResponse.uid = nodeToBeFocused.getUid();
            navResponse.title = nodeToBeFocused.title;
            navResponse.icon = nodeToBeFocused.icon;
            navResponse.viewSpec = viewSpec;
        }
        return navResponse;
    }
}

