/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.ResourceObject;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.search.model.FilterCriteria;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchCriteria;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SearchManagerImpl
implements SearchManager {
    private final ObjectReferenceService _objRefService;
    private final ObjectTypesManager _objectTypesManager;
    private final ExtensionService _extensionService;
    private final QueryService _queryService;
    private final ConcurrentMap<String, ISearchableTypeFormatter> _typeFormatters;

    @Autowired
    public SearchManagerImpl(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ObjectTypesManager objectTypesManager, ExtensionService extensionService, QueryServiceFactory queryServiceFactory) {
        this._objRefService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
        this._extensionService = extensionService;
        this._queryService = queryServiceFactory.getQueryService();
        this._typeFormatters = new ConcurrentHashMap<String, ISearchableTypeFormatter>();
    }

    @Override
    public List<QuickSearchResult> getQuickSearchResults(String query, String opId) throws Exception {
        ResultSet resultSet = this.getData(query, Arrays.asList(QUICK_SEARCH_PROPERTIES), 10, "QuickSearch" + opId);
        return this.formatQuickSearchResults(resultSet);
    }

    @Override
    public List<SearchTypeData> getSearchResults(String query, SearchCriteria searchCriteria, String opId) throws Exception {
        ResultSet resultSet = this.getSearchData(query, searchCriteria, opId);
        return this.formatSimpleSearchResults(resultSet);
    }

    @Override
    public List<SearchTypeData> getSimpleSearchResults(String query, String opId) throws Exception {
        ResultSet resultSet = this.getData(query, Collections.emptyList(), 1000, "SimpleSearch" + opId);
        return this.formatSimpleSearchResults(resultSet);
    }

    @Override
    public void registerSearchableTypeFormatter(ISearchableTypeFormatter formatter) {
        if (formatter == null || formatter.getObjectType() == null) {
            throw new IllegalArgumentException("Invalid ISearchableTypeFormatter.");
        }
        this._typeFormatters.put(formatter.getObjectType(), formatter);
    }

    private ResultSet getData(String query, List<String> properties, int limit, String opId) {
        QueryCommand command = this._queryService.select(properties).from(new String[]{"QuickSearch"}).where("searchTerm", PropertyPredicate.ComparisonOperator.EQUAL, (Object)query).orderBy("@modelKey").limit(limit).opId(opId).build();
        return command.fetch();
    }

    private ResultSet getSearchData(String query, SearchCriteria searchCriteria, String opId) throws Exception {
        String queryModel = searchCriteria.queryModel.toString();
        List<PropertyPredicate> predicates = this.getPropertyPredicates(searchCriteria.filters);
        PropertyPredicate queryPredicate = this.getPropertyPredicateForQuery(searchCriteria.queryModel, query);
        if (queryPredicate != null) {
            predicates.add(queryPredicate);
        }
        int maxLimit = searchCriteria.maxResults != null ? searchCriteria.maxResults : 1000;
        List<String> properties = searchCriteria.properties == null ? Collections.EMPTY_LIST : Arrays.asList(searchCriteria.properties);
        QueryCommand command = this._queryService.select(properties).from(new String[]{queryModel}).where(LogicalOperator.AND, predicates).orderBy("@modelKey").limit(maxLimit).opId("SimpleSearch" + opId).withTotalCount().build();
        return command.fetch();
    }

    private List<PropertyPredicate> getPropertyPredicates(FilterCriteria[] filters) throws Exception {
        ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>(filters.length);
        for (FilterCriteria filter : filters) {
            predicates.add(new PropertyPredicate(filter.name, filter.arrayOperator, filter.comparisonOperator, filter.value));
        }
        return predicates;
    }

    private PropertyPredicate getPropertyPredicateForQuery(SearchCriteria.QueryModel queryModel, String query) {
        if (query == null || query.isEmpty()) {
            return null;
        }
        if (queryModel.equals((Object)SearchCriteria.QueryModel.QUICK_SEARCH)) {
            return new PropertyPredicate("searchTerm", PropertyPredicate.ComparisonOperator.EQUAL, (Object)query);
        }
        String wildCardQuery = "*" + query + "*";
        return new PropertyPredicate("name", PropertyPredicate.ComparisonOperator.LIKE, (Object)wildCardQuery);
    }

    private List<QuickSearchResult> formatQuickSearchResults(ResultSet resultSet) {
        String objectType;
        HashMap resourceObjectsByType = new HashMap();
        ArrayList<QuickSearchResult> searchResults = new ArrayList<QuickSearchResult>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            objectType = this._objRefService.getResourceObjectType(resourceItem.getKey());
            if (objectType == null || this._objectTypesManager.getObjectTypeSpec(objectType) == null) continue;
            ResourceObject resourceObject = new ResourceObject();
            ISearchableTypeFormatter typeFormatter = (ISearchableTypeFormatter)this._typeFormatters.get(objectType);
            if (typeFormatter != null) {
                resourceObject.name = typeFormatter.getName(resourceItem);
                resourceObject.type = typeFormatter.getRuntimeType(resourceItem);
                resourceObject.id = this._objRefService.getUid(typeFormatter.getNavigationEntity(resourceItem));
            } else {
                resourceObject.name = (String)resourceItem.get("name");
                resourceObject.type = objectType;
                resourceObject.id = this._objRefService.getUid(resourceItem.getKey());
            }
            ArrayList<ResourceObject> set = resourceObjectsByType.containsKey(resourceObject.type) ? (List)resourceObjectsByType.get(resourceObject.type) : new ArrayList<ResourceObject>();
            set.add(resourceObject);
            resourceObjectsByType.put(resourceObject.type, set);
        }
        for (Map.Entry entry : resourceObjectsByType.entrySet()) {
            objectType = (String)entry.getKey();
            String icon = "";
            String labelPlural = objectType;
            String label = objectType;
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(objectType);
            if (objectTypeSpec != null) {
                labelPlural = objectTypeSpec.labelPlural;
                label = objectTypeSpec.label;
                icon = objectTypeSpec.icon;
            }
            QuickSearchResult quickSearchResult = new QuickSearchResult();
            quickSearchResult.icon = icon;
            quickSearchResult.labelPlural = labelPlural;
            quickSearchResult.label = label;
            quickSearchResult.results = (List)entry.getValue();
            searchResults.add(quickSearchResult);
        }
        return searchResults;
    }

    private List<SearchTypeData> formatSimpleSearchResults(ResultSet resultSet) throws Exception {
        ArrayList<SearchTypeData> resultTypes = new ArrayList<SearchTypeData>();
        HashMap objectIdsByType = new HashMap();
        HashMap<String, Object[]> propertiesByObjectId = new HashMap<String, Object[]>();
        for (ResourceItem resultItem : resultSet.getItems()) {
            String objectType = this._objRefService.getResourceObjectType(resultItem.getKey());
            if (objectType == null) continue;
            if (!objectIdsByType.containsKey(objectType)) {
                objectIdsByType.put(objectType, new HashSet());
            }
            String objectUid = this._objRefService.getUid(resultItem.getKey(), true);
            ((Set)objectIdsByType.get(objectType)).add(objectUid);
            propertiesByObjectId.put(objectUid, resultItem.getPropertyValues().toArray());
        }
        for (String objectType : objectIdsByType.keySet()) {
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(objectType);
            if (objectTypeSpec == null) continue;
            String labelPlural = objectTypeSpec.labelPlural;
            String icon = objectTypeSpec.icon;
            String listViewId = objectTypeSpec.listViewId;
            ExtensionInfo extensionInfo = this._extensionService.getExtensionInfo(listViewId);
            ComponentSpec componentSpec = (ComponentSpec)((Object)this._extensionService.getExtensionObject(extensionInfo, null, true));
            SearchTypeData searchTypeData = new SearchTypeData();
            searchTypeData.type = objectType;
            searchTypeData.icon = icon;
            searchTypeData.labelPlural = labelPlural;
            searchTypeData.listUrl = componentSpec.contentSpec.url;
            searchTypeData.listUid = componentSpec.getUid();
            searchTypeData.listMetadata = componentSpec.contentSpec.metadata;
            searchTypeData.objectUids = ((Set)objectIdsByType.get(objectType)).toArray(new String[0]);
            searchTypeData.totalCount = resultSet.getTotalCount();
            searchTypeData.count = searchTypeData.totalCount < 1000 ? searchTypeData.objectUids.length : -1;
            searchTypeData.propertyValues = new Object[searchTypeData.objectUids.length][];
            int arrIndex = 0;
            for (String objectId : searchTypeData.objectUids) {
                searchTypeData.propertyValues[arrIndex] = (Object[])propertiesByObjectId.get(objectId);
                ++arrIndex;
            }
            resultTypes.add(searchTypeData);
        }
        return resultTypes;
    }
}

