/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.ExtendedFault;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.MutableMessageException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class ThrowableSerializer
extends StdSerializer<Throwable> {
    static final String BUNDLE_NAME = "commonmvc";
    static final String PROPERTY_NAME_MESSAGE = "message";
    static final String PROPERTY_UNEXPECTED_STATUS_CODE = "unexpectedStatusCode";
    static final String PROPERTY_LOCALIZED_MESSAGE = "localizedMessage";
    static final String PROPERTY_CAUSE = "cause";
    static final String PROPERTY_FAULT_MESSAGE = "faultMessage";
    static final String PROPERTY_FAULT_CAUSE = "faultCause";
    static final String PROPERTY_SUPPRESSED = "suppressed";
    static final String PROPERTY_STACKTRACE = "stackTrace";
    static final String PROPERTY_TYPE = "_type";
    static final String ERROR_STACK_TRACE_FLAG = "error.stackTrace.show";
    private NotAuthenticatedError _notAuthenticatedError;
    private ConfigurationService _configurationService;
    private final ThreadLocal<Locale> _locale = new ThreadLocal();
    private static final Log _logger = LogFactory.getLog(ThrowableSerializer.class);

    ThrowableSerializer() {
        this(null);
    }

    ThrowableSerializer(Class<Throwable> t) {
        super(t);
        this._notAuthenticatedError = new NotAuthenticatedError();
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void serialize(Throwable obj, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        this.serialize(obj, jsonGenerator, provider, false);
    }

    public void serializeWithType(Throwable value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, jsonGenerator);
        this.serialize(value, jsonGenerator, serializerProvider, true);
        typeSer.writeTypeSuffixForObject((Object)value, jsonGenerator);
    }

    private void serialize(Throwable obj, JsonGenerator jsonGenerator, SerializerProvider provider, boolean isStartObjectAlreadyWritten) throws IOException {
        Object defaultInstance = this.getInstanceToSerialize(obj);
        JavaType type2 = TypeFactory.defaultInstance().constructType(defaultInstance.getClass());
        BeanDescription beanDescription = provider.getConfig().introspect(type2);
        if (this._locale != null) {
            Locale locale = (Locale)SessionUtil.getData((String)"Locale");
            this._locale.set(locale);
        }
        Set<String> properties = this.getObjectPropertyNames(beanDescription, defaultInstance);
        Boolean closeObject = false;
        if (!isStartObjectAlreadyWritten || jsonGenerator.getOutputContext().inArray()) {
            jsonGenerator.writeStartObject();
            closeObject = true;
        }
        List propertyBuilders = beanDescription.findProperties();
        for (String property : properties) {
            BeanPropertyDefinition propertyDefinition = this.getPropertyDefinition(property, propertyBuilders, defaultInstance);
            if (propertyDefinition != null) {
                try {
                    Object propertyBeanValue = propertyDefinition.getGetter() != null ? propertyDefinition.getGetter().callOn(defaultInstance) : propertyDefinition.getField().getValue(defaultInstance);
                    Object propertyValue = this.getValue(propertyDefinition.getName(), propertyBeanValue, defaultInstance);
                    jsonGenerator.writeObjectField(propertyDefinition.getName(), propertyValue);
                }
                catch (Exception e) {
                    _logger.warn((Object)("A '" + propertyDefinition.getName() + "' cannot be serialized."));
                }
                continue;
            }
            if (!property.equals(PROPERTY_UNEXPECTED_STATUS_CODE)) continue;
            jsonGenerator.writeFieldName(PROPERTY_UNEXPECTED_STATUS_CODE);
            jsonGenerator.writeNumber(this.getStatusCode(defaultInstance));
        }
        if (closeObject.booleanValue()) {
            jsonGenerator.writeEndObject();
        }
    }

    private Object getInstanceToSerialize(Object instance) {
        if (instance == null || !(instance instanceof Throwable)) {
            return instance;
        }
        if (Exception.class.getName().equals(instance.getClass().getName())) {
            Exception e = (Exception)instance;
            return new MutableMessageException(e.getMessage());
        }
        Object newInstance = instance;
        if (ExceptionUtil.isCausedBy((Throwable)((Throwable)instance), SessionDataContainerMissingException.class) || ExceptionUtil.isCausedBy((Throwable)((Throwable)instance), SessionInvalidatedException.class)) {
            newInstance = this._notAuthenticatedError;
        }
        if (MethodFault.class.equals(instance.getClass()) && !((newInstance = ((Throwable)instance).getCause()) instanceof MethodFault) && !(newInstance instanceof RuntimeFault)) {
            newInstance = instance;
        }
        return newInstance;
    }

    private BeanPropertyDefinition getPropertyDefinition(String property, List<BeanPropertyDefinition> propertyBuilders, Object instance) throws IOException {
        BeanPropertyDefinition propertyDefinition = null;
        for (BeanPropertyDefinition beanPropertyDefinition : propertyBuilders) {
            if (!property.equals(beanPropertyDefinition.getName()) || !beanPropertyDefinition.couldSerialize() || (beanPropertyDefinition.getGetter() == null || !beanPropertyDefinition.getGetter().isPublic()) && (beanPropertyDefinition.getGetter() != null || beanPropertyDefinition.getField() == null || beanPropertyDefinition.getField().getValue(instance) == null)) continue;
            propertyDefinition = beanPropertyDefinition;
            break;
        }
        return propertyDefinition;
    }

    private Set<String> getObjectPropertyNames(BeanDescription beanDescription, Object instance) throws IOException {
        HashSet<String> names = new HashSet<String>();
        List propertyBuilders = beanDescription.findProperties();
        for (BeanPropertyDefinition propertyDefinition : propertyBuilders) {
            Boolean hasPublicGetter = propertyDefinition.getGetter() != null && propertyDefinition.getGetter().isPublic();
            Boolean hasPublicProperty = propertyDefinition.getGetter() == null && propertyDefinition.getField() != null && propertyDefinition.getField().getValue(instance) != null;
            if (!propertyDefinition.couldSerialize() || !hasPublicGetter.booleanValue() && !hasPublicProperty.booleanValue()) continue;
            names.add(propertyDefinition.getName());
        }
        this.removeStackTracePropertyIfNeeded(names);
        if (instance.getClass() == MethodFault.class && !names.contains(PROPERTY_UNEXPECTED_STATUS_CODE)) {
            names.add(PROPERTY_UNEXPECTED_STATUS_CODE);
        }
        return names;
    }

    private Object getValue(String propertyName, Object propertyBeanValue, Object instance) throws IOException {
        if (PROPERTY_NAME_MESSAGE.equals(propertyName)) {
            return this.getDetailedFaultMessage(instance);
        }
        if (PROPERTY_LOCALIZED_MESSAGE.equals(propertyName)) {
            return this.getLocalizedFaultMessage(instance);
        }
        if (PROPERTY_UNEXPECTED_STATUS_CODE.equals(propertyName)) {
            return this.getStatusCode(instance);
        }
        return propertyBeanValue;
    }

    private int getStatusCode(Object instance) throws IOException {
        if (instance.getClass() != MethodFault.class) {
            return 0;
        }
        MethodFault mf = (MethodFault)instance;
        if (!(mf.getCause() instanceof UnexpectedStatusCodeException)) {
            return 0;
        }
        UnexpectedStatusCodeException uscException = (UnexpectedStatusCodeException)mf.getCause();
        return uscException.getStatusCode();
    }

    private String getLocalizedFaultMessage(Object fault) throws IOException {
        String message = null;
        String key = null;
        Locale localeObject = this._locale.get();
        try {
            KeyAnyValue[] args = this.constructKeyValuePairs((Throwable)fault);
            if (fault instanceof ExtendedFault) {
                ExtendedFault extf = (ExtendedFault)fault;
                key = this.getMessageKey(extf.getFaultTypeId());
                message = localeObject != null ? this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessageGivenLocale((String)key, (KeyAnyValue[])args, (Locale)localeObject), extf.getData()) : this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args), extf.getData());
                if (message != null && message.equals(key)) {
                    message = null;
                }
            } else {
                key = this.getMessageKey(fault.getClass().getSimpleName());
                message = localeObject != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)key, (KeyAnyValue[])args, (Locale)localeObject) : LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args);
                if (message == null || message.equals(key)) {
                    message = this.isServiceNotAvailable((Throwable)fault) ? ThrowableSerializer.text("ThrowableProxy.unexpectedStatusCode503") : null;
                }
            }
        }
        catch (NotAuthenticatedError notAuthenticatedError) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty(message)) {
            message = ((Throwable)fault).getMessage();
        }
        if (message != null) {
            message = message.trim();
        }
        return message;
    }

    private KeyAnyValue[] constructKeyValuePairs(Throwable instance) throws IOException {
        Set<String> propertyNames = this.getPropertyNames(instance);
        if (propertyNames == null || propertyNames.isEmpty()) {
            return null;
        }
        propertyNames.remove(PROPERTY_NAME_MESSAGE);
        propertyNames.remove(PROPERTY_CAUSE);
        KeyAnyValue[] args = new KeyAnyValue[propertyNames.size()];
        int index = 0;
        for (String property : propertyNames) {
            args[index] = ThrowableSerializer.newKeyValue(property, this.getProperty(property, instance));
            ++index;
        }
        for (KeyAnyValue kv : args) {
            if (!(kv.getValue() instanceof MethodFault)) continue;
            MethodFault mf = (MethodFault)kv.getValue();
            kv.setValue((Object)this.buildMessage((Throwable)mf));
        }
        return args;
    }

    private Object getProperty(String property, Object instance) {
        try {
            Field field = ReflectionUtils.findField(instance.getClass(), (String)property);
            ReflectionUtils.makeAccessible((Field)field);
            return ReflectionUtils.getField((Field)field, (Object)instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<String> getPropertyNames(Object instance) {
        final HashSet<String> names = new HashSet<String>();
        ReflectionUtils.doWithFields(instance.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                names.add(field.getName());
            }
        });
        this.removeStackTracePropertyIfNeeded(names);
        if (instance.getClass() == MethodFault.class && !names.contains(PROPERTY_UNEXPECTED_STATUS_CODE)) {
            names.add(PROPERTY_UNEXPECTED_STATUS_CODE);
        }
        return names;
    }

    private void removeStackTracePropertyIfNeeded(Set<String> names) {
        String flag;
        if (names.contains(PROPERTY_STACKTRACE) && !Boolean.parseBoolean(flag = this._configurationService.getProperty(ERROR_STACK_TRACE_FLAG))) {
            names.remove(PROPERTY_STACKTRACE);
        }
    }

    private static KeyAnyValue newKeyValue(String key, Object value) {
        KeyAnyValueImpl kv = new KeyAnyValueImpl();
        kv.setKey(key);
        kv.setValue(value);
        return kv;
    }

    public String getDetailedFaultMessage(Object instance) throws IOException {
        RuntimeFault fault;
        String message;
        String value = this.getPropertyValue(instance, PROPERTY_NAME_MESSAGE);
        if (!(instance instanceof Throwable)) {
            return value;
        }
        if (instance instanceof CompositeException) {
            CompositeException exception = (CompositeException)instance;
            String message2 = this.buildCompositeExceptionMessage(exception);
            if (!StringUtil.isNullOrEmpty((String)message2)) {
                value = message2;
            }
            return value;
        }
        if (instance instanceof DataException) {
            DataException fault2 = (DataException)instance;
            String message3 = this.buildMessage(fault2.rootCause);
            if (!StringUtil.isNullOrEmpty((String)message3)) {
                value = message3;
            }
            return value;
        }
        if (MethodFault.class.equals(instance.getClass())) {
            String message4;
            MethodFault fault3 = (MethodFault)instance;
            if (fault3.getFaultCause() != null && !StringUtil.isNullOrEmpty((String)(message4 = this.buildMessage(fault3.getFaultCause())))) {
                value = message4;
            }
        } else if (instance instanceof MethodFault) {
            MethodFault fault4 = (MethodFault)instance;
            String message5 = this.buildMessage((Throwable)fault4);
            if (!StringUtil.isNullOrEmpty((String)message5)) {
                value = message5;
            }
        } else if (instance instanceof RuntimeFault && !StringUtil.isNullOrEmpty((String)(message = this.buildMessage((Throwable)(fault = (RuntimeFault)instance))))) {
            value = message;
        }
        return value;
    }

    private String getPropertyValue(Object instance, String propertyName) {
        try {
            Field field = instance.getClass().getField(propertyName);
            return (String)field.get(instance);
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e) {
            _logger.warn((Object)("A '" + propertyName + "' cannot be accessed."));
        }
        return null;
    }

    private String buildCompositeExceptionMessage(CompositeException cmf) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Exception mf : cmf.getExceptions()) {
            if (mf == null) continue;
            this.buildMessage(mf, builder);
        }
        return builder.toString().trim();
    }

    private String buildMessage(Throwable fault) throws IOException {
        return this.buildMessage(fault, new StringBuilder());
    }

    private String buildMessage(Throwable fault, StringBuilder builder) throws IOException {
        String msg;
        if (fault == null) {
            return builder.toString();
        }
        String message = this.getLocalizedFaultMessage(fault = (Throwable)this.getInstanceToSerialize(fault));
        if (!StringUtil.isNullOrEmpty((String)message)) {
            builder.append(message);
            builder.append("\n");
        }
        if (fault instanceof NoPermission) {
            builder.append(this.getNoPermissionFaultMessage((NoPermission)fault));
            builder.append("\n");
        }
        LocalizableMessage[] faultMessage = null;
        Exception faultCause = null;
        if (fault instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)fault;
            faultMessage = methodFault.getFaultMessage();
            faultCause = methodFault.getFaultCause();
        } else if (fault instanceof RuntimeFault) {
            RuntimeFault runtimeFault = (RuntimeFault)fault;
            faultMessage = runtimeFault.getFaultMessage();
            faultCause = runtimeFault.getFaultCause();
        }
        if (faultCause == fault) {
            faultCause = null;
        }
        this.buildFaultMessage(faultMessage, message, builder);
        if (faultCause != null && !StringUtil.isNullOrEmpty((String)(msg = this.buildMessage(faultCause)))) {
            builder.append("\n");
            builder.append(ThrowableSerializer.text("ThrowableProxy.cause"));
            builder.append("\n");
            builder.append(msg);
            builder.append("\n");
        }
        return builder.toString().trim();
    }

    private void buildFaultMessage(LocalizableMessage[] faultMessage, String message, StringBuilder builder) {
        if (faultMessage != null) {
            Locale localeObject = this._locale.get();
            for (int i = faultMessage.length - 1; i >= 0; --i) {
                String lmsg;
                LocalizableMessage msg = faultMessage[i];
                String itemMsg = lmsg = this.localizeMessage(msg, localeObject);
                if (StringUtil.isNullOrEmpty((String)lmsg)) {
                    itemMsg = !StringUtil.isNullOrEmpty((String)msg.getMessage()) ? msg.getMessage() : msg.getKey();
                }
                if (StringUtil.isNullOrEmpty((String)itemMsg)) continue;
                itemMsg = itemMsg.trim();
                if (!StringUtil.isNullOrEmpty((String)message) && message.equals(itemMsg)) continue;
                builder.append(itemMsg);
                builder.append("\n");
            }
        }
    }

    private String localizeMessage(LocalizableMessage msg, Locale localeObject) {
        String msgKey;
        String lmsg = localeObject != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)msgKey, (KeyAnyValue[])msg.getArg(), (Locale)localeObject) : LocalizationUtil.getLocalizedMessage((String)msgKey, (KeyAnyValue[])msg.getArg());
        if (lmsg.equals(msgKey = msg.getKey())) {
            lmsg = msg.getMessage();
        }
        return lmsg;
    }

    private String getNoPermissionFaultMessage(NoPermission npf) {
        String privilegeId = npf.getPrivilegeId();
        String text = this.getPrivilegeText(privilegeId);
        String name = "?";
        String type2 = "?";
        ManagedObjectReference moRef = npf.getObject();
        if (moRef != null) {
            String moRefType = moRef.getType();
            if (moRefType != null) {
                type2 = ManagedObjectUtil.getLocalizedEntityType((String)moRefType);
            } else {
                _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault's moRef contains a null type."));
            }
        }
        String format = ThrowableSerializer.text("NoPermission.message.format");
        format = String.format(format, text, type2, name);
        return format;
    }

    private String getPrivilegeText(String privilegeId) {
        if (StringUtil.isNullOrEmpty((String)privilegeId)) {
            return "?";
        }
        Locale localeObject = this._locale.get();
        String[] parts = privilegeId.split("\\.");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            int pos = 0;
            for (int k = 0; k < i + 1; ++k) {
                if ((pos = privilegeId.indexOf(".", pos + 1)) != -1) continue;
                pos = privilegeId.length();
                break;
            }
            String part = privilegeId.substring(0, pos);
            String key = String.format("privilege.%s.label", part);
            String localized = localeObject != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)key, null, (Locale)localeObject) : LocalizationUtil.getLocalizedMessage((String)key, null);
            if (localized != null && !localized.equals(key)) {
                if (buffer.length() > 0) {
                    buffer.append(" > ");
                }
                buffer.append(localized);
                continue;
            }
            _logger.warn((Object)("Unable to localize key '" + key + "'"));
        }
        return buffer.toString();
    }

    private boolean isServiceNotAvailable(Throwable fault) throws IOException {
        if (fault instanceof UnexpectedStatusCodeException) {
            UnexpectedStatusCodeException unexpectedException = (UnexpectedStatusCodeException)fault;
            return unexpectedException.getStatusCode() == 503;
        }
        return false;
    }

    private String fillInExtendFaultData(String msg, KeyValue[] pairs) {
        int end;
        String result = msg;
        int start = result.indexOf("[data.");
        if (start == -1 || pairs == null || pairs.length == 0) {
            return result;
        }
        while ((end = result.indexOf("]", start + 6)) != -1) {
            String lookup = result.substring(start + 6, end);
            String val = null;
            for (KeyValue kv : pairs) {
                if (!lookup.equals(kv.getKey())) continue;
                val = this.escapeOpenBrace(kv.getValue());
                break;
            }
            if (val == null) {
                _logger.warn((Object)("FormatExtensionFaultData: Unable to substitute " + lookup));
                val = String.format("<%s>", ThrowableSerializer.text("ThrowableProxy.propertyUnset"));
            }
            result = result.substring(0, start) + val + result.substring(end + 1);
            start += val.length() + 1;
            if ((start = result.indexOf("[data.", start + 1)) != -1) continue;
        }
        return result;
    }

    private String escapeOpenBrace(String str) {
        int start = str.indexOf(123);
        if (start == -1) {
            return str;
        }
        String result = "";
        int lastStart = 0;
        do {
            result = result + str.substring(lastStart, start + 1) + "{";
        } while ((start = str.indexOf(123, lastStart = start + 1)) != -1);
        result = result + str.substring(lastStart);
        return result;
    }

    private String getMessageKey(String errorId) {
        return String.format("%s.summary", errorId);
    }

    private static String text(String key) {
        return ResourceUtil.getString((String)BUNDLE_NAME, (String)key, (ClassLoader)ThrowableSerializer.class.getClassLoader());
    }
}

