/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.mvc.tree.NodeRoute;
import com.vmware.vise.mvc.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InverseTree {
    Tree _tree;
    Map<String, List<NodeRoute>> _typeRoutes = new HashMap<String, List<NodeRoute>>();
    Set<String> _selfChaining = new HashSet<String>();

    InverseTree(Tree tree) {
        this._tree = tree;
    }

    public Tree getRealTree() {
        return this._tree;
    }

    void addRoute(String type2, NodeRoute newRoute) {
        List<NodeRoute> routes = this._typeRoutes.get(type2);
        if (routes == null) {
            routes = new ArrayList<NodeRoute>();
            this._typeRoutes.put(type2, routes);
        }
        boolean isUniqueRoute = true;
        for (int i = 0; i < routes.size(); ++i) {
            NodeRoute existingRoute = routes.get(i);
            if (!this.removeSelfChaining(existingRoute).equals(this.removeSelfChaining(newRoute))) continue;
            if (existingRoute.size() < newRoute.size()) {
                routes.set(i, newRoute);
            }
            isUniqueRoute = false;
            break;
        }
        if (isUniqueRoute) {
            routes.add(newRoute);
        }
    }

    List<NodeRoute> getRoutes(String type2) {
        List<NodeRoute> routes = this._typeRoutes.get(type2);
        return routes != null ? routes : Collections.emptyList();
    }

    void addSelfChaining(String nodeId) {
        this._selfChaining.add(nodeId);
    }

    boolean isSelfChaining(String nodeId) {
        return this._selfChaining.contains(nodeId);
    }

    private NodeRoute removeSelfChaining(NodeRoute route) {
        NodeRoute result = new NodeRoute();
        for (String node : route) {
            if (this.isSelfChaining(node)) continue;
            result.add(node);
        }
        return result;
    }
}

