/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNodeList {
    private static final Log _logger = LogFactory.getLog(TreeNodeList.class);
    private static final Map<String, TreeNodeSpec> _treeNodeListMap = new HashMap<String, TreeNodeSpec>();

    public TreeNodeList() {
        this.buildTreeNodeListMap();
    }

    public TreeNodeSpec getTreeNodeSpec(String treeNodeId) {
        return _treeNodeListMap.get(treeNodeId);
    }

    private void buildTreeNodeListMap() {
        Class<?>[] classes;
        for (Class<?> cl : classes = TreeNodeList.class.getDeclaredClasses()) {
            if (!TreeNodeSpec.class.isAssignableFrom(cl)) continue;
            try {
                TreeNodeSpec inst = (TreeNodeSpec)cl.newInstance();
                _treeNodeListMap.put(inst.getId(), inst);
            }
            catch (IllegalAccessException | InstantiationException e) {
                _logger.error((Object)"Cannot intstantiate a tree definition", (Throwable)e);
            }
        }
    }

    static class NetworkFolderDvpg
    extends TreeNodeSpec {
        NetworkFolderDvpg() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint networkFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint networkFolderChildren = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)networkFolder, (Boolean)true, (String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP, (String)"config.distributedVirtualSwitch", (Comparator)Comparator.EQUALS, (Object)"null");
            CompositeConstraint rel = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{networkFolderChildren, propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.AND);
            return rel;
        }
    }

    static class DcDvpg
    extends TreeNodeSpec {
        DcDvpg() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dc = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint dcNetworkFolder = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)dc, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint networkFolderChildren = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)dcNetworkFolder, (Boolean)true, (String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP, (String)"config.distributedVirtualSwitch", (Comparator)Comparator.EQUALS, (Object)"null");
            CompositeConstraint rel = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{networkFolderChildren, propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.AND);
            return rel;
        }
    }

    static class DvsDvpg
    extends TreeNodeSpec {
        DvsDvpg() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dvs = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"dvs", (Constraint)dvs, (Boolean)false, (String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            return rel;
        }
    }

    static class NetworkFolderDvs
    extends TreeNodeSpec {
        NetworkFolderDvs() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint networkFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)networkFolder, (Boolean)true, null);
            PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH);
            PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH);
            CompositeConstraint propCompositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.OR);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel, propCompositeConstraint}, (Conjoiner)Conjoiner.AND);
            return compositeConstraint;
        }
    }

    static class NetworkFolderOpaqueNetwork
    extends TreeNodeSpec {
        NetworkFolderOpaqueNetwork() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint networkFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)networkFolder, (Boolean)false, (String)TreeManager.TARGET_OPAQUENETWORK);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_OPAQUENETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_OPAQUENETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_OPAQUENETWORK;
            return compositeConstraint;
        }
    }

    static class NetworkFolderNetwork
    extends TreeNodeSpec {
        NetworkFolderNetwork() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint networkFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)networkFolder, (Boolean)false, (String)TreeManager.TARGET_NETWORK);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_NETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_NETWORK;
            return compositeConstraint;
        }
    }

    static class NetworkFolderNetworkFolder
    extends TreeNodeSpec {
        NetworkFolderNetworkFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint networkFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)networkFolder, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcDvs
    extends TreeNodeSpec {
        DcDvs() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)dataCenter, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)rel1, (Boolean)true, null);
            PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH);
            PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH);
            CompositeConstraint propCompositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.OR);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propCompositeConstraint}, (Conjoiner)Conjoiner.AND);
            return compositeConstraint;
        }
    }

    static class DcOpaqueNetwork
    extends TreeNodeSpec {
        DcOpaqueNetwork() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)dataCenter, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_OPAQUENETWORK);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_OPAQUENETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_OPAQUENETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_OPAQUENETWORK;
            return compositeConstraint;
        }
    }

    static class DcNetwork
    extends TreeNodeSpec {
        DcNetwork() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)dataCenter, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_NETWORK);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_NETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_NETWORK;
            return compositeConstraint;
        }
    }

    static class DcNetworkFolder
    extends TreeNodeSpec {
        DcNetworkFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)dataCenter, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class StoragepodDatastore
    extends TreeNodeSpec {
        StoragepodDatastore() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint storagePod = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)storagePod, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            return rel1;
        }
    }

    static class DatastoreFolderDatastore
    extends TreeNodeSpec {
        DatastoreFolderDatastore() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint datastoreFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)datastoreFolder, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            return rel1;
        }
    }

    static class DatastoreFolderStoragepod
    extends TreeNodeSpec {
        DatastoreFolderStoragepod() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint datastoreFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)datastoreFolder, (Boolean)false, (String)TreeManager.TARGET_STORAGEPOD);
            return rel1;
        }
    }

    static class DatastoreFolderDatastoreFolder
    extends TreeNodeSpec {
        DatastoreFolderDatastoreFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint datastoreFolder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)datastoreFolder, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_DATASTORE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcDatastore
    extends TreeNodeSpec {
        DcDatastore() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            PropertyConstraint prop1 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DATASTORE, (String)"isSystemDatastore", (Comparator)Comparator.EQUALS, (Object)false);
            CompositeConstraint comp1 = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, prop1}, (Conjoiner)Conjoiner.AND);
            comp1.targetType = TreeManager.TARGET_DATASTORE;
            return comp1;
        }
    }

    static class DcStoragepod
    extends TreeNodeSpec {
        DcStoragepod() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_STORAGEPOD);
            return rel2;
        }
    }

    static class DcDatastoreFolder
    extends TreeNodeSpec {
        DcDatastoreFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_DATASTORE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class VmFolderVmTemplate
    extends TreeNodeSpec {
        VmFolderVmTemplate() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"config.template", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class VmFolderVm
    extends TreeNodeSpec {
        VmFolderVm() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class VmFolderVApp
    extends TreeNodeSpec {
        VmFolderVApp() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_VIRTUALAPP);
            return rel;
        }
    }

    static class VmFolderVmFolder
    extends TreeNodeSpec {
        VmFolderVmFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_VIRTUALMACHINE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcVmTemplate
    extends TreeNodeSpec {
        DcVmTemplate() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"config.template", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"config.template");
        }
    }

    static class DcVm
    extends TreeNodeSpec {
        DcVm() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"config.template");
        }
    }

    static class DcVApp
    extends TreeNodeSpec {
        DcVApp() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_VIRTUALAPP);
            return rel2;
        }
    }

    static class DcVmFolder
    extends TreeNodeSpec {
        DcVmFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_VIRTUALMACHINE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class ResPoolVm
    extends TreeNodeSpec {
        ResPoolVm() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint resPool = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"resourcePool", (Constraint)resPool, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class ResPoolResPoolNoVapp
    extends ResPoolResPool {
        ResPoolResPoolNoVapp() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            Constraint resPoolRp = super.getConstraint(ref);
            PropertyConstraint rpOnly = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_RESOURCEPOOL, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_RESOURCEPOOL);
            CompositeConstraint result = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{resPoolRp, rpOnly}, (Conjoiner)Conjoiner.AND);
            return result;
        }
    }

    static class ResPoolResPool
    extends TreeNodeSpec {
        ResPoolResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint resPool = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)resPool, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return rel;
        }

        @Override
        protected OrderingCriteria getOrderingCriteria() {
            return this.orderBy("@type", "name");
        }
    }

    static class StandaloneHostVm
    extends TreeNodeSpec {
        StandaloneHostVm() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint host = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"standalonehost", (Constraint)host, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class StandaloneHostResPoolNoVapp
    extends StandaloneHostResPool {
        StandaloneHostResPoolNoVapp() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            Constraint hostRp = super.getConstraint(ref);
            PropertyConstraint rpOnly = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_RESOURCEPOOL, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_RESOURCEPOOL);
            CompositeConstraint result = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{hostRp, rpOnly}, (Conjoiner)Conjoiner.AND);
            return result;
        }
    }

    static class StandaloneHostResPool
    extends TreeNodeSpec {
        StandaloneHostResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint host = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"host", (Constraint)host, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint rel3 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel2, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return rel3;
        }

        @Override
        protected OrderingCriteria getOrderingCriteria() {
            return this.orderBy("@type", "name");
        }
    }

    static class MigrateVMClusterHostSystem
    extends ClusterHostSystem {
        MigrateVMClusterHostSystem() {
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.addAll((Object[])TreeManager.DEFAULT_PROPERTIES, (Object[])TreeManager.HOST_FAULT_DOMAIN_PROPERTIES);
        }
    }

    static class ClusterHostSystem
    extends TreeNodeSpec {
        ClusterHostSystem() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint cluster = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)cluster, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return rel;
        }
    }

    static class ClusterVm
    extends TreeNodeSpec {
        ClusterVm() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint cluster = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)cluster, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"resourcePool", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel2, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class ClusterResPoolNoVapp
    extends ClusterResPool {
        ClusterResPoolNoVapp() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            Constraint clusterRp = super.getConstraint(ref);
            PropertyConstraint rpOnly = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_RESOURCEPOOL, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_RESOURCEPOOL);
            CompositeConstraint result = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{clusterRp, rpOnly}, (Conjoiner)Conjoiner.AND);
            return result;
        }
    }

    static class ClusterResPool
    extends TreeNodeSpec {
        ClusterResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint cluster = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)cluster, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)rel1, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return rel2;
        }

        @Override
        protected OrderingCriteria getOrderingCriteria() {
            return this.orderBy("@type", "name");
        }
    }

    static class CompResFolderStandaloneHost
    extends TreeNodeSpec {
        CompResFolderStandaloneHost() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_COMPUTERESOURCE, (String)"@type", (Comparator)Comparator.NOT_EQUALS, (Object)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_COMPUTERESOURCE;
            RelationalConstraint rel2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)compositeConstraint, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return rel2;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"resourcePool");
        }
    }

    static class CompResFolderCluster
    extends TreeNodeSpec {
        CompResFolderCluster() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            return rel;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"resourcePool");
        }
    }

    static class CompResFolderCompResFolder
    extends TreeNodeSpec {
        CompResFolderCompResFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint folder = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint rel1 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)folder, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_COMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{rel1, propConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcStandaloneHost
    extends TreeNodeSpec {
        DcStandaloneHost() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint dedicatedComputeResourceFolder = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint computeResourceInDedicatedComputeResourceFolder = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dedicatedComputeResourceFolder, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            PropertyConstraint notCluster = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_COMPUTERESOURCE, (String)"@type", (Comparator)Comparator.NOT_EQUALS, (Object)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{computeResourceInDedicatedComputeResourceFolder, notCluster}, (Conjoiner)Conjoiner.AND);
            RelationalConstraint hostSystem = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)compositeConstraint, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return hostSystem;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"resourcePool");
        }
    }

    static class DcCluster
    extends TreeNodeSpec {
        DcCluster() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint dedicatedComputeResourceFolder = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint clusters = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dedicatedComputeResourceFolder, (Boolean)false, (String)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            return clusters;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.add((Object[])TreeManager.DEFAULT_PROPERTIES, (Object)"resourcePool");
        }
    }

    static class DcCompResFolder
    extends TreeNodeSpec {
        DcCompResFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint dataCenter = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint dedicatedComputeResourceFolder = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dataCenter, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint foldersInDedicatedComputeResourceFolder = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)dedicatedComputeResourceFolder, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint containsComputeResource = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_COMPUTERESOURCE);
            CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{foldersInDedicatedComputeResourceFolder, containsComputeResource}, (Conjoiner)Conjoiner.AND);
            constraint.targetType = TreeManager.TARGET_FOLDER;
            return constraint;
        }
    }

    static class Datacenter
    extends TreeNodeSpec {
        Datacenter() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = ref;
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.relation = "parent";
            relationalConstraint.targetType = TreeManager.TARGET_DATACENTER;
            relationalConstraint.hasInverseRelation = false;
            relationalConstraint.constraintOnRelatedObject = objectIdentityConstraint;
            return relationalConstraint;
        }

        @Override
        public String[] getProperties() {
            return (String[])ArrayUtils.addAll((Object[])TreeManager.DEFAULT_PROPERTIES, (Object[])new String[]{"hostFolder", "vmFolder", "datastoreFolder", "networkFolder"});
        }
    }

    static class DatacenterFolder
    extends TreeNodeSpec {
        DatacenterFolder() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = ref;
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.relation = "parent";
            relationalConstraint.targetType = TreeManager.TARGET_FOLDER;
            relationalConstraint.hasInverseRelation = false;
            relationalConstraint.constraintOnRelatedObject = objectIdentityConstraint;
            return relationalConstraint;
        }
    }

    static class RefOrVcAsRoot
    extends TreeNodeSpec {
        private RefAsRoot _refAsRoot = new RefAsRoot();
        private VcRoot _vcRoot = new VcRoot();

        RefOrVcAsRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            if (ref != null) {
                return this._refAsRoot.getConstraint(ref);
            }
            return this._vcRoot.getConstraint(ref);
        }
    }

    static class RefAsRoot
    extends TreeNodeSpec {
        RefAsRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            return identityConstraint;
        }
    }

    static class DcDvsRoot
    extends TreeNodeSpec {
        DcDvsRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"dvs", (Constraint)identityConstraint, (Boolean)false, (String)TreeManager.TARGET_DATACENTER);
            return relationalConstraint;
        }
    }

    static class DcNetworkRoot
    extends TreeNodeSpec {
        DcNetworkRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"network", (Constraint)identityConstraint, (Boolean)false, (String)TreeManager.TARGET_DATACENTER);
            return relationalConstraint;
        }
    }

    static class RpParentSaHostRoot
    extends TreeNodeSpec {
        RpParentSaHostRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"host", (Constraint)identityConstraint, (Boolean)true, (String)TreeManager.TARGET_HOSTSYSTEM);
            return relationalConstraint;
        }
    }

    static class RpParentClusterRoot
    extends TreeNodeSpec {
        RpParentClusterRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"owner", (Constraint)identityConstraint, (Boolean)true, (String)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            return relationalConstraint;
        }
    }

    static class FolderDcRoot
    extends TreeNodeSpec {
        FolderDcRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            return QueryUtil.createRelationalConstraint((String)"dc", (Constraint)identityConstraint, (Boolean)true, (String)TreeManager.TARGET_DATACENTER);
        }
    }

    static class DcRoot
    extends TreeNodeSpec {
        DcRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            ObjectIdentityConstraint identityConstraint = QueryUtil.createObjectIdentityConstraint((Object)ref);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"datastore", (Constraint)identityConstraint, (Boolean)false, (String)TreeManager.TARGET_DATACENTER);
            return relationalConstraint;
        }
    }

    static class VcRoot
    extends TreeNodeSpec {
        VcRoot() {
        }

        @Override
        public Constraint getConstraint(Object ref) {
            PropertyConstraint propConstraint = new PropertyConstraint();
            propConstraint.targetType = TreeManager.TARGET_FOLDER;
            propConstraint.propertyName = "isRootFolder";
            propConstraint.comparator = Comparator.EQUALS;
            propConstraint.comparableValue = Boolean.TRUE;
            return propConstraint;
        }
    }
}

