/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.mvc.tree.TreeNodeStateManager;
import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNodeStateManagerImpl
implements TreeNodeStateManager {
    private static final Log _logger = LogFactory.getLog(TreeNodeStateManagerImpl.class);
    private final PersistenceService _persistenceService;

    TreeNodeStateManagerImpl(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @Override
    public Map<String, Boolean> getVisibilityState(String treeId, String[] nodeTypes) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Map<String, Set<String>> hiddenNodeTypesMap = this.getHiddenNodeTypesMap();
        if (hiddenNodeTypesMap.containsKey(treeId)) {
            for (String nodeType : nodeTypes) {
                Set<String> hiddenTypes = hiddenNodeTypesMap.get(treeId);
                result.put(nodeType, !hiddenTypes.contains(nodeType));
            }
        } else {
            for (String nodeType : nodeTypes) {
                result.put(nodeType, true);
            }
        }
        return result;
    }

    @Override
    public boolean setVisibilityState(String treeId, Map<String, Boolean> state) {
        Map<String, Set<String>> hiddenNodeTypesMap = this.getHiddenNodeTypesMap();
        if (!hiddenNodeTypesMap.containsKey(treeId)) {
            hiddenNodeTypesMap.put(treeId, new HashSet());
        }
        Set<String> hiddenTypes = hiddenNodeTypesMap.get(treeId);
        boolean modified = false;
        for (String nodeType : state.keySet()) {
            boolean visible = state.get(nodeType);
            modified = (visible ? hiddenTypes.remove(nodeType) : hiddenTypes.add(nodeType)) || modified;
        }
        if (modified) {
            UserData userData = new UserData();
            userData.metadata = new UserDataMetadata();
            userData.metadata.uid = "vmware.vsphere.client.settings.inventorytree.hiddennodes";
            userData.value = hiddenNodeTypesMap;
            OperationResult operationResult = this._persistenceService.setUserData(userData, false, null);
            if (operationResult != null && operationResult.error != null) {
                _logger.error((Object)"Failed to store user preferences.", (Throwable)operationResult.error);
            }
        }
        return modified;
    }

    @Override
    public String[] filterHidden(String treeId, String[] nodeIds, String[] nodeTypes) {
        if (nodeIds == null || nodeTypes == null || nodeIds.length != nodeTypes.length) {
            throw new IllegalArgumentException("ID and type arrays must be of same size");
        }
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Set<String>> hiddenNodeTypesMap = this.getHiddenNodeTypesMap();
        if (hiddenNodeTypesMap.containsKey(treeId)) {
            Set<String> hiddenTypes = hiddenNodeTypesMap.get(treeId);
            if (hiddenTypes == null) {
                result.addAll(Arrays.asList(nodeIds));
            } else {
                for (int i = 0; i < nodeIds.length; ++i) {
                    if (hiddenTypes.contains(nodeTypes[i])) continue;
                    result.add(nodeIds[i]);
                }
            }
        } else {
            result.addAll(Arrays.asList(nodeIds));
        }
        return result.toArray(new String[0]);
    }

    private Map<String, Set<String>> getHiddenNodeTypesMap() {
        Map<String, Set<String>> result = (HashMap<String, Set<String>>)SessionUtil.getData((String)"vmware.vsphere.client.settings.inventorytree.hiddennodes");
        if (result != null) {
            return result;
        }
        OperationResult operationResult = this._persistenceService.getUserData("vmware.vsphere.client.settings.inventorytree.hiddennodes", null, null);
        if (operationResult != null) {
            if (operationResult.result instanceof UserData) {
                result = (Map)((UserData)operationResult.result).value;
            } else if (operationResult.error != null) {
                _logger.error((Object)"Failed to load user preferences.", (Throwable)operationResult.error);
            } else {
                _logger.warn((Object)"Failed to load user preferences.");
            }
        }
        if (result == null) {
            result = new HashMap<String, Set<String>>();
        }
        SessionUtil.setData((String)"vmware.vsphere.client.settings.inventorytree.hiddennodes", (Object)result);
        return result;
    }
}

