/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.mvc.tree.InverseTree;
import com.vmware.vise.mvc.tree.NodeRoute;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.navigator.NavigatorService;
import com.vmware.vsphere.client.navigator.ObjectChainElement;
import com.vmware.vsphere.client.navigator.PathQueryResultSet;
import com.vmware.vsphere.client.navigator.PathQuerySpec;
import com.vmware.vsphere.client.navigator.QuerySpecChainElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreePathHelper {
    private static final Log _logger = LogFactory.getLog(TreePathHelper.class);
    private static final String PATH_IN_ALL_TREES = "pathToTheRoot";
    private static final String PATH_IN_PHYSICAL_TREE = "physicalPathToRoot";
    private static final String PATH_IN_VIRTUAL_TREE = "pathToTheRootInVirtualTree";
    private static final String PATH_IN_STORAGE_TREE = "pathToTheRootInStorageTree";
    private static final String PATH_IN_NETWORK_TREE = "pathToTheRoot";
    private static final String SPEC_SUPPORTED_TOKEN = "{objectRef}";
    private final ObjectReferenceService _objRefService;
    private final NavigatorService _navigatorService;
    private final TreeList _treeList;
    private final TreeNodeList _treeNodeList;
    private final QueryService _queryService;
    private final Map<String, InverseTree> _inverseTreeMap = new ConcurrentHashMap<String, InverseTree>();

    @Autowired
    public TreePathHelper(ObjectReferenceService objRefService, NavigatorService navigatorService, TreeList treeList, TreeNodeList treeNodeList, QueryServiceFactory factory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRefService, navigatorService, treeList, treeNodeList});
        this._objRefService = objRefService;
        this._navigatorService = navigatorService;
        this._treeList = treeList;
        this._treeNodeList = treeNodeList;
        this._queryService = factory.getQueryService();
    }

    public TreePath findPaths(String treeId, Object root, Object object, String options) {
        List<List<String>> paths;
        ValidationUtil.paramsNotNull((Object[])new Object[]{treeId, root, object});
        boolean isMor = object instanceof ManagedObjectReference;
        if (isMor && this.isOptimizedPathToRootAvailable(treeId) && VcServiceUtil.is65VcOrLaterByServerGuid((String)((ManagedObjectReference)object).getServerGuid(), (boolean)true)) {
            List<String> path = this.getPathToTheRoot((ManagedObjectReference)object, this.getTreeIdOrParentNavTreeId(treeId));
            if (this._treeList.isSubsetOfNavigationalTree(treeId)) {
                path = this.cutoffPathAtRoot(path, root);
            }
            paths = new ArrayList<List<String>>();
            paths.add(path);
        } else {
            InverseTree inverseTree = this.getInverseTree(treeId);
            PathQuerySpec[] pathQuerySpecs = this.buildPathQuerySpecs(inverseTree, object);
            PathQueryResultSet[] pathResults = this._navigatorService.queryObjectPath(pathQuerySpecs);
            paths = this.extractPaths(pathResults, inverseTree, root, object);
        }
        TreePath treePath = new TreePath();
        treePath.options = options;
        treePath.paths = paths;
        return treePath;
    }

    private List<String> getPathToTheRoot(ManagedObjectReference object, String treeId) {
        String propertyToRequest = this.getPathToRootProperty(object, treeId);
        ResultSet result = this._queryService.select(new String[]{propertyToRequest}).from(new String[]{object.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)object).fetch();
        ArrayList<String> path = new ArrayList<String>();
        if (result.getItems().size() != 1) {
            return new ArrayList<String>();
        }
        ResourceItem resourceItem = (ResourceItem)result.getItems().get(0);
        Object[] nodes = (Object[])resourceItem.get(0);
        if (nodes == null) {
            return new ArrayList<String>();
        }
        for (int i = nodes.length - 1; i >= 0; --i) {
            path.add(this._objRefService.getUid(nodes[i], true));
        }
        return path;
    }

    private String getPathToRootProperty(ManagedObjectReference object, String treeId) {
        String propertyToRequest = "pathToTheRoot";
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)object, Datacenter.class) && !ManagedObjectUtil.isOfType((ManagedObjectReference)object, Folder.class)) {
            switch (treeId) {
                case "vsphere.core.physicalInventorySpec": {
                    propertyToRequest = PATH_IN_PHYSICAL_TREE;
                    break;
                }
                case "vsphere.core.virtualInventorySpec": {
                    propertyToRequest = PATH_IN_VIRTUAL_TREE;
                    break;
                }
                case "vsphere.core.storageInventorySpec": {
                    propertyToRequest = PATH_IN_STORAGE_TREE;
                    break;
                }
                case "vsphere.core.networkingInventorySpec": {
                    propertyToRequest = "pathToTheRoot";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid tree Id");
                }
            }
        }
        return propertyToRequest;
    }

    private String getTreeIdOrParentNavTreeId(String treeId) {
        if (this._treeList.isNavigationalTree(treeId)) {
            return treeId;
        }
        if (this._treeList.isSubsetOfNavigationalTree(treeId)) {
            return this._treeList.getParentInventoryTreeId(treeId);
        }
        throw new IllegalArgumentException("Wrong tree id!");
    }

    private List<String> cutoffPathAtRoot(List<String> path, Object root) {
        String guidFromPath;
        String rootGuid = this._objRefService.getUid(root);
        ListIterator<String> iterator = path.listIterator();
        while (iterator.hasNext() && !rootGuid.equals(guidFromPath = (String)iterator.next())) {
            iterator.remove();
        }
        return path;
    }

    private InverseTree getInverseTree(String treeId) {
        InverseTree inverseTree = this._inverseTreeMap.get(treeId);
        if (inverseTree == null) {
            inverseTree = this.buildInverseTree(treeId);
            this._inverseTreeMap.put(treeId, inverseTree);
        }
        return inverseTree;
    }

    private InverseTree buildInverseTree(String treeId) {
        Tree tree = this._treeList.getTree(treeId);
        if (tree == null) {
            throw new IllegalStateException(String.format("No such tree declared for: [treeId=%s]", treeId));
        }
        InverseTree inverseTree = new InverseTree(tree);
        String root = tree.getRoot();
        this.buildInverseTree(inverseTree, root, new NodeRoute());
        return inverseTree;
    }

    private void buildInverseTree(InverseTree inverseTree, String parentNodeId, List<String> parentPath) {
        String[] childrenNodeIds = inverseTree.getRealTree().getChildren(parentNodeId);
        if (childrenNodeIds == null) {
            return;
        }
        for (String childNodeId : childrenNodeIds) {
            String[] resultTypes;
            TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(childNodeId);
            if (treeNodeSpec == null) {
                _logger.error((Object)String.format("No such treeNodeSpec declared for: [treeId=%s, parentNodeId=%s]", inverseTree.getRealTree().getId(), childNodeId));
                continue;
            }
            if (childNodeId.equals(parentNodeId)) {
                inverseTree.addSelfChaining(childNodeId);
                continue;
            }
            if (parentPath.contains(childNodeId)) {
                _logger.warn((Object)String.format("Deep nested multilevel recursion found: [treeId=%s, nodeId=%s]", inverseTree.getRealTree().getId(), childNodeId));
                continue;
            }
            NodeRoute route = new NodeRoute((Collection<? extends String>)parentPath);
            route.add(childNodeId);
            for (String resultType : resultTypes = TreePathHelper.getResultTypes(treeNodeSpec)) {
                inverseTree.addRoute(resultType, route);
            }
            this.buildInverseTree(inverseTree, childNodeId, route);
        }
    }

    private PathQuerySpec[] buildPathQuerySpecs(InverseTree inverseTree, Object object) {
        String objectType = this._objRefService.getResourceObjectType(object);
        List<NodeRoute> routes = inverseTree.getRoutes(objectType);
        if (routes.isEmpty()) {
            _logger.info((Object)String.format("No inverse routes for: [treeId=%s, type=%s]", inverseTree.getRealTree().getId(), objectType));
            return new PathQuerySpec[0];
        }
        ArrayList<PathQuerySpec> pathSpecs = new ArrayList<PathQuerySpec>();
        pathSpecs.ensureCapacity(routes.size());
        for (NodeRoute route : routes) {
            if (route.isEmpty()) {
                _logger.warn((Object)String.format("Empty route for: [treeId=%s, type=%s]", inverseTree.getRealTree().getId(), objectType));
                continue;
            }
            QuerySpecChainElement querySpecChainEl = null;
            QuerySpecChainElement prev = null;
            for (String nodeId : route) {
                querySpecChainEl = new QuerySpecChainElement();
                querySpecChainEl.object = this._treeNodeList.getTreeNodeSpec(nodeId).getQuerySpec(SPEC_SUPPORTED_TOKEN);
                if (inverseTree.isSelfChaining(nodeId)) {
                    querySpecChainEl.selfChaining = true;
                }
                if (prev != null) {
                    querySpecChainEl.nextObject = prev;
                }
                prev = querySpecChainEl;
            }
            PathQuerySpec pathSpec = new PathQuerySpec();
            pathSpec.object = object;
            pathSpec.querySpecChain = querySpecChainEl;
            pathSpecs.add(pathSpec);
        }
        return pathSpecs.toArray(new PathQuerySpec[pathSpecs.size()]);
    }

    private List<List<String>> extractPaths(PathQueryResultSet[] pathResults, InverseTree inverseTree, Object root, Object object) {
        ArrayList<List<String>> resultPaths = new ArrayList<List<String>>();
        if (pathResults == null) {
            return resultPaths;
        }
        for (PathQueryResultSet pr : pathResults) {
            if (pr == null) continue;
            if (pr.error != null) {
                _logger.error((Object)String.format("Error when retrieving path for: [treeId=%s, type=%s], error is [%s]", inverseTree.getRealTree().getId(), this._objRefService.getResourceObjectType(object), pr.error.toString()));
            }
            for (ObjectChainElement path : pr.paths) {
                if (!root.equals(path.object)) continue;
                ArrayList<String> currentPath = new ArrayList<String>();
                ObjectChainElement currentChainElement = path;
                while (currentChainElement != null) {
                    currentPath.add(this._objRefService.getUid(currentChainElement.object, true));
                    currentChainElement = currentChainElement.nextObject;
                }
                resultPaths.add(currentPath);
            }
        }
        return resultPaths;
    }

    public boolean isOptimizedPathToRootAvailable(String treeId) {
        return this._treeList.isNavigationalTree(treeId) || this._treeList.isSubsetOfNavigationalTree(treeId);
    }

    static String[] getResultTypes(TreeNodeSpec treeNodeSpec) {
        String[] resultTypes = treeNodeSpec.getResultTypes();
        if (resultTypes != null && resultTypes.length > 0) {
            return resultTypes;
        }
        QuerySpec querySpec = treeNodeSpec.getQuerySpec(null);
        String targetType = TreePathHelper.extractTargetType(querySpec);
        if (targetType != null) {
            return new String[]{targetType};
        }
        return new String[0];
    }

    static String extractTargetType(QuerySpec querySpec) {
        if (querySpec != null && querySpec.resourceSpec != null && querySpec.resourceSpec.constraint != null) {
            return querySpec.resourceSpec.constraint.targetType;
        }
        return null;
    }
}

