/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.util;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionServiceUtil {
    public static Map<String, Object> getFilterContext(ObjectReferenceService objRefService, String objectId) {
        Object ref = null;
        if (objectId != null) {
            ref = objRefService.getReference(objectId, true);
        }
        HashMap<String, Object[]> filterContext = null;
        if (ref != null) {
            filterContext = new HashMap<String, Object[]>();
            filterContext.put("contextObjects", new Object[]{ref});
        }
        return filterContext;
    }

    public static <T> List<T> getHostedExtensionObjectsByExtensionId(ExtensionService extensionService, String extensionId, ObjectReferenceService objRefService, String objectId) throws Exception {
        return ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(extensionService, extensionId, objRefService, objectId, null);
    }

    public static <T> List<T> getHostedExtensionObjectsByExtensionId(ExtensionService extensionService, String extensionId, ObjectReferenceService objRefService, String objectId, Predicate<String> skipEvaluation) throws Exception {
        ExtensionInfo ei = extensionService.getExtensionInfo(extensionId);
        if (ei.getHostedPointsIds() == null || ei.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> filterContext = ExtensionServiceUtil.getFilterContext(objRefService, objectId);
        ArrayList result = new ArrayList();
        for (String pointId : ei.getHostedPointsIds()) {
            if (skipEvaluation != null && skipEvaluation.evaluate((Object)pointId)) continue;
            result.addAll(extensionService.getExtensionObjects(pointId, filterContext, true));
        }
        return result;
    }
}

