/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.LockoutPolicy;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.LockoutPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockoutPolicyServiceImpl
extends AdminServiceBase
implements LockoutPolicyService {
    private static final Log _logger = LogFactory.getLog(LockoutPolicyServiceImpl.class);

    public LockoutPolicyServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, transformer);
    }

    @Override
    public LockoutPolicy getLockoutPolicy() throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getLockoutPolicyService().getLockoutPolicy();
        }
        catch (Exception e) {
            _logger.error((Object)"LockoutPolicyServiceImpl.getLockoutPolicy", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void updateLockoutPolicy(LockoutPolicy policy) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getLockoutPolicyService().updateLockoutPolicy(policy);
        }
        catch (Exception e) {
            _logger.error((Object)"LockoutPolicyServiceImpl.updateLockoutPolicy", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }
}

