/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vim.cdc.AlarmChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmChangeProcessorImpl
implements AlarmChangeProcessor<AlarmState> {
    private static final Log _logger = LogFactory.getLog(AlarmChangeProcessorImpl.class);
    private static final String ALARM_INFOS_QUERY_NAME = "AlarmChangeProcessorImpl.alarmInfos";
    private static final String ENTITY_NAMES_QUERY_NAME = "AlarmChangeProcessorImpl.entityNames";
    private final QueryExecutor queryExecutor;
    private final QuerySpecBuilder querySpecBuilder;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public AlarmChangeProcessorImpl(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    public PartialUpdate<AlarmState> process(Collection<AlarmChange> changes, String performanceLoggingPrefix) {
        PartialUpdate result = PartialUpdate.empty();
        for (AlarmChange change : changes) {
            PartialUpdateItem<AlarmState> update = this.createAlarmUpdate(change);
            result.getUpdates().add(update);
        }
        boolean metadataSuccessfulyAdded = this.addMetadataToNewAlarms((PartialUpdate<AlarmState>)result, performanceLoggingPrefix);
        if (!metadataSuccessfulyAdded) {
            AlarmChangeProcessorImpl.filterOutNewAlarms((PartialUpdate<AlarmState>)result);
        }
        result.setDestination("/topic/alarms");
        return result;
    }

    private static void filterOutNewAlarms(PartialUpdate<AlarmState> update) {
        ArrayList<PartialUpdateItem> filteredUpdate = new ArrayList<PartialUpdateItem>();
        for (PartialUpdateItem updateItem : update.updates) {
            if (!updateItem.isDelta) continue;
            filteredUpdate.add(updateItem);
        }
        update.updates = filteredUpdate;
    }

    private static boolean hasNewAlarms(PartialUpdate<AlarmState> update) {
        for (PartialUpdateItem updateItem : update.getUpdates()) {
            if (updateItem.isDelta) continue;
            return true;
        }
        return false;
    }

    private PartialUpdateItem<AlarmState> createAlarmUpdate(AlarmChange change) {
        PartialUpdateItem update = null;
        String updateKind = change.getKind();
        if (updateKind == null) {
            _logger.debug((Object)"Invalid alarm update kind.");
            return update;
        }
        AlarmState alarmState = AlarmChangeProcessorImpl.toAlarmState(change);
        if (AlarmChange.Kind.cleared.name().equals(updateKind)) {
            update = PartialUpdateItem.deltaOf(null, (Object)alarmState.key);
            if (alarmState.alarm != null) {
                AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.alarm.getServerGuid());
            }
        } else if (AlarmChange.Kind.triggered.name().equals(updateKind)) {
            update = PartialUpdateItem.of((Object)alarmState, (Object)change.getAlarm());
            AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.entity.getServerGuid());
        } else if (AlarmChange.Kind.retriggered.name().equals(updateKind) || AlarmChange.Kind.acknowledged.name().equals(updateKind)) {
            update = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
            AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.entity.getServerGuid());
        } else {
            _logger.warn((Object)String.format("Unknown alarm update kind %s.", updateKind));
        }
        return update;
    }

    private boolean addMetadataToNewAlarms(PartialUpdate<AlarmState> result, String performanceLoggingPrefix) {
        if (!AlarmChangeProcessorImpl.hasNewAlarms(result)) {
            return true;
        }
        ArrayList<AlarmState> alarmStates = new ArrayList<AlarmState>();
        HashMap<ManagedObjectReference, AlarmInfo> alarmInfos = new HashMap<ManagedObjectReference, AlarmInfo>();
        HashSet<ManagedObjectReference> entityNonRoots = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> entityRoots = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, String> entityNames = new HashMap<ManagedObjectReference, String>();
        this.extractAlarmInfosAndEntities(result.getUpdates(), alarmStates, alarmInfos, entityNonRoots, entityRoots);
        Set<ManagedObjectReference> alarmInfoKeys = alarmInfos.keySet();
        if (!this.populateAlarmInfos(alarmInfos, entityNonRoots, entityRoots, alarmInfoKeys) || !this.populateEntityNames(entityNonRoots, entityRoots, entityNames)) {
            return false;
        }
        Map<String, ServiceAlarmInfo> serviceInfos = this._serviceAlarmInfoRetriever.retrieve(alarmStates, performanceLoggingPrefix);
        this.populateMetadataForServiceAlarms(result, alarmInfos, entityNames, serviceInfos);
        return true;
    }

    private void populateMetadataForServiceAlarms(PartialUpdate<AlarmState> result, HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Map<ManagedObjectReference, String> entityNames, Map<String, ServiceAlarmInfo> serviceInfos) {
        StringBuilder unpopulatedAlarmsMessage = null;
        for (PartialUpdateItem partialUpdateItem : result.updates) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            String alarmStateKey = alarmState.key;
            ManagedObjectReference alarmStateEntity = alarmState.entity;
            AlarmInfo alarmInfo = alarmInfos.get(alarmState.alarm);
            if (alarmInfo != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, alarmStateKey, alarmInfo);
                ManagedObjectReference alarmInfoEntity = alarmInfo.entity;
                this.assignAlarmInfoNameMetadata(entityNames, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmInfoEntity, alarmStateKey);
                boolean showVamiLink = AlarmUtil.isVamiLinkVisisble(alarmInfo, alarmStateEntity);
                AlarmUtil.assignMetadata(partialUpdateItem, "showVAMILink", showVamiLink);
                AlarmUtil.assignMetadata(partialUpdateItem, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)alarmStateKey));
                this.assignIssueInfoMetadata(entityNames, serviceInfos, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmState, alarmStateEntity, alarmInfo);
                continue;
            }
            String alarmId = alarmStateEntity != null ? alarmStateKey + '(' + alarmStateEntity.getValue() + ':' + alarmStateEntity.getServerGuid() + ')' : alarmStateKey;
            if (!_logger.isDebugEnabled()) continue;
            if (unpopulatedAlarmsMessage == null) {
                unpopulatedAlarmsMessage = new StringBuilder("AlarmInfo is not populated for the following alarms:");
                unpopulatedAlarmsMessage.append(alarmId);
                continue;
            }
            unpopulatedAlarmsMessage.append(',').append(alarmId);
        }
        if (unpopulatedAlarmsMessage != null && _logger.isDebugEnabled()) {
            _logger.debug((Object)unpopulatedAlarmsMessage.toString());
        }
    }

    private void assignIssueInfoMetadata(Map<ManagedObjectReference, String> entityNames, Map<String, ServiceAlarmInfo> serviceInfos, PartialUpdateItem<AlarmState> partialUpdateItem, AlarmState alarmState, ManagedObjectReference alarmStateEntity, AlarmInfo alarmInfo) {
        IssueInfo issueInfo = new IssueInfo();
        if (alarmStateEntity != null) {
            issueInfo.entity = alarmStateEntity;
            String alarmStateEntityName = entityNames.get(alarmStateEntity);
            if (alarmStateEntityName != null) {
                issueInfo.entityName = alarmStateEntityName;
            } else {
                _logger.error((Object)("AlarmState entity name is not populated for " + alarmStateEntity));
            }
        } else {
            _logger.error((Object)("AlarmState entity is null for " + alarmState.key));
        }
        issueInfo.description = alarmInfo.description;
        ServiceAlarmInfo serviceAlarmInfo = serviceInfos.get(Util.buildAlarmKey(alarmState));
        issueInfo.service = serviceAlarmInfo;
        AlarmUtil.assignMetadata(partialUpdateItem, "issueInfo", issueInfo);
    }

    private void assignAlarmInfoNameMetadata(Map<ManagedObjectReference, String> entityNames, PartialUpdateItem<AlarmState> partialUpdateItem, ManagedObjectReference alarmInfoEntity, String alarmStateKey) {
        if (alarmInfoEntity != null) {
            String alarmInfoEntityName = entityNames.get(alarmInfoEntity);
            if (alarmInfoEntityName != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, "alarmInfoName", alarmInfoEntityName);
            } else {
                _logger.error((Object)("AlarmInfo entity name is not populated for " + alarmInfoEntity));
            }
        } else {
            _logger.error((Object)("AlarmInfo entity is null for " + alarmStateKey));
        }
    }

    private boolean populateAlarmInfos(HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots, Set<ManagedObjectReference> alarmInfoKeys) {
        PropertyValue[] alarmInfoProps;
        if (alarmInfoKeys.isEmpty()) {
            return true;
        }
        try {
            alarmInfoProps = this.queryProperties(alarmInfoKeys, "info", ALARM_INFOS_QUERY_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)("[LiveRefresh] Couldnt retrieve infos: " + e.getMessage()), (Throwable)e);
            return false;
        }
        for (PropertyValue pv : alarmInfoProps) {
            AlarmInfo alarmInfo = (AlarmInfo)pv.value;
            if (alarmInfo == null || alarmInfo.alarm == null) continue;
            alarmInfos.put(alarmInfo.alarm, alarmInfo);
            if (alarmInfo.entity == null) continue;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmInfo.entity)) {
                entityRoots.add(alarmInfo.entity);
                continue;
            }
            entityNonRoots.add(alarmInfo.entity);
        }
        return true;
    }

    private boolean populateEntityNames(Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots, Map<ManagedObjectReference, String> entityNames) {
        PropertyValue[] entityNameProps;
        for (ManagedObjectReference entityRoot : entityRoots) {
            String entityName = VcServiceUtil.getServiceName((String)entityRoot.getServerGuid());
            if (entityName == null) continue;
            entityNames.put(entityRoot, entityName);
        }
        if (entityNonRoots.isEmpty()) {
            return true;
        }
        try {
            entityNameProps = this.queryProperties(entityNonRoots, "name", ENTITY_NAMES_QUERY_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot extract entity names", (Throwable)e);
            return false;
        }
        for (PropertyValue entityPropVal : entityNameProps) {
            entityNames.put((ManagedObjectReference)entityPropVal.resourceObject, (String)entityPropVal.value);
        }
        return true;
    }

    private PropertyValue[] queryProperties(Set<ManagedObjectReference> objects, String propertyName, String queryName) throws Exception {
        ResultItem[] items;
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec(ArrayUtil.toArray(objects, ManagedObjectReference.class), new String[]{propertyName});
        querySpec.name = queryName;
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet != null && resultSet.error != null) {
            throw resultSet.error;
        }
        return result.toArray(new PropertyValue[0]);
    }

    private void extractAlarmInfosAndEntities(List<PartialUpdateItem<AlarmState>> updates, List<AlarmState> alarmsList, HashMap<ManagedObjectReference, AlarmInfo> alarmInfos, Set<ManagedObjectReference> entityNonRoots, Set<ManagedObjectReference> entityRoots) {
        for (PartialUpdateItem<AlarmState> pui : updates) {
            if (pui.isDelta) continue;
            AlarmState alarmState = (AlarmState)pui.data;
            alarmsList.add(alarmState);
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmState.entity)) {
                entityRoots.add(alarmState.entity);
            } else {
                entityNonRoots.add(alarmState.entity);
            }
            alarmInfos.put(alarmState.alarm, null);
        }
    }

    private static AlarmState toAlarmState(AlarmChange alarmChange) {
        AlarmState result = new AlarmState();
        result.key = AlarmChangeProcessorImpl.getAlarmStateKey(alarmChange);
        result.entity = alarmChange.getEntity();
        result.alarm = alarmChange.getAlarm();
        result.overallStatus = alarmChange.getOverallStatus();
        result.time = alarmChange.getTime();
        result.eventKey = alarmChange.getEventKey();
        result.acknowledged = AlarmChange.Kind.acknowledged.name().equals(alarmChange.getKind());
        result.acknowledgedByUser = alarmChange.getAcknowledgedByUser();
        result.acknowledgedTime = alarmChange.getAcknowledgedTime();
        return result;
    }

    private static String getAlarmStateKey(AlarmChange alarmChange) {
        if (!(alarmChange.getAlarm() instanceof ManagedObjectReference)) {
            return null;
        }
        ManagedObjectReference alarm = alarmChange.getAlarm();
        ManagedObjectReference entity = alarmChange.getEntity();
        return alarm.getValue() + "." + entity.getValue();
    }
}

