/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityNameRetriever {
    private static final String NAME_PROPERTY = "name";
    private static final String VC_NAME_PROPERTY = "vCenterName";
    private static final int MAX_QUERY_SIZE = 64;
    private static final Log _logger = LogFactory.getLog(EntityNameRetriever.class);
    private DataService _dataService;

    public EntityNameRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<ManagedObjectReference, String> retrieve(AlarmState[] triggeredAlarms, Map<ManagedObjectReference, AlarmInfo> alarmDefinitions) {
        HashSet<ManagedObjectReference> nonRootEntitySet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> rootEntitySet = new HashSet<ManagedObjectReference>();
        this.getAlarmEntities(triggeredAlarms, alarmDefinitions, nonRootEntitySet, rootEntitySet);
        HashMap<ManagedObjectReference, String> entityNames = new HashMap<ManagedObjectReference, String>();
        this.fillEntityNames(nonRootEntitySet, NAME_PROPERTY, entityNames);
        this.fillEntityNames(rootEntitySet, VC_NAME_PROPERTY, entityNames);
        return entityNames;
    }

    private void getAlarmEntities(AlarmState[] triggeredAlarms, Map<ManagedObjectReference, AlarmInfo> alarmDefinitions, Set<ManagedObjectReference> nonRootEntitySet, Set<ManagedObjectReference> rootEntitySet) {
        for (AlarmState alarmState : triggeredAlarms) {
            this.addEntityToSet(alarmState.entity, nonRootEntitySet, rootEntitySet);
        }
        for (AlarmInfo alarmInfo : alarmDefinitions.values()) {
            this.addEntityToSet(alarmInfo.entity, nonRootEntitySet, rootEntitySet);
        }
    }

    private void addEntityToSet(ManagedObjectReference entity, Set<ManagedObjectReference> nonRootEntitySet, Set<ManagedObjectReference> rootEntitySet) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)entity)) {
            rootEntitySet.add(entity);
        } else {
            nonRootEntitySet.add(entity);
        }
    }

    private void fillEntityNames(Set<ManagedObjectReference> entitySet, String nameProperty, Map<ManagedObjectReference, String> entityNames) {
        if (entitySet.isEmpty()) {
            return;
        }
        int currentQueryCount = 0;
        int totalProcessedEntities = 0;
        int entitiesArraySize = Math.min(64, entitySet.size());
        ManagedObjectReference[] entities = new ManagedObjectReference[entitiesArraySize];
        Iterator<ManagedObjectReference> iterator = entitySet.iterator();
        while (iterator.hasNext()) {
            entities[currentQueryCount] = iterator.next();
            ++totalProcessedEntities;
            if (++currentQueryCount != entitiesArraySize) continue;
            this.getEntityNames(nameProperty, entities, entityNames);
            currentQueryCount = 0;
            entitiesArraySize = Math.min(64, entitySet.size() - totalProcessedEntities);
            if (entitiesArraySize == 0 || entitiesArraySize >= 64) continue;
            entities = new ManagedObjectReference[entitiesArraySize];
        }
    }

    private void getEntityNames(String nameProperty, ManagedObjectReference[] entities, Map<ManagedObjectReference, String> entityNames) {
        try {
            PropertyValue[] returnedProperties;
            for (PropertyValue propertyValue : returnedProperties = QueryUtil.getProperty((DataService)this._dataService, (Object[])entities, (String)nameProperty)) {
                entityNames.put((ManagedObjectReference)propertyValue.resourceObject, (String)propertyValue.value);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieving entity names", (Throwable)e);
        }
    }
}

