/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support;

import com.vmware.ph.support.client.api.SrUploadConnectionException;
import com.vmware.ph.support.client.api.SrUploader;
import com.vmware.ph.support.client.api.impl.SrUploaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class ConsoleExample {
    public static void main(String[] args) throws FileNotFoundException, SrUploadConnectionException, InterruptedException, ExecutionException {
        String fileName = ConsoleExample.getOptionValue("-f", args);
        String srNumber = ConsoleExample.getOptionValue("-sr", args);
        String serverUrl = ConsoleExample.getOptionValue("-h", args);
        if (!ConsoleExample.validateInput(fileName, srNumber)) {
            return;
        }
        FileInputStream stream = new FileInputStream(fileName);
        String targetName = new File(fileName).getName();
        ConsoleExample.customerServerUsage(targetName, stream, srNumber, serverUrl);
        System.out.println("Sent Successfully!");
    }

    private static void customerServerUsage(String targetFileName, InputStream stream, String srNumber, String serverUrl) throws FileNotFoundException, SrUploadConnectionException, InterruptedException, ExecutionException {
        SrUploader srUploader = SrUploaderFactory.getSrUploaderForCustomerServer(null, serverUrl, null);
        Future<?> f = srUploader.attachStreamToSr(targetFileName, stream, srNumber);
        f.get();
    }

    private static boolean validateInput(String fileName, String kb) {
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)fileName)) {
            System.out.println("A file name must be specified.");
            isValid = false;
        }
        if (StringUtils.isBlank((CharSequence)kb)) {
            System.out.println("The SR# must be specified.");
            isValid = false;
        }
        if (!isValid) {
            System.out.println("\nUsage: \n java -jar ph-gss-uploader.jar -f <file name> -sr <SR#> -h <api server url with context path>\n");
        }
        return isValid;
    }

    private static String getOptionValue(String option, String[] args) {
        String value = null;
        for (int i = 0; i < args.length; ++i) {
            if (!option.equals(args[i]) || i >= args.length - 1) continue;
            value = args[i + 1];
            break;
        }
        return value;
    }
}

