/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.client.api.impl;

import com.vmware.ph.support.client.api.SrUploader;
import com.vmware.ph.upload.service.UploadService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SrUploaderImpl
implements SrUploader {
    static final String GSS_SR_FILING_COLLECTOR = "gss.sr.noncollector";
    static final String FILENAME_TIMESTAMP_DATE_FORMAT = "yyyy-MM-dd-HHmm-ss.SSS";
    private static final List<String> RECOGNIZED_LONG_FILE_EXTENSIONS = Arrays.asList(".jar.pack", ".tar.bz2", ".tar.gz2", ".tar.gz", ".tar.lzma", ".tar.lz", ".pkg.tar.xz", ".tar.xz", ".tar.z", ".pack.gz", ".pkg.tar", ".ufs.uzip");
    private static final Logger log = LoggerFactory.getLogger(SrUploaderImpl.class);
    private final UploadService uploadService;
    private final FileSystemOperationsWrapper fileSystemOperationsWrapper;

    public SrUploaderImpl(UploadService uploadService) {
        this(uploadService, new FileSystemOperationsWrapper());
    }

    SrUploaderImpl(UploadService uploadService, FileSystemOperationsWrapper fileSystemOperationsWrapper) {
        this.uploadService = uploadService;
        this.fileSystemOperationsWrapper = fileSystemOperationsWrapper;
    }

    @Override
    public Future<?> attachFileToSr(File fileToUpload, String srNumber) throws FileNotFoundException {
        if (fileToUpload.length() <= 0L) {
            throw new IllegalArgumentException("The file to be uploaded must have size > 0.");
        }
        InputStream stream = this.fileSystemOperationsWrapper.createStream(fileToUpload);
        return this.attachStreamToSr(fileToUpload.getName(), stream, srNumber);
    }

    @Override
    public Future<?> attachStreamToSr(String targetFileName, InputStream stream, String srNumber) {
        Validate.notEmpty((String)srNumber);
        Validate.notEmpty((String)targetFileName);
        Validate.notNull((Object)stream);
        String targetFileNameUnique = this.makeRemoteFilename(srNumber, targetFileName);
        String instanceId = UUID.randomUUID().toString();
        String uploadId = UUID.randomUUID().toString();
        int size = 1;
        log.debug("Attaching '{}' file to SR#='{}' with instanceId='{}' and uploadId='{}' and destination name='{}'", new Object[]{targetFileName, srNumber, instanceId, uploadId, targetFileNameUnique});
        return this.uploadService.upload(GSS_SR_FILING_COLLECTOR, instanceId, uploadId, targetFileNameUnique, stream, (long)size);
    }

    private String makeRemoteFilename(String srNumber, String fileName) {
        String folderName = "/" + srNumber;
        String fileNameWithTimestamp = this.addCurrentTimestampToFileName(fileName);
        return folderName + "/" + fileNameWithTimestamp;
    }

    private String addCurrentTimestampToFileName(String fileName) {
        SimpleDateFormat format = new SimpleDateFormat(FILENAME_TIMESTAMP_DATE_FORMAT);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = format.format(new Date());
        int fileExtensionIndex = fileName.length();
        String fileExtension = this.getFileExtensionFromFilename(fileName);
        if (fileExtension != null && fileExtension.length() > 0) {
            fileExtensionIndex = fileName.indexOf(fileExtension);
        }
        String filenameWithoutExtension = fileName.substring(0, fileExtensionIndex);
        String timestampedFilename = filenameWithoutExtension + "." + timestamp + fileExtension;
        return timestampedFilename;
    }

    private String getFileExtensionFromFilename(String fileName) {
        int fileExtensionIndex;
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        String fileExtension = null;
        for (String longFileExtension : RECOGNIZED_LONG_FILE_EXTENSIONS) {
            if (!fileName.endsWith(longFileExtension)) continue;
            fileExtension = longFileExtension;
            break;
        }
        if (fileExtension == null && (fileExtensionIndex = fileName.lastIndexOf(".")) != -1) {
            fileExtension = fileName.substring(fileExtensionIndex);
        }
        return fileExtension;
    }

    static class FileSystemOperationsWrapper {
        FileSystemOperationsWrapper() {
        }

        public InputStream createStream(File file) throws FileNotFoundException {
            return new FileInputStream(file);
        }
    }
}

