/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.commands.resmgmt;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.TaskCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.ResControlUpgradeVersionCommandSpec;

public class ResControlUpgradeVersionCommand
extends TaskCommand {
    private static final String PROP_DVS_CONFIG_VERSION = "config.configVersion";
    private final DataService _dataService;

    public ResControlUpgradeVersionCommand(ResControlUpgradeVersionCommandSpec spec, DataService dataService) {
        this.setCommandSpec((BaseCommandSpec)spec);
        this._dataService = dataService;
    }

    protected Task launch() throws Exception {
        ResControlUpgradeVersionCommandSpec spec = (ResControlUpgradeVersionCommandSpec)this.getCommandSpec();
        String configVersion = spec.configVersion;
        if (configVersion == "") {
            configVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.mor, (String)PROP_DVS_CONFIG_VERSION);
        }
        DistributedVirtualSwitch.ConfigSpec configSpec = new DistributedVirtualSwitch.ConfigSpec();
        configSpec.configVersion = configVersion;
        configSpec.networkResourceControlVersion = DistributedVirtualSwitch.NetworkResourceControlVersion.version3.name();
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.mor);
        ManagedObjectReference taskRef = dvs.reconfigure(configSpec);
        return (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRef);
    }
}

