/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.lacp;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.dvs.api.common.ValidationResultType;
import com.vmware.vsphere.client.dvs.api.featureupgrade.ValidationCheckResult;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.networking.util.I18nUtil;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LacpUpgradePrerequisitesValidator {
    private static final Log _logger = LogFactory.getLog(LacpUpgradePrerequisitesValidator.class);
    private static final String PRIVILEGE_PORT_GROUP_MODIFY = "DVPortgroup.Modify";
    private static final String PRIVILEGE_HOST_CONFIG_NETWORK = "Host.Config.Network";
    private static final String[] REQUIRED_PRIVILEGES_FOR_PORT_GROUP = new String[]{"DVPortgroup.Modify"};
    private static final String[] REQUIRED_PRIVILEGES_FOR_HOST = new String[]{"Host.Config.Network"};
    private static final String PROP_LEGACY_LACP_ENABLE = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].lacpPolicy.enable.value";
    private static final String PROP_PORT_GROUP_NAME = "name";
    private static final String PROP_PORT_GROUP_TEAMING_OVERRIDE = "config.policy[@type='VMwareDVSPortgroupPolicy'].uplinkTeamingOverrideAllowed";
    private static final String PROP_ALL_HOSTS_COUNT = "summary.numHosts";
    private static final String PROP_ACCESSIBLE_HOSTS_COUNT = "summary.hostMember._length";
    private static final String PROP_HOST_NAME = "name";
    private static final String PROP_HOST_POWER_STATE = "runtime.powerState";
    private static final String PROP_HOST_CONNECTION_STATE = "runtime.connectionState";
    private final DataService _dataService;
    private final LegacyAuthorizationService _authorizationService;

    public ValidationCheckResult[] validatePrerequisites(ManagedObjectReference dvsRef) throws Exception {
        if (dvsRef == null) {
            return null;
        }
        ArrayList<ValidationCheckResult> results = new ArrayList<ValidationCheckResult>();
        ValidationCheckResult pgAccessResult = this.validatePortGroupAccessibility(dvsRef);
        results.add(pgAccessResult);
        if (pgAccessResult.type != ValidationResultType.pass) {
            return new ValidationCheckResult[]{pgAccessResult};
        }
        try {
            if (this.retrieveUplinkPortGroupCount(dvsRef) > 1) {
                results.add(LacpUpgradePrerequisitesValidator.createMultipleUplinkPortGroupValidationResult());
                return LacpUpgradePrerequisitesValidator.toArray(results);
            }
            List<String> lacpUplinkPortGroups = this.retrieveLacpEnabledUplinkPortGroups(dvsRef);
            ValidationCheckResult res = null;
            res = LacpUpgradePrerequisitesValidator.createExistingLacpConfigValidationResult(lacpUplinkPortGroups);
            results.add(res);
            if (lacpUplinkPortGroups.size() != 1) {
                return LacpUpgradePrerequisitesValidator.toArray(results);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
            String message = I18nUtil.text("lacp.upgrade.check.lacpConfig.name", new String[0]);
            results.add(LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(message));
            return LacpUpgradePrerequisitesValidator.toArray(results);
        }
        ValidationCheckResult pgPrivilegesResult = this.validatePortGroupPrivileges(dvsRef);
        if (pgPrivilegesResult.type == ValidationResultType.fail) {
            results.set(results.indexOf(pgAccessResult), pgPrivilegesResult);
        }
        ValidationCheckResult pgOverridesResult = this.validatePortGroupOverrides(dvsRef);
        results.add(pgOverridesResult);
        ValidationCheckResult hostAccessResult = this.validateHostAccessibility(dvsRef);
        if (hostAccessResult.type == ValidationResultType.fail || I18nUtil.text("lacp.upgrade.check.hostAccess.noHosts", new String[0]).equals(hostAccessResult.message)) {
            results.add(hostAccessResult);
        } else {
            ValidationCheckResult hostPrivilegesResult = this.validateHostPrivileges(dvsRef);
            results.add(hostPrivilegesResult);
            ValidationCheckResult hostConnectivityResult = this.validateHostConnectivity(dvsRef);
            results.add(hostConnectivityResult);
        }
        return LacpUpgradePrerequisitesValidator.toArray(results);
    }

    public Boolean validateLacpEnabled(ManagedObjectReference dvsRef) throws Exception {
        List<String> lacpUplinkPortGroups = this.retrieveLacpEnabledUplinkPortGroups(dvsRef);
        return !lacpUplinkPortGroups.isEmpty();
    }

    private int retrieveUplinkPortGroupCount(ManagedObjectReference dvsRef) throws Exception {
        return (Integer)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.uplinkPortgroup._length");
    }

    private ValidationCheckResult validatePortGroupAccessibility(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.pgAccess.name", new String[0]);
        try {
            boolean allAccessibile = DvsUtil.areAllPortGroupsAccessible(dvsRef, this._dataService);
            if (allAccessibile) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.pgAccess.pass", new String[0]), null);
            }
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.pgAccess.fail.noAccess", new String[0]), null);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private List<String> retrieveLacpEnabledUplinkPortGroups(ManagedObjectReference dvsRef) throws Exception {
        Map<Object, Map<String, Object>> legacyLacpConfig = Util.propertyValuesToMap(QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)dvsRef, (String)"uplinkPortgroup", (String)DistributedVirtualPortgroup.class.getSimpleName(), (String[])new String[]{PROP_LEGACY_LACP_ENABLE, "name"}));
        ArrayList<String> lacpUplinkPortGroups = new ArrayList<String>();
        if (legacyLacpConfig == null) {
            return lacpUplinkPortGroups;
        }
        for (Map<String, Object> props : legacyLacpConfig.values()) {
            Boolean lacpEnabled = (Boolean)props.get(PROP_LEGACY_LACP_ENABLE);
            String uplinkPgName = (String)props.get("name");
            if (uplinkPgName == null) {
                _logger.error((Object)("Unable to retrieve an uplink name of the distributed switch " + dvsRef.toString()));
                continue;
            }
            if (lacpEnabled == null || !lacpEnabled.booleanValue()) continue;
            lacpUplinkPortGroups.add(uplinkPgName);
        }
        return lacpUplinkPortGroups;
    }

    private ValidationCheckResult validatePortGroupPrivileges(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.pgPrivileges.name", new String[0]);
        try {
            PropertyValue[] entityNames = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)dvsRef, (String)"portgroup", (String)DistributedVirtualPortgroup.class.getSimpleName(), (String[])new String[]{"name"});
            List<String> noPrivList = Util.checkEntitiesWithMissingPrivileges(entityNames, REQUIRED_PRIVILEGES_FOR_PORT_GROUP, this._authorizationService);
            if (noPrivList.isEmpty()) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.pgPrivileges.pass", new String[0]), null);
            }
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.pgPrivileges.fail.noPrivileges", new String[0]), noPrivList.toArray(new String[noPrivList.size()]));
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validatePortGroupOverrides(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.pgOverrides.name", new String[0]);
        try {
            ValidationCheckResult result;
            ResultSet rs = DvsUtil.retrievePortGroupsByOverridablePolicy(this._dataService, dvsRef, PROP_PORT_GROUP_TEAMING_OVERRIDE, new String[]{"name"});
            if (rs == null) {
                result = LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            } else if (rs.error != null) {
                _logger.error((Object)"Could not retrieve port groups that allow uplink teamin override", (Throwable)rs.error);
                result = LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            } else if (ArrayUtil.isNullOrEmpty((Object[])rs.items)) {
                String[] portKeys = DvsUtil.retrieveStandaloneAndConflictPortKeys(dvsRef);
                result = portKeys == null || portKeys.length == 0 ? LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.pgOverrides.pass", new String[0]), null) : LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.pgOverrides.fail.standalonePorts", new String[0]), null);
            } else {
                Map<Object, Map<String, Object>> results = Util.resultSetToMap(rs);
                ArrayList<String> overrideAllowedPgList = new ArrayList<String>();
                for (Map<String, Object> pgProps : results.values()) {
                    String name = (String)pgProps.get("name");
                    overrideAllowedPgList.add(name);
                }
                assert (!overrideAllowedPgList.isEmpty());
                String[] affectedEntities = overrideAllowedPgList.toArray(new String[overrideAllowedPgList.size()]);
                result = LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.pgOverrides.fail.overrideAllowed", new String[0]), affectedEntities);
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validateHostAccessibility(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.hostAccess.name", new String[0]);
        try {
            String[] dvsHostAccessProps = new String[]{PROP_ALL_HOSTS_COUNT, PROP_ACCESSIBLE_HOSTS_COUNT};
            Object[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])dvsHostAccessProps);
            if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.hostAccess.noHosts", new String[0]), null);
            }
            Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap((PropertyValue[])propertyValues);
            if (rs == null || rs.size() != 1) {
                return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            }
            Map<String, Object> props = rs.get(dvsRef);
            if (props == null) {
                return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            }
            Integer allHostCount = (Integer)props.get(PROP_ALL_HOSTS_COUNT);
            if (allHostCount == null) {
                return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            }
            Integer accessibleHostCount = (Integer)props.get(PROP_ACCESSIBLE_HOSTS_COUNT);
            if (accessibleHostCount == null) {
                accessibleHostCount = 0;
            }
            if (allHostCount.intValue() == accessibleHostCount.intValue()) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.hostAccess.pass", new String[0]), null);
            }
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.hostAccess.fail.noAccess", new String[0]), null);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validateHostPrivileges(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.hostAccess.name", new String[0]);
        try {
            PropertyValue[] entityNames = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)dvsRef, (String)"host", (String)HostSystem.class.getSimpleName(), (String[])new String[]{"name"});
            List<String> noPrivList = Util.checkEntitiesWithMissingPrivileges(entityNames, REQUIRED_PRIVILEGES_FOR_HOST, this._authorizationService);
            if (noPrivList.isEmpty()) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.hostAccess.pass", new String[0]), null);
            }
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.hostAccess.fail.noPrivileges", new String[0]), noPrivList.toArray(new String[noPrivList.size()]));
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validateHostConnectivity(ManagedObjectReference dvsRef) {
        String checkName = I18nUtil.text("lacp.upgrade.check.hostState.name", new String[0]);
        try {
            Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap(QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)dvsRef, (String)"host", (String)HostSystem.class.getSimpleName(), (String[])new String[]{"name", PROP_HOST_CONNECTION_STATE, PROP_HOST_POWER_STATE}));
            ArrayList<String> notRespondingHostList = new ArrayList<String>();
            for (Map<String, Object> pgProps : rs.values()) {
                String name = (String)pgProps.get("name");
                HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)pgProps.get(PROP_HOST_CONNECTION_STATE);
                HostSystem.PowerState powerState = (HostSystem.PowerState)pgProps.get(PROP_HOST_POWER_STATE);
                if (name == null || connectionState == null) {
                    return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
                }
                if (HostSystem.ConnectionState.connected.equals((Object)connectionState) && HostSystem.PowerState.poweredOn.equals((Object)powerState)) continue;
                notRespondingHostList.add(name);
            }
            if (notRespondingHostList.isEmpty()) {
                return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("lacp.upgrade.check.hostState.pass", new String[0]), null);
            }
            String[] affectedEntities = notRespondingHostList.toArray(new String[notRespondingHostList.size()]);
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.hostState.fail.noConnectivity", new String[0]), affectedEntities);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return LacpUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private LacpUpgradePrerequisitesValidator(DataService dataService, LegacyAuthorizationService authorizationService) {
        if (dataService == null) {
            throw new IllegalArgumentException("Parameter 'dataService' is required.");
        }
        if (authorizationService == null) {
            throw new IllegalArgumentException("Parameter 'authorizationService' is required.");
        }
        this._dataService = dataService;
        this._authorizationService = authorizationService;
    }

    private static ValidationCheckResult createMultipleUplinkPortGroupValidationResult() {
        return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, I18nUtil.text("lacp.upgrade.check.lacpConfig.name", new String[0]), I18nUtil.text("lacp.upgrade.check.lacpConfig.fail.multipleUplinkPortGroups", new String[0]), null);
    }

    private static ValidationCheckResult createExistingLacpConfigValidationResult(List<String> lacpUplinkPortGroups) {
        String[] entityArray = lacpUplinkPortGroups.toArray(new String[lacpUplinkPortGroups.size()]);
        String lacpConfigName = I18nUtil.text("lacp.upgrade.check.lacpConfig.name", new String[0]);
        if (lacpUplinkPortGroups.isEmpty()) {
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, lacpConfigName, I18nUtil.text("lacp.upgrade.check.lacpConfig.pass.noLags", new String[0]), null);
        }
        if (lacpUplinkPortGroups.size() == 1) {
            return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, lacpConfigName, I18nUtil.text("lacp.upgrade.check.lacpConfig.pass.singleLag", new String[0]), entityArray);
        }
        return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, lacpConfigName, I18nUtil.text("lacp.upgrade.check.lacpConfig.fail.multipleLags", new String[0]), entityArray);
    }

    private static ValidationCheckResult createGeneralErrorValidationResult(String checkName) {
        return LacpUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("lacp.upgrade.check.genericError", new String[0]), null);
    }

    private static ValidationCheckResult createCheckResult(ValidationResultType type2, String checkName, String message, String[] affectedEntities) {
        ValidationCheckResult result = new ValidationCheckResult();
        result.type = type2;
        result.checkName = checkName;
        result.message = message;
        result.affectedEntities = affectedEntities == null ? null : (String[])affectedEntities.clone();
        return result;
    }

    private static ValidationCheckResult[] toArray(List<ValidationCheckResult> results) {
        return results.toArray(new ValidationCheckResult[results.size()]);
    }
}

