/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.lacp.commands;

import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.TaskCommand;
import com.vmware.vsphere.client.dvs.lacp.specs.LagCreateCommandSpec;

public class LagCreateCommand
extends TaskCommand {
    public LagCreateCommand(LagCreateCommandSpec spec) {
        this.setCommandSpec(spec);
    }

    protected Task launch() throws Exception {
        LagCreateCommandSpec commandSpec = (LagCreateCommandSpec)this.getCommandSpec();
        if (commandSpec.lag == null) {
            throw new IllegalArgumentException("Cannot execute LagCreateCommand with no LAG specified.");
        }
        VmwareDistributedVirtualSwitch dvs = (VmwareDistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)commandSpec.mor);
        VmwareDistributedVirtualSwitch.LacpGroupSpec spec = new VmwareDistributedVirtualSwitch.LacpGroupSpec();
        spec.operation = ConfigChange.Operation.add.name();
        spec.lacpGroupConfig = commandSpec.lag;
        ManagedObjectReference taskRef = dvs.updateLacpGroupConfig(new VmwareDistributedVirtualSwitch.LacpGroupSpec[]{spec});
        return (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRef);
    }
}

