/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networkselector.impl;

import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorFilterSpec;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorPortgroupData;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorResult;
import com.vmware.vsphere.client.networkselector.NetworkAdapterNetworkMatch;
import com.vmware.vsphere.client.networkselector.NetworkSelectorNetworkMatch;
import com.vmware.vsphere.client.networkselector.NetworkSelectorOpaqueNetworkTypeData;
import com.vmware.vsphere.client.networkselector.NetworkSelectorUtil;
import com.vmware.vsphere.client.networkselector.impl.NetworkSelectorMatcherService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkSelectorPropertyProvider
implements PropertyProviderBean {
    private static final String NAME_PROPERTY = "name";
    private static final String OPAQUE_NETWORK_TYPE_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType";
    private static final String NSX_NETWORK_TYPE_PROPERTY_VALUE = "nsx.LogicalSwitch";
    private static final String OPAQUE_NETWORK_ID_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkId";
    private static final String NETWORK_NAME_PROPERTY = "name";
    private static final String DVS_NAME_PROPERTY = "dvsName";
    private static final String PORTGROUP_DVS_NAME_PROPERTY = "dvsName";
    private static final String DVPG_KEY_PROPERTY = "key";
    private static final String DVPG_DVS_UUID_PROPERTY = "dvsUuid";
    private static final String VM_DEVICES_PROPERTY = "config.hardware.device";
    private static final String VM_NETWORK_RELATION = "allNetwork";
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final String NETWORK_NAME_UI_FIELD = "name";
    private static final String PORTGROUP_DVSNAME_UI_FIELD = "dvsName";
    private static Log _logger = LogFactory.getLog(NetworkSelectorPropertyProvider.class);
    private final DataService _dataService;
    private final NetworkSelectorMatcherService _networkSelectorMatcherService;

    public NetworkSelectorPropertyProvider(DataService dataService, NetworkSelectorMatcherService networkSelectorMatcherService) {
        this._dataService = dataService;
        this._networkSelectorMatcherService = networkSelectorMatcherService;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource,com.vmware.vcenter.vdcs.Vdc")
    public NetworkSelectorPortgroupData[] getNetworkSelectorFilteredNetworksByRefs(Object target, Object[] networkRefs) {
        networkRefs = this.getRelatedNetworksByRefs(target, networkRefs, false);
        return this.getNetworkSelectorFilteredNetworksByRefs(networkRefs);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource,com.vmware.vcenter.vdcs.Vdc")
    public NetworkSelectorResult getNetworkSelectorFilteredNetworks(Object target, NetworkSelectorFilterSpec filterSpec) {
        long startTimeNs = System.nanoTime();
        NetworkSelectorResult networks = this.getNetworkSelectorFilteredNetworksInternal(target, filterSpec);
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            int netCount = networks.networks == null ? 0 : networks.networks.length;
            _logger.debug((Object)String.format("getNetworkSelectorFilteredNetworks() - %.3fs - %d networks.", durationS, netCount));
        }
        return networks;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkAdapterNetworkMatch[] getDestinationNetworksForVms(ManagedObjectReference destination, Object[] vms) throws Exception {
        Object[] vmRefs = NetworkSelectorUtil.getMorsOfType(vms, VirtualMachine.class.getSimpleName());
        if (ArrayUtil.isNullOrEmpty((Object[])vmRefs)) {
            return new NetworkAdapterNetworkMatch[0];
        }
        HashMap<String, ManagedObjectReference> networksByKey = new HashMap<String, ManagedObjectReference>();
        ArrayList<Object> sourceNetworks = new ArrayList<Object>();
        this.populateSourceNetworkData((ManagedObjectReference[])vmRefs, networksByKey, sourceNetworks);
        List<NetworkAdapterNetworkMatch> matches = this.getAdaptersDataForVms((ManagedObjectReference[])vmRefs, networksByKey);
        NetworkSelectorPortgroupData[] sourceData = this.getNetworkSelectorFilteredNetworksByRefs(sourceNetworks.toArray(new Object[sourceNetworks.size()]));
        Object[] matchedDestinationNetworks = this._networkSelectorMatcherService.getMatchingNetworks(destination, sourceData);
        NetworkSelectorPortgroupData[] destinationNetworksData = this.getNetworkSelectorFilteredNetworksByRefs(matchedDestinationNetworks);
        NetworkMatchFactory networkMatchFactory = new NetworkMatchFactory(destinationNetworksData);
        NetworkSelectorNetworkMatch[] networkMatches = new NetworkSelectorNetworkMatch[sourceData.length];
        for (int index = 0; index < networkMatches.length; ++index) {
            networkMatches[index] = networkMatchFactory.newNetworkMatch(sourceData[index]);
        }
        HashMap<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource = new HashMap<ManagedObjectReference, ManagedObjectReference>(networkMatches.length);
        for (NetworkSelectorNetworkMatch networkMatch : networkMatches) {
            destinationNetworkBySource.put(networkMatch.source, networkMatch.destination);
        }
        this.populateDestinationNetworkData(destinationNetworkBySource, matches);
        return matches.toArray(new NetworkAdapterNetworkMatch[matches.size()]);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkSelectorNetworkMatch[] getDestinationNetworksByContext(ManagedObjectReference destination, Object[] sources) throws Exception {
        return this.getDestinationNetworksByContextInternal(destination, sources);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkSelectorOpaqueNetworkTypeData[] getOpaqueNetworkTypes(ManagedObjectReference destination, Object[] opaqueNetworks) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks)) {
            return null;
        }
        Object[] propertyValues = null;
        try {
            propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])opaqueNetworks, (String)OPAQUE_NETWORK_TYPE_PROPERTY);
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of opaque network types failed:" + e.getLocalizedMessage()));
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return null;
        }
        LinkedList<NetworkSelectorOpaqueNetworkTypeData> networkTypes = new LinkedList<NetworkSelectorOpaqueNetworkTypeData>();
        for (Object prop : propertyValues) {
            networkTypes.add(new NetworkSelectorOpaqueNetworkTypeData((ManagedObjectReference)((PropertyValue)prop).resourceObject, (String)((PropertyValue)prop).value));
        }
        return networkTypes.toArray(new NetworkSelectorOpaqueNetworkTypeData[networkTypes.size()]);
    }

    private NetworkSelectorResult getNetworkSelectorFilteredNetworksInternal(Object target, NetworkSelectorFilterSpec filterSpec) {
        HashSet<ManagedObjectReference> distributedPortGroupsSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> uplinkPortGroupsSet = new HashSet<ManagedObjectReference>();
        Object[] relatedFilterNetworks = ArrayUtil.isNullOrEmpty((Object[])filterSpec.networks) || filterSpec.networksCount == null ? new Object[]{} : this.getRelatedNetworksByRefs(target, filterSpec.networks, distributedPortGroupsSet, uplinkPortGroupsSet, filterSpec.includeInaccessibleNetworks, true);
        QuerySpec networksQuerySpec = this.buildQuerySpecForNetworks(target, filterSpec);
        ResultSet networkPropsResultSet = this.requestNetworks(networksQuerySpec);
        if (networkPropsResultSet == null || ArrayUtil.isNullOrEmpty((Object[])networkPropsResultSet.items)) {
            return new NetworkSelectorResult(new NetworkSelectorPortgroupData[0], 0);
        }
        ArrayList<ManagedObjectReference> requiredNetworkRefs = this.getRequiredNetworkRefs(relatedFilterNetworks, networkPropsResultSet.items, filterSpec.networksCount);
        this.populatePortGroupSets(distributedPortGroupsSet, uplinkPortGroupsSet, requiredNetworkRefs, networkPropsResultSet.items);
        List<NetworkSelectorPortgroupData> retrievedNetworksProperties = this.retrieveNetworkProperties(filterSpec, requiredNetworkRefs, distributedPortGroupsSet, uplinkPortGroupsSet);
        HashMap<Object, Integer> resultsOrder = new HashMap<Object, Integer>(requiredNetworkRefs.size());
        for (int i = 0; i < requiredNetworkRefs.size(); ++i) {
            ManagedObjectReference ref = requiredNetworkRefs.get(i);
            resultsOrder.put(ref, i);
        }
        NetworkSelectorPortgroupData[] result = this.processResultNetworks(retrievedNetworksProperties, resultsOrder);
        return new NetworkSelectorResult(result, networkPropsResultSet.totalMatchedObjectCount.intValue());
    }

    private ArrayList<ManagedObjectReference> getRequiredNetworkRefs(Object[] relatedFilterNetworks, ResultItem[] retrievedNetworks, Integer networksCount) {
        LinkedHashSet<ManagedObjectReference> requiredNetworks = new LinkedHashSet<ManagedObjectReference>();
        if (ArrayUtil.isNullOrEmpty((Object[])retrievedNetworks)) {
            return new ArrayList<ManagedObjectReference>(requiredNetworks);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])relatedFilterNetworks)) {
            for (Object relatedNetwork : relatedFilterNetworks) {
                if (!(relatedNetwork instanceof ManagedObjectReference)) continue;
                requiredNetworks.add((ManagedObjectReference)relatedNetwork);
            }
        }
        for (ResultItem retrievedNetwork : retrievedNetworks) {
            if (!(retrievedNetwork.resourceObject instanceof ManagedObjectReference)) continue;
            requiredNetworks.add((ManagedObjectReference)retrievedNetwork.resourceObject);
            if (networksCount != null && requiredNetworks.size() >= networksCount) break;
        }
        return new ArrayList<ManagedObjectReference>(requiredNetworks);
    }

    private NetworkSelectorPortgroupData[] processResultNetworks(List<NetworkSelectorPortgroupData> retrievedNetworks, final Map<Object, Integer> resultsOrder) {
        NetworkSelectorPortgroupData[] result = retrievedNetworks.toArray(new NetworkSelectorPortgroupData[retrievedNetworks.size()]);
        Arrays.sort(result, new java.util.Comparator<NetworkSelectorPortgroupData>(){

            @Override
            public int compare(NetworkSelectorPortgroupData lhs, NetworkSelectorPortgroupData rhs) {
                Integer leftIdx = (Integer)resultsOrder.get(lhs.networkRef);
                Integer rightIdx = (Integer)resultsOrder.get(rhs.networkRef);
                if (leftIdx == null) {
                    if (rightIdx == null) {
                        return 0;
                    }
                    return 1;
                }
                if (rightIdx == null) {
                    return -1;
                }
                return leftIdx - rightIdx;
            }
        });
        return result;
    }

    private List<NetworkSelectorPortgroupData> retrieveNetworkProperties(NetworkSelectorFilterSpec filterSpec, ArrayList<ManagedObjectReference> requiredNetworks, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet) {
        long startTimeNs = System.nanoTime();
        ArrayList<ManagedObjectReference> standardNetworkRefs = new ArrayList<ManagedObjectReference>();
        ArrayList<ManagedObjectReference> opaqueNetworkRefs = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference requiredNetwork : requiredNetworks) {
            if (Network.class.getSimpleName().equals(requiredNetwork.getType())) {
                standardNetworkRefs.add(requiredNetwork);
                continue;
            }
            if (!OpaqueNetwork.class.getSimpleName().equals(requiredNetwork.getType())) continue;
            opaqueNetworkRefs.add(requiredNetwork);
        }
        Collection<NetworkSelectorPortgroupData> standardNetworks = this.retrieveStandardNetworkProperties(standardNetworkRefs.toArray(new ManagedObjectReference[standardNetworkRefs.size()]));
        Collection<NetworkSelectorPortgroupData> opaqueNetworks = this.retrieveOpaqueNetworkProperties(opaqueNetworkRefs.toArray(new ManagedObjectReference[opaqueNetworkRefs.size()]), filterSpec.includeOpaqueNetworkTypes);
        ManagedObjectReference[] portGroupRefs = this.getPortGroupRefs(filterSpec, distributedPortGroupsSet, uplinkPortGroupsSet);
        Collection<NetworkSelectorPortgroupData> distributedPortGroups = this.retrieveDistributedPortGroupProperties(portGroupRefs, distributedPortGroupsSet, uplinkPortGroupsSet, false);
        ArrayList<NetworkSelectorPortgroupData> unsortedNetworks = new ArrayList<NetworkSelectorPortgroupData>(standardNetworks.size() + opaqueNetworks.size() + distributedPortGroups.size());
        unsortedNetworks.addAll(standardNetworks);
        unsortedNetworks.addAll(opaqueNetworks);
        unsortedNetworks.addAll(distributedPortGroups);
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            _logger.debug((Object)String.format("additional property retrieval - %.3fs.", durationS));
        }
        return unsortedNetworks;
    }

    private final void populateSourceNetworkData(ManagedObjectReference[] vmRefs, Map<String, ManagedObjectReference> networksByPortgroupKey, List<Object> sourceNetworks) throws Exception {
        CompositeConstraint sourceNetworksConstraint = new CompositeConstraint();
        sourceNetworksConstraint.conjoiner = Conjoiner.OR;
        sourceNetworksConstraint.targetType = ANY_NETWORK_TYPE;
        sourceNetworksConstraint.nestedConstraints = new Constraint[vmRefs.length];
        for (int i = 0; i < vmRefs.length; ++i) {
            Constraint networkRelation;
            ManagedObjectReference vmRef = vmRefs[i];
            sourceNetworksConstraint.nestedConstraints[i] = networkRelation = QueryUtil.createConstraintForRelationship((Object)vmRef, (String)VM_NETWORK_RELATION, (String)ANY_NETWORK_TYPE);
        }
        QuerySpec sourceNetworksQuerySpec = QueryUtil.buildQuerySpec((Constraint)sourceNetworksConstraint, (String[])new String[]{DVPG_KEY_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)sourceNetworksQuerySpec);
        for (ResultItem sourceNetworkItem : resultSet.items) {
            sourceNetworks.add(sourceNetworkItem.resourceObject);
            if (!(sourceNetworkItem.resourceObject instanceof ManagedObjectReference)) continue;
            ManagedObjectReference mor = (ManagedObjectReference)sourceNetworkItem.resourceObject;
            if (DistributedVirtualPortgroup.class.getSimpleName().equals(mor.getType())) {
                String portgroupKey = null;
                for (PropertyValue pv : sourceNetworkItem.properties) {
                    if (!DVPG_KEY_PROPERTY.equals(pv.propertyName)) continue;
                    portgroupKey = (String)pv.value;
                    break;
                }
                networksByPortgroupKey.put(portgroupKey, mor);
                continue;
            }
            if (!OpaqueNetwork.class.getSimpleName().equals(mor.getType())) continue;
            String opaqueNetworkId = null;
            String opaqueNetworkType = null;
            for (PropertyValue pv : sourceNetworkItem.properties) {
                if (OPAQUE_NETWORK_ID_PROPERTY.equals(pv.propertyName)) {
                    opaqueNetworkId = (String)pv.value;
                    continue;
                }
                if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(pv.propertyName)) continue;
                opaqueNetworkType = (String)pv.value;
            }
            networksByPortgroupKey.put(NetworkSelectorUtil.getOpaqueNetworkKey(opaqueNetworkId, opaqueNetworkType), mor);
        }
    }

    private final List<NetworkAdapterNetworkMatch> getAdaptersDataForVms(ManagedObjectReference[] vmRefs, Map<String, ManagedObjectReference> networksByPortgroupKey) throws Exception {
        QuerySpec sourceAdaptersQuerySpec = QueryUtil.buildQuerySpec((Object[])vmRefs, (String[])new String[]{VM_DEVICES_PROPERTY});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)sourceAdaptersQuerySpec);
        ArrayList<NetworkAdapterNetworkMatch> matches = new ArrayList<NetworkAdapterNetworkMatch>();
        for (ResultItem vmItem : resultSet.items) {
            VirtualDevice[] virtualDevices;
            if (ArrayUtil.isNullOrEmpty((Object[])vmItem.properties) || vmItem.properties[0] == null || !(vmItem.properties[0].value instanceof VirtualDevice[])) continue;
            for (VirtualDevice vmDevice : virtualDevices = (VirtualDevice[])vmItem.properties[0].value) {
                if (!(vmDevice instanceof VirtualEthernetCard)) continue;
                NetworkAdapterNetworkMatch match = new NetworkAdapterNetworkMatch();
                match.sourceAdapter = (VirtualEthernetCard)vmDevice;
                match.sourceVm = (ManagedObjectReference)vmItem.resourceObject;
                VirtualDevice.BackingInfo backing = vmDevice.backing;
                if (backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                    ManagedObjectReference sourceNetwork;
                    match.sourceNetwork = sourceNetwork = ((VirtualEthernetCard.NetworkBackingInfo)backing).network;
                } else if (backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
                    String opaqueNetKey = NetworkSelectorUtil.getOpaqueNetworkKey((VirtualEthernetCard.OpaqueNetworkBackingInfo)backing);
                    match.sourceNetwork = networksByPortgroupKey.get(opaqueNetKey);
                } else if (backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                    String portgroupKey = ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)backing).port.portgroupKey;
                    match.sourceNetwork = networksByPortgroupKey.get(portgroupKey);
                }
                matches.add(match);
            }
        }
        return matches;
    }

    private final void populateDestinationNetworkData(Map<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource, List<NetworkAdapterNetworkMatch> matches) throws Exception {
        ArrayList<ManagedObjectReference> destinationNetworksList = new ArrayList<ManagedObjectReference>(destinationNetworkBySource.values());
        destinationNetworksList.removeAll(Collections.singleton(null));
        Object[] destinationNetworks = destinationNetworksList.toArray();
        if (ArrayUtil.isNullOrEmpty((Object[])destinationNetworks)) {
            return;
        }
        PropertyValue[] destinationNetworkProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])destinationNetworks, (String[])new String[]{"name", DVPG_KEY_PROPERTY, DVPG_DVS_UUID_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        String networkName = null;
        String portgroupKey = null;
        String switchUuid = null;
        String opaqueId = null;
        String opaqueType = null;
        ManagedObjectReference destinationNetwork = null;
        HashMap<ManagedObjectReference, String> networkNamesByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> portgroupKeysByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> switchUuidsByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> opaqueIdsByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> opaqueTypesByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        for (PropertyValue propertyValue : destinationNetworkProperties) {
            if (propertyValue == null || !(propertyValue.value instanceof String) || !(propertyValue.resourceObject instanceof ManagedObjectReference)) {
                _logger.debug((Object)"Could not parse data results for some destination network.");
                continue;
            }
            destinationNetwork = (ManagedObjectReference)propertyValue.resourceObject;
            if ("name".equals(propertyValue.propertyName)) {
                networkName = (String)propertyValue.value;
                networkNamesByNetworkRef.put(destinationNetwork, networkName);
                continue;
            }
            if (DVPG_KEY_PROPERTY.equals(propertyValue.propertyName)) {
                portgroupKey = (String)propertyValue.value;
                portgroupKeysByNetworkRef.put(destinationNetwork, portgroupKey);
                continue;
            }
            if (DVPG_DVS_UUID_PROPERTY.equals(propertyValue.propertyName)) {
                switchUuid = (String)propertyValue.value;
                switchUuidsByNetworkRef.put(destinationNetwork, switchUuid);
                continue;
            }
            if (OPAQUE_NETWORK_ID_PROPERTY.equals(propertyValue.propertyName)) {
                opaqueId = (String)propertyValue.value;
                opaqueIdsByNetworkRef.put(destinationNetwork, opaqueId);
                continue;
            }
            if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(propertyValue.propertyName)) continue;
            opaqueType = (String)propertyValue.value;
            opaqueTypesByNetworkRef.put(destinationNetwork, opaqueType);
        }
        for (NetworkAdapterNetworkMatch match : matches) {
            match.destinationNetwork = destinationNetworkBySource.get(match.sourceNetwork);
            match.destinationNetworkName = (String)networkNamesByNetworkRef.get(match.destinationNetwork);
            match.destinationPortgroupKey = (String)portgroupKeysByNetworkRef.get(match.destinationNetwork);
            match.destinationSwitchUuid = (String)switchUuidsByNetworkRef.get(match.destinationNetwork);
            match.destinationOpaqueId = (String)opaqueIdsByNetworkRef.get(match.destinationNetwork);
            match.destinationOpaqueType = (String)opaqueTypesByNetworkRef.get(match.destinationNetwork);
        }
    }

    private NetworkSelectorNetworkMatch[] getDestinationNetworksByContextInternal(ManagedObjectReference destination, Object[] sources) throws Exception {
        NetworkSelectorFilterSpec filterSpec = new NetworkSelectorFilterSpec();
        filterSpec.includeStandardNetworks = true;
        filterSpec.includeOpaqueNetworks = true;
        filterSpec.includeDistributedPortGroups = true;
        NetworkSelectorResult destinationData = this.getNetworkSelectorFilteredNetworksInternal(destination, filterSpec);
        NetworkMatchFactory networkMatchFactory = new NetworkMatchFactory(destinationData.networks);
        NetworkSelectorPortgroupData[] sourceData = this.getNetworkSelectorFilteredNetworksByRefs(sources);
        ArrayList<NetworkSelectorNetworkMatch> networkMatches = new ArrayList<NetworkSelectorNetworkMatch>();
        for (NetworkSelectorPortgroupData data2 : sourceData) {
            networkMatches.add(networkMatchFactory.newNetworkMatch(data2));
        }
        return networkMatches.toArray(new NetworkSelectorNetworkMatch[networkMatches.size()]);
    }

    private NetworkSelectorPortgroupData[] getNetworkSelectorFilteredNetworksByRefs(Object[] networkRefs) {
        long startTimeMs = System.currentTimeMillis();
        ManagedObjectReference[] standardNetworkRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, Network.class.getSimpleName());
        ManagedObjectReference[] opaqueNetworkRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, OpaqueNetwork.class.getSimpleName());
        ManagedObjectReference[] distributedPortGroupRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, DistributedVirtualPortgroup.class.getSimpleName());
        Collection<NetworkSelectorPortgroupData> rawStandardNetworks = this.retrieveStandardNetworkProperties(standardNetworkRefs);
        NetworkSelectorPortgroupData[] standardNetworks = rawStandardNetworks.toArray(new NetworkSelectorPortgroupData[rawStandardNetworks.size()]);
        Collection<NetworkSelectorPortgroupData> rawOpaqueNetworks = this.retrieveOpaqueNetworkProperties(opaqueNetworkRefs, false);
        NetworkSelectorPortgroupData[] opaqueNetworks = rawOpaqueNetworks.toArray(new NetworkSelectorPortgroupData[rawOpaqueNetworks.size()]);
        Collection<NetworkSelectorPortgroupData> rawDistributedPortGroups = this.retrieveDistributedPortGroupProperties(distributedPortGroupRefs, null, null, true);
        NetworkSelectorPortgroupData[] distributedPortGroups = rawDistributedPortGroups.toArray(new NetworkSelectorPortgroupData[rawDistributedPortGroups.size()]);
        NetworkSelectorPortgroupData[] result = new NetworkSelectorPortgroupData[standardNetworks.length + opaqueNetworks.length + distributedPortGroups.length];
        System.arraycopy(standardNetworks, 0, result, 0, standardNetworks.length);
        System.arraycopy(opaqueNetworks, 0, result, standardNetworks.length, opaqueNetworks.length);
        System.arraycopy(distributedPortGroups, 0, result, standardNetworks.length + opaqueNetworks.length, distributedPortGroups.length);
        if (_logger.isDebugEnabled()) {
            long stopTimeMs = System.currentTimeMillis();
            long durationMs = stopTimeMs - startTimeMs;
            double durationS = (double)durationMs / 1000.0;
            _logger.debug((Object)String.format("Retrieved in %.3fs (networks %d)", durationS, result.length));
        }
        return result;
    }

    private Object[] getRelatedNetworksByRefs(Object target, Object[] networkRefs, boolean includeInaccessibleNetworks) {
        return this.getRelatedNetworksByRefs(target, networkRefs, null, null, includeInaccessibleNetworks, false);
    }

    private Object[] getRelatedNetworksByRefs(Object target, Object[] networkRefs, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, boolean includeInaccessibleNetworks, boolean createPortgroupTypeQuerySpec) {
        ArrayList<Object> resultNetworkRefs = new ArrayList<Object>();
        Constraint allNetworksConstraint = NetworkSelectorUtil.createConstraintForAllNetworks(target);
        Constraint searchedNetworksConstraint = NetworkSelectorUtil.createConstraintForNetworks(networkRefs);
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{allNetworksConstraint, searchedNetworksConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = createPortgroupTypeQuerySpec ? NetworkSelectorUtil.createPortgroupTypeQuerySpec((Constraint)compositeConstraint) : NetworkSelectorUtil.createEmptyQuerySpecForConstraint((Constraint)compositeConstraint);
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception e) {
            _logger.error((Object)("Data retrieval of network references failed: " + e.getMessage()));
        }
        HashSet<ManagedObjectReference> networkSet = new HashSet<ManagedObjectReference>();
        if (resultSet != null && resultSet.items != null) {
            if (createPortgroupTypeQuerySpec) {
                ArrayList<ManagedObjectReference> networks = new ArrayList<ManagedObjectReference>();
                if (!ArrayUtil.isNullOrEmpty((Object[])networkRefs)) {
                    Object[] objectArray = networkRefs;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object networkRef = objectArray[i];
                        if (!(networkRef instanceof ManagedObjectReference)) continue;
                        networks.add((ManagedObjectReference)networkRef);
                    }
                }
                this.populatePortGroupSets(distributedPortGroupsSet, uplinkPortGroupsSet, networks, resultSet.items);
            }
            for (ResultItem resultItem : resultSet.items) {
                if (!(resultItem.resourceObject instanceof ManagedObjectReference)) continue;
                resultNetworkRefs.add(resultItem.resourceObject);
                networkSet.add((ManagedObjectReference)resultItem.resourceObject);
            }
        }
        if (includeInaccessibleNetworks && !ArrayUtil.isNullOrEmpty((Object[])networkRefs)) {
            for (Object networkRef : networkRefs) {
                if (!(networkRef instanceof ManagedObjectReference) || networkSet.contains(networkRef)) continue;
                resultNetworkRefs.add(networkRef);
            }
        }
        return resultNetworkRefs.toArray(new Object[resultNetworkRefs.size()]);
    }

    private ManagedObjectReference[] getPortGroupRefs(NetworkSelectorFilterSpec filterSpec, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet) {
        LinkedList<ManagedObjectReference> portGroupRefs = new LinkedList<ManagedObjectReference>();
        if (filterSpec.includeDistributedPortGroups) {
            portGroupRefs.addAll(distributedPortGroupsSet);
        }
        if (filterSpec.includeUplinkPortGroups) {
            portGroupRefs.addAll(uplinkPortGroupsSet);
        }
        return portGroupRefs.toArray(new ManagedObjectReference[portGroupRefs.size()]);
    }

    private QuerySpec buildQuerySpecForNetworks(Object target, NetworkSelectorFilterSpec filterSpec) {
        Constraint identifyingConstraint = this.buildNetworkIdentificationConstraint(target, filterSpec);
        Constraint filteringConstraint = null;
        if (filterSpec.filterText != null && filterSpec.filteredFields != null) {
            filteringConstraint = this.buildTextFilterConstraint(filterSpec);
        } else if (!ArrayUtil.isNullOrEmpty((Object[])filterSpec.fieldFilterSpecs)) {
            filteringConstraint = this.buildFieldFilterConstraint(filterSpec.fieldFilterSpecs);
        }
        Constraint finalConstraint = filteringConstraint != null ? QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{identifyingConstraint, filteringConstraint}, (Conjoiner)Conjoiner.AND) : identifyingConstraint;
        QuerySpec networksQuerySpec = NetworkSelectorUtil.createPortgroupTypeQuerySpec(finalConstraint);
        networksQuerySpec.resultSpec = this.buildResultSpec(filterSpec);
        return networksQuerySpec;
    }

    private Constraint buildNetworkIdentificationConstraint(Object target, NetworkSelectorFilterSpec filterSpec) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        if (filterSpec.includeStandardNetworks) {
            Constraint standardNetworksConstraint = NetworkSelectorUtil.createConstraintForStandardNetworks(target);
            constraints.add(standardNetworksConstraint);
        }
        if (filterSpec.includeOpaqueNetworks) {
            Constraint opaqueNetworksConstraint = NetworkSelectorUtil.createConstraintForOpaqueNetworks(target);
            constraints.add(opaqueNetworksConstraint);
        }
        if (filterSpec.includeDistributedPortGroups && filterSpec.includeUplinkPortGroups) {
            Constraint portGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target);
            constraints.add(portGroupsConstraint);
        } else {
            if (filterSpec.includeDistributedPortGroups) {
                Constraint nonUplinkPortGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target, false);
                constraints.add(nonUplinkPortGroupsConstraint);
            }
            if (filterSpec.includeUplinkPortGroups) {
                Constraint uplinkPortGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target, true);
                constraints.add(uplinkPortGroupsConstraint);
            }
        }
        Constraint compositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])constraints.toArray(new Constraint[constraints.size()]), (Conjoiner)Conjoiner.OR);
        return compositeConstraint;
    }

    private Constraint buildTextFilterConstraint(NetworkSelectorFilterSpec filterSpec) {
        Constraint[] filterConstraints = new Constraint[filterSpec.filteredFields.length];
        for (int i = 0; i < filterSpec.filteredFields.length; ++i) {
            if ("name".equals(filterSpec.filteredFields[i])) {
                filterConstraints[i] = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)"name", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)filterSpec.filterText);
                continue;
            }
            if (!"dvsName".equals(filterSpec.filteredFields[i])) continue;
            filterConstraints[i] = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"dvsName", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)filterSpec.filterText);
        }
        Constraint combinedFilteringConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])filterConstraints, (Conjoiner)Conjoiner.OR);
        return combinedFilteringConstraint;
    }

    private Constraint buildFieldFilterConstraint(NetworkSelectorFilterSpec.FieldFilterSpec[] fieldFilterSpecs) {
        ArrayList<PropertyConstraint> filterConstraints = new ArrayList<PropertyConstraint>();
        for (NetworkSelectorFilterSpec.FieldFilterSpec fieldFilterSpec : fieldFilterSpecs) {
            if ("name".equals(fieldFilterSpec.filterField)) {
                filterConstraints.add(QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)"name", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)fieldFilterSpec.filterText));
                continue;
            }
            if ("dvsName".equals(fieldFilterSpec.filterField)) {
                filterConstraints.add(QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"dvsName", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)fieldFilterSpec.filterText));
                continue;
            }
            _logger.error((Object)"Unsupported filter field.");
        }
        CompositeConstraint combinedFilteringConstraint = QueryUtil.createCompositeConstraint((Constraint[])filterConstraints.toArray(new Constraint[filterConstraints.size()]), (Conjoiner)Conjoiner.AND);
        return combinedFilteringConstraint;
    }

    private ResultSpec buildResultSpec(NetworkSelectorFilterSpec filterSpec) {
        if (filterSpec.networksCount == null || filterSpec.networksCount == 0) {
            return null;
        }
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = filterSpec.networksCount;
        resultSpec.offset = filterSpec.offset;
        if (filterSpec.order != null) {
            resultSpec.order = new OrderingCriteria();
            resultSpec.order.orderingProperties = filterSpec.order;
        }
        return resultSpec;
    }

    private ResultSet requestNetworks(QuerySpec networksQuerySpec) {
        long startTimeNs = System.nanoTime();
        ResultSet networks = null;
        try {
            networks = QueryUtil.getData((DataService)this._dataService, (QuerySpec)networksQuerySpec);
        }
        catch (Exception e) {
            _logger.error((Object)"Data retrieval of related ntworks failed.", (Throwable)e);
        }
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            int netCount = networks == null || networks.items == null ? 0 : networks.items.length;
            _logger.debug((Object)String.format("requestNetworks() - %.3fs - %d networks.", durationS, netCount));
        }
        return networks;
    }

    private void populatePortGroupSets(Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, ArrayList<ManagedObjectReference> requiredNetworks, ResultItem[] resultItems) {
        boolean checkRequiredNetworks;
        boolean bl = checkRequiredNetworks = !ArrayUtil.isNullOrEmpty(requiredNetworks);
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (ResultItem ri : resultItems) {
                if (!(ri.resourceObject instanceof ManagedObjectReference)) continue;
                ManagedObjectReference mor = (ManagedObjectReference)ri.resourceObject;
                if (checkRequiredNetworks && requiredNetworks.indexOf(mor) == -1 || !ManagedObjectUtil.isOfType((ManagedObjectReference)mor, DistributedVirtualPortgroup.class) || ArrayUtil.isNullOrEmpty((Object[])ri.properties)) continue;
                for (PropertyValue pv : ri.properties) {
                    if (!pv.propertyName.equals("isUplinkPortgroup") || !(pv.value instanceof Boolean)) continue;
                    Boolean isUplink = (Boolean)pv.value;
                    if (!isUplink.booleanValue() && distributedPortGroupsSet != null) {
                        distributedPortGroupsSet.add(mor);
                        continue;
                    }
                    if (!isUplink.booleanValue() || uplinkPortGroupsSet == null) continue;
                    uplinkPortGroupsSet.add(mor);
                }
            }
        }
    }

    private Collection<NetworkSelectorPortgroupData> retrieveDistributedPortGroupProperties(ManagedObjectReference[] portgroups, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, boolean retrieveIsUplinkProperty) {
        if (ArrayUtil.isNullOrEmpty((Object[])portgroups)) {
            return Collections.emptyList();
        }
        HashMap<ManagedObjectReference, NetworkSelectorPortgroupData> portGroupsMap = new HashMap<ManagedObjectReference, NetworkSelectorPortgroupData>();
        PropertyValue[] propertyValues = null;
        try {
            ArrayList<String> properties = new ArrayList<String>();
            properties.add("name");
            properties.add(DVPG_KEY_PROPERTY);
            properties.add(DVPG_DVS_UUID_PROPERTY);
            properties.add("dvsName");
            if (retrieveIsUplinkProperty) {
                properties.add("isUplinkPortgroup");
            }
            String[] propertyNames = properties.toArray(new String[properties.size()]);
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])portgroups, (String[])propertyNames);
        }
        catch (Exception e) {
            _logger.error((Object)"Retrieval of distributed network properties failed.", (Throwable)e);
        }
        this.updatePortGroupsMap(propertyValues, portGroupsMap, distributedPortGroupsSet, uplinkPortGroupsSet);
        return portGroupsMap.values();
    }

    private void updatePortGroupsMap(PropertyValue[] properties, Map<ManagedObjectReference, NetworkSelectorPortgroupData> portGroupsMap, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet) {
        if (!ArrayUtil.isNullOrEmpty((Object[])properties)) {
            for (PropertyValue pv : properties) {
                ManagedObjectReference pgRef = (ManagedObjectReference)pv.resourceObject;
                NetworkSelectorPortgroupData networkData = portGroupsMap.get(pgRef);
                if (networkData == null) {
                    networkData = new NetworkSelectorPortgroupData();
                    networkData.networkRef = pgRef;
                    portGroupsMap.put(pgRef, networkData);
                }
                if (distributedPortGroupsSet != null && distributedPortGroupsSet.contains(pgRef)) {
                    networkData.isUplink = false;
                } else if (uplinkPortGroupsSet != null && uplinkPortGroupsSet.contains(pgRef)) {
                    networkData.isUplink = true;
                }
                if (pv.propertyName.equals("name") && pv.value instanceof String) {
                    networkData.name = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals("dvsName") && pv.value instanceof String) {
                    networkData.dvsName = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(DVPG_KEY_PROPERTY) && pv.value instanceof String) {
                    networkData.portgroupKey = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(DVPG_DVS_UUID_PROPERTY) && pv.value instanceof String) {
                    networkData.dvsUuid = (String)pv.value;
                    continue;
                }
                if (!pv.propertyName.equals("isUplinkPortgroup") || !(pv.value instanceof Boolean)) continue;
                networkData.isUplink = (Boolean)pv.value;
            }
        }
    }

    private Collection<NetworkSelectorPortgroupData> retrieveStandardNetworkProperties(ManagedObjectReference[] networks) {
        if (ArrayUtil.isNullOrEmpty((Object[])networks)) {
            return Collections.emptyList();
        }
        PropertyValue[] propertyValues = null;
        try {
            String[] properties = new String[]{"name"};
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])networks, (String[])properties);
        }
        catch (Exception e) {
            _logger.error((Object)"Retrieval of standard network properties failed.", (Throwable)e);
        }
        HashMap<String, NetworkSelectorPortgroupData> standardNetworksData = new HashMap<String, NetworkSelectorPortgroupData>();
        if (!ArrayUtil.isNullOrEmpty(propertyValues)) {
            for (PropertyValue pv : propertyValues) {
                if (pv.resourceObject == null || !(pv.resourceObject instanceof ManagedObjectReference)) continue;
                NetworkSelectorPortgroupData networkData = (NetworkSelectorPortgroupData)standardNetworksData.get(pv.resourceObject.toString());
                if (networkData == null) {
                    networkData = new NetworkSelectorPortgroupData();
                    networkData.networkRef = (ManagedObjectReference)pv.resourceObject;
                    networkData.isStandardNetwork = true;
                    standardNetworksData.put(pv.resourceObject.toString(), networkData);
                }
                if (!"name".equals(pv.propertyName) || !(pv.value instanceof String)) continue;
                networkData.name = (String)pv.value;
            }
        }
        return standardNetworksData.values();
    }

    private Collection<NetworkSelectorPortgroupData> retrieveOpaqueNetworkProperties(ManagedObjectReference[] opaqueNetworks, boolean includeOpaqueNetworkTypes) {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks)) {
            return Collections.emptyList();
        }
        Object[] propertyValues = null;
        try {
            String[] stringArray;
            if (includeOpaqueNetworkTypes) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "name";
                stringArray = stringArray2;
                stringArray2[1] = OPAQUE_NETWORK_TYPE_PROPERTY;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "name";
            }
            String[] properties = stringArray;
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])opaqueNetworks, (String[])properties);
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of opaque network properties failed:" + e.getLocalizedMessage()));
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return Collections.emptyList();
        }
        HashMap<String, NetworkSelectorPortgroupData> opaqueNetworksData = new HashMap<String, NetworkSelectorPortgroupData>();
        for (Object pv : propertyValues) {
            if (((PropertyValue)pv).resourceObject == null || !(((PropertyValue)pv).resourceObject instanceof ManagedObjectReference)) continue;
            NetworkSelectorPortgroupData networkData = (NetworkSelectorPortgroupData)opaqueNetworksData.get(((PropertyValue)pv).resourceObject.toString());
            if (networkData == null) {
                networkData = new NetworkSelectorPortgroupData();
                networkData.networkRef = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                networkData.isOpaqueNetwork = true;
                opaqueNetworksData.put(((PropertyValue)pv).resourceObject.toString(), networkData);
            }
            if ("name".equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof String) {
                networkData.name = (String)((PropertyValue)pv).value;
                continue;
            }
            if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(((PropertyValue)pv).propertyName) || !(((PropertyValue)pv).value instanceof String)) continue;
            networkData.opaqueNetworkType = (String)((PropertyValue)pv).value;
            if (!NSX_NETWORK_TYPE_PROPERTY_VALUE.equals(networkData.opaqueNetworkType)) continue;
            networkData.isNsxNetwork = true;
        }
        return opaqueNetworksData.values();
    }

    private static class NetworkMatchFactory {
        private final HashMap<String, List<ManagedObjectReference>> networksByName = new HashMap();

        public NetworkMatchFactory(NetworkSelectorPortgroupData[] networks) {
            this.initializeNetworksMap(networks);
        }

        private void initializeNetworksMap(NetworkSelectorPortgroupData[] networks) {
            if (!ArrayUtil.isNullOrEmpty((Object[])networks)) {
                for (NetworkSelectorPortgroupData network : networks) {
                    List<ManagedObjectReference> networkMorefs = this.networksByName.get(network.name);
                    if (networkMorefs == null) {
                        networkMorefs = new ArrayList<ManagedObjectReference>();
                        this.networksByName.put(network.name, networkMorefs);
                    }
                    networkMorefs.add(network.networkRef);
                }
            }
        }

        public NetworkSelectorNetworkMatch newNetworkMatch(NetworkSelectorPortgroupData networkData) {
            List<ManagedObjectReference> destinationNetworks = this.networksByName.get(networkData.name);
            if (destinationNetworks == null) {
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkData.networkRef, Network.class)) {
                    return new NetworkSelectorNetworkMatch(networkData.networkRef, networkData.networkRef);
                }
                if (this.networksByName.size() == 1 && this.networksByName.values().iterator().next().size() == 1) {
                    return new NetworkSelectorNetworkMatch(networkData.networkRef, this.networksByName.values().iterator().next().get(0));
                }
                return new NetworkSelectorNetworkMatch(networkData.networkRef, null);
            }
            ManagedObjectReference destinationNetworkMoref = null;
            for (ManagedObjectReference mor : destinationNetworks) {
                if (!mor.equals((Object)networkData.networkRef)) continue;
                destinationNetworkMoref = mor;
                break;
            }
            if (destinationNetworkMoref != null) {
                return new NetworkSelectorNetworkMatch(networkData.networkRef, destinationNetworkMoref);
            }
            return new NetworkSelectorNetworkMatch(networkData.networkRef, destinationNetworks.get(0));
        }
    }
}

