/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PrivilegesPropertyProvider
implements PropertyProviderAdapter {
    private static final String GRANTED_PRIVILEGES = "grantedPrivileges";
    private static final String VC_PRIVILEGES_PROPERTY = "vcGrantedPrivileges";
    private final QueryService _queryService;

    public PrivilegesPropertyProvider(QueryServiceFactory queryServiceFactory, DataServiceExtensionRegistry registry) {
        this._queryService = queryServiceFactory.getQueryService();
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{VC_PRIVILEGES_PROPERTY};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        ResultSet resultSet = new ResultSet();
        ResultItem[] resultItems = new ResultItem[objects.length];
        List<String[]> vcPrivileges = this.getPrivileges(objects);
        for (int i = 0; i < objects.length; ++i) {
            resultItems[i] = this.newPrivilegesResultItem(objects[i], vcPrivileges.get(i));
        }
        resultSet.items = resultItems;
        return resultSet;
    }

    private ResultItem newPrivilegesResultItem(Object vm, String[] vcPrivileges) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vm;
        PropertyValue propValue = this.createPropValue(VC_PRIVILEGES_PROPERTY, vcPrivileges, vm);
        resultItem.properties = new PropertyValue[]{propValue};
        return resultItem;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private List<String[]> getPrivileges(Object[] vms) {
        ManagedObjectReference vcRef;
        ArrayList<String[]> result = new ArrayList<String[]>(vms.length);
        HashMap<ManagedObjectReference, ManagedObjectReference> vmVcs = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        HashSet<ManagedObjectReference> vcRefs = new HashSet<ManagedObjectReference>();
        for (Object vm : vms) {
            ManagedObjectReference vmRef = (ManagedObjectReference)vm;
            vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
            vmVcs.put(vmRef, vcRef);
            vcRefs.add(vcRef);
        }
        Map vcsPrivileges = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vcRefs, (String[])new String[]{GRANTED_PRIVILEGES});
        for (Object vm : vms) {
            vcRef = (ManagedObjectReference)vmVcs.get((ManagedObjectReference)vm);
            String[] vmVcPrivileges = (String[])((Map)vcsPrivileges.get(vcRef)).get(GRANTED_PRIVILEGES);
            result.add(vmVcPrivileges);
        }
        return result;
    }
}

