/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileToIofilterMap;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupAssignmentInfo;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupInfo;
import com.vmware.vsphere.client.common.spbm.data.VirtualDiskStorageProfileAssignmentData;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.spbm.data.ManageVmStorageProfilesDatastoreData;
import com.vmware.vsphere.client.h5.spbm.data.ManageVmStorageProfilesVmData;
import com.vmware.vsphere.client.h5.spbm.data.VmComplianceSummaryData;
import com.vmware.vsphere.client.h5.spbm.data.VmSpbmEnabledData;
import com.vmware.vsphere.client.h5.spbm.data.VmStorageProfileComponentsData;
import com.vmware.vsphere.client.h5.spbm.data.VmStorageProfiles;
import com.vmware.vsphere.client.h5.spbm.data.VmStorageProfilesData;
import com.vmware.vsphere.client.h5.spbm.data.datastore.DatastoreCapabilityProfilesCapacityData;
import com.vmware.vsphere.client.h5.spbm.data.datastore.DatastoreResourceProfilesData;
import com.vmware.vsphere.client.h5.spbm.data.wizard.SpbmVcData;
import com.vmware.vsphere.client.h5.spbm.util.ComplianceFailureFormatter;
import com.vmware.vsphere.client.h5.spbm.util.SpbmPrivilegeUtil;
import com.vmware.vsphere.client.h5.spbm.util.SpbmStringUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.CapacityPerCapabilityProfileData;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.ProfileComplianceResultData;
import com.vmware.vsphere.client.spbm.data.VmRollupComplianceSummayData;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.ReplicationGroupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmPropertyProvider {
    private static final String PROPERTY_VM_STORAGE_PROFILE_ASSIGNMENTS = "vmStorageProfileAssignments";
    private static final String PROPERTY_VM_RG_ASSIGNMENTS = "vmReplicationGroupAssignments";
    private static final String PROPERTY_PROFILE_TO_IOFILTER_MAP = "profileToIofilterMap";
    private static final String PROPERTY_VM_ROLLUP_COMPLIANCE_SUMMARY = "vmRollupComplianceSummay";
    private static final String VM_REPLICATION_GROUP_ASSIGNMENTS = "vmReplicationGroupAssignments";
    private static final String PROPERTY_VM_HARDWARE_DEVICE = "config.hardware.device";
    private static final String STORAGE_PROFILE_VIEW_PRIVILEGE = "StorageProfile.View";
    private static final String STORAGE_PROFILE_UPDATE_PRIVILEGE = "StorageProfile.Update";
    private static final String PROPERTY_CAPABILITY_PROFILE_CAPACITY_STAT = "capacityPerCapabilityProfileStats";
    private static final String NAMESPACE_CAPABILITY_METADATA = "namespaceCapabilityMetadata";
    private static final String DS_CAPABILITY_PROFILES = "capabilityProfiles";
    private static final String DS_DEFAULT_RESOURCE_PROFILES = "defaultProfiles";
    private static final String OUT_OF_DATE_STATUS = "outOfDate";
    private static final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private static final Log _logger = LogFactory.getLog(SpbmPropertyProvider.class);
    private final QueryService _queryService;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private final PbmServiceFactory _pbmServiceFactory;
    private final QueryBindingService _queryBindingService;
    private final ThreadPoolExecutor _threadPoolExecutor;

    public SpbmPropertyProvider(QueryServiceFactory queryServiceFactory, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, PbmServiceFactory pbmServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, ThreadPoolExecutor threadPoolExecutor) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._pbmServiceFactory = pbmServiceFactory;
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @PropertyProvider(value="VirtualMachine/storagePoliciesData")
    public VmStorageProfiles getStoragePoliciesData(ManagedObjectReference vmRef) throws Exception {
        VmStorageProfiles profilesData = new VmStorageProfiles();
        ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
        profilesData.hasSpbmViewPrivilege = this.hasPrivileges(vcRef, STORAGE_PROFILE_VIEW_PRIVILEGE);
        if (profilesData.hasSpbmViewPrivilege.booleanValue()) {
            profilesData.profilesDataList = this.getProfilesData(vmRef);
        }
        return profilesData;
    }

    @PropertyProvider(value="VirtualMachine/storagePolicyComponentsData")
    public VmStorageProfileComponentsData[] getStoragePolicyComponentsData(ManagedObjectReference vmRef) throws Exception {
        List<VmStorageProfileComponentsData> componentsData = this.getProfileComponentsData(vmRef);
        return componentsData.toArray(new VmStorageProfileComponentsData[componentsData.size()]);
    }

    private List<VmStorageProfileComponentsData> getProfileComponentsData(ManagedObjectReference vmRef) {
        ArrayList<VmStorageProfileComponentsData> profileComponentsData = new ArrayList<VmStorageProfileComponentsData>();
        ManageVmStorageProfilesVmData manageVmStorageProfilesVmData = (ManageVmStorageProfilesVmData)((Object)this._queryBindingService.prepare(ManageVmStorageProfilesVmData.class).fetch((Object)vmRef));
        if (manageVmStorageProfilesVmData.profileAssignmentsData == null) {
            throw new IllegalStateException(String.format("No profile assignments could be fetched for VM %s.", vmRef));
        }
        profileComponentsData.add(this.getVmHomeComponentsData(manageVmStorageProfilesVmData));
        profileComponentsData.addAll(this.getVmDisksComponentsData(manageVmStorageProfilesVmData));
        return profileComponentsData;
    }

    @PropertyProvider(value="VirtualMachine/spbmEnabled")
    public Collection<Boolean> getSpbmEnabled(Collection<ManagedObjectReference> vmRefs) {
        if (vmRefs.isEmpty()) {
            return Collections.emptyList();
        }
        Collection vmSpbmEnabledDataResultSet = this._queryBindingService.prepare(VmSpbmEnabledData.class).fetch(vmRefs);
        if (vmSpbmEnabledDataResultSet == null) {
            _logger.error((Object)"No compute vm spbm enabled data data could be fetched.");
            return Collections.nCopies(vmRefs.size(), false);
        }
        HashMap<ManagedObjectReference, Boolean> vmSpbmEnabledData = new HashMap<ManagedObjectReference, Boolean>();
        for (VmSpbmEnabledData resultItem : vmSpbmEnabledDataResultSet) {
            if (resultItem == null) continue;
            ManagedObjectReference vmRef = (ManagedObjectReference)resultItem.provider;
            vmSpbmEnabledData.put(vmRef, resultItem.computeResourceSpbmData.spbmEnabled);
        }
        ArrayList<Boolean> resultItems = new ArrayList<Boolean>(vmRefs.size());
        for (ManagedObjectReference vm : vmRefs) {
            resultItems.add((Boolean)vmSpbmEnabledData.get(vm));
        }
        return resultItems;
    }

    @PropertyProvider(value="Folder/profileToIofilterMapSafe")
    public List<ProfileToIofilterMap> getProfileToIofilterMapSafe(Collection<ManagedObjectReference> folderRefs) throws Exception {
        if (folderRefs.isEmpty()) {
            return Collections.emptyList();
        }
        List<ManagedObjectReference> privilegedFolders = this.getPrivilegedManagedObjectsList(folderRefs);
        List<ProfileToIofilterMap> result = this.getProperty(folderRefs, privilegedFolders, PROPERTY_PROFILE_TO_IOFILTER_MAP);
        return result;
    }

    private VmStorageProfileComponentsData getVmHomeComponentsData(ManageVmStorageProfilesVmData manageVmStorageProfilesVmData) {
        VmStorageProfileComponentsData vmHomeData = new VmStorageProfileComponentsData();
        vmHomeData.isVmHome = true;
        vmHomeData.name = SpbmStringUtil.getString("viewVmProfileAssignments.homeProfileLabel");
        vmHomeData.profile = manageVmStorageProfilesVmData.profileAssignmentsData.homeStorageProfile;
        vmHomeData.dsName = SpbmPropertyProvider.getDsNameFromPath(manageVmStorageProfilesVmData.homeDatastorePath);
        vmHomeData.vmHomePath = manageVmStorageProfilesVmData.homeDatastorePath;
        ManageVmStorageProfilesDatastoreData manageVmStorageProfilesDatastoreData = SpbmPropertyProvider.getDsDataByName(vmHomeData.dsName, manageVmStorageProfilesVmData.datastoreData);
        if (manageVmStorageProfilesDatastoreData != null) {
            vmHomeData.dsMor = (ManagedObjectReference)manageVmStorageProfilesDatastoreData.provider;
            vmHomeData.formattedDsType = manageVmStorageProfilesDatastoreData.formattedType;
            vmHomeData.dsType = manageVmStorageProfilesDatastoreData.type;
        }
        vmHomeData.diskId = ((ManagedObjectReference)manageVmStorageProfilesVmData.provider).getValue();
        return vmHomeData;
    }

    private List<VmStorageProfileComponentsData> getVmDisksComponentsData(ManageVmStorageProfilesVmData manageVmStorageProfilesVmData) {
        ArrayList<VmStorageProfileComponentsData> vmDisksDataItems = new ArrayList<VmStorageProfileComponentsData>();
        if (manageVmStorageProfilesVmData.virtualDevices == null) {
            return vmDisksDataItems;
        }
        for (VirtualDevice virtualDevice : manageVmStorageProfilesVmData.virtualDevices) {
            if (!(virtualDevice instanceof VirtualDisk)) continue;
            VmStorageProfileComponentsData diskData = new VmStorageProfileComponentsData();
            VirtualDisk virtualDisk = (VirtualDisk)virtualDevice;
            diskData.name = virtualDisk.deviceInfo.label;
            diskData.virtualDisk = virtualDisk;
            diskData.diskSizeInB = virtualDisk.capacityInBytes;
            if (manageVmStorageProfilesVmData.datastoreData != null) {
                for (ManageVmStorageProfilesDatastoreData datastoreData : manageVmStorageProfilesVmData.datastoreData) {
                    VirtualDevice.FileBackingInfo backing;
                    if (!(virtualDisk.backing instanceof VirtualDevice.FileBackingInfo) || (backing = (VirtualDevice.FileBackingInfo)virtualDisk.backing) == null || !datastoreData.provider.equals(backing.datastore)) continue;
                    diskData.dsMor = (ManagedObjectReference)datastoreData.provider;
                    diskData.dsName = datastoreData.name;
                    diskData.dsType = datastoreData.type;
                    diskData.formattedDsType = datastoreData.formattedType;
                }
            }
            String diskIdToBeFound = String.format("%s:%s", ((ManagedObjectReference)manageVmStorageProfilesVmData.provider).getValue(), virtualDisk.getKey());
            for (VirtualDiskStorageProfileAssignmentData diskAssignment : manageVmStorageProfilesVmData.profileAssignmentsData.diskAssignments) {
                if (!diskIdToBeFound.equals(diskAssignment.diskId)) continue;
                diskData.profile = diskAssignment.profile;
                diskData.diskId = diskAssignment.diskId;
            }
            vmDisksDataItems.add(diskData);
        }
        return vmDisksDataItems;
    }

    private List<ManagedObjectReference> getPrivilegedManagedObjectsList(Collection<ManagedObjectReference> moRefs) {
        ArrayList<ManagedObjectReference> vmList = new ArrayList<ManagedObjectReference>(moRefs);
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (moRefs.isEmpty()) {
            return result;
        }
        List<Boolean> vcPrivileges = SpbmPrivilegeUtil.hasRequiredPrivileges(this._queryService, moRefs, STORAGE_PROFILE_VIEW_PRIVILEGE);
        for (int i = 0; i < moRefs.size(); ++i) {
            if (!vcPrivileges.get(i).booleanValue()) continue;
            result.add((ManagedObjectReference)vmList.get(i));
        }
        return result;
    }

    private <T> List<T> getProperty(Collection<ManagedObjectReference> moRefs, List<ManagedObjectReference> privilegedVms, String propertyToRequest) {
        Map properties = !privilegedVms.isEmpty() ? QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, privilegedVms, (String[])new String[]{propertyToRequest}) : new HashMap();
        ArrayList result = new ArrayList();
        for (ManagedObjectReference moRef : moRefs) {
            if (privilegedVms.contains(moRef)) {
                result.add(((Map)properties.get(moRef)).get(propertyToRequest));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private List<VmStorageProfilesData> getProfilesData(ManagedObjectReference vmRef) {
        ArrayList<VmStorageProfilesData> resultItems = new ArrayList<VmStorageProfilesData>();
        try {
            Map result = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)vmRef, (String[])new String[]{PROPERTY_VM_HARDWARE_DEVICE, PROPERTY_VM_STORAGE_PROFILE_ASSIGNMENTS});
            VmStorageProfileAssignmentsData profileAssignmentsData = (VmStorageProfileAssignmentsData)result.get(PROPERTY_VM_STORAGE_PROFILE_ASSIGNMENTS);
            Profile homeProfile = profileAssignmentsData.homeStorageProfile;
            ComplianceResult homeComplianceResult = profileAssignmentsData.homeComplianceResult;
            Map<String, NamespaceCapabilityMetadata> namespaceMetadata = this.getNamespaceMetadataMap(vmRef.getServerGuid());
            VmStorageProfilesData homeData = new VmStorageProfilesData();
            homeData.name = SpbmStringUtil.getString("viewVmProfileAssignments.homeProfileLabel");
            homeData.type = "vmHome";
            if (homeProfile != null) {
                homeData.storagePolicy = homeProfile.name;
                if (homeComplianceResult != null) {
                    homeData.complianceStatus = homeComplianceResult.mismatch ? OUT_OF_DATE_STATUS : homeComplianceResult.getComplianceStatus();
                    homeData.lastChecked = homeComplianceResult.getCheckTime();
                    homeData.complianceFailures = ComplianceFailureFormatter.getComplianceFailures(homeComplianceResult, namespaceMetadata);
                }
            }
            resultItems.add(homeData);
            VirtualDevice[] virtualDevices = (VirtualDevice[])result.get(PROPERTY_VM_HARDWARE_DEVICE);
            if (virtualDevices != null) {
                for (VirtualDevice virtualDevice : virtualDevices) {
                    if (!(virtualDevice instanceof VirtualDisk)) continue;
                    VirtualDisk virtualDisk = (VirtualDisk)virtualDevice;
                    VmStorageProfilesData virtualDiskData = new VmStorageProfilesData();
                    virtualDiskData.name = virtualDisk.deviceInfo.label;
                    virtualDiskData.type = "vmDisk";
                    for (VirtualDiskStorageProfileAssignmentData profileData : profileAssignmentsData.diskAssignments) {
                        String[] splittedDiskId = profileData.diskId.split(":");
                        if (splittedDiskId.length <= 1 || !splittedDiskId[1].equals(Integer.toString(virtualDisk.key))) continue;
                        virtualDiskData.storagePolicy = profileData.profile.name;
                        virtualDiskData.complianceStatus = profileData.complianceResult.mismatch ? OUT_OF_DATE_STATUS : profileData.complianceResult.getComplianceStatus();
                        virtualDiskData.lastChecked = profileData.complianceResult.getCheckTime();
                        virtualDiskData.complianceFailures = ComplianceFailureFormatter.getComplianceFailures(profileData.complianceResult, namespaceMetadata);
                    }
                    resultItems.add(virtualDiskData);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve profiles data", (Throwable)e);
        }
        return resultItems;
    }

    @PropertyProvider(value="VirtualMachine/vmComplianceSummary")
    public VmComplianceSummaryData getVmComplianceSummary(ManagedObjectReference vmRef) throws Exception {
        ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
        if (this.hasPrivileges(vcRef, STORAGE_PROFILE_VIEW_PRIVILEGE)) {
            Map properties = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)vmRef, (String[])new String[]{PROPERTY_VM_ROLLUP_COMPLIANCE_SUMMARY, "vmReplicationGroupAssignments"});
            return this.populateComplianceSummaryInfo((VmRollupComplianceSummayData)properties.get(PROPERTY_VM_ROLLUP_COMPLIANCE_SUMMARY), (List)properties.get("vmReplicationGroupAssignments"));
        }
        VmComplianceSummaryData vmComplianceSummaryData = new VmComplianceSummaryData();
        vmComplianceSummaryData.hasSpbmViewPrivilege = false;
        return vmComplianceSummaryData;
    }

    @PropertyProvider(value="VirtualMachine/areVmProfilesOutdated")
    public Boolean getAreVmProfilesOutdated(ManagedObjectReference vmRef) throws Exception {
        Object[] vmComplianceResults = this.getVmComplianceResults(vmRef);
        if (ArrayUtils.isEmpty((Object[])vmComplianceResults)) {
            return false;
        }
        for (Object complianceResult : vmComplianceResults) {
            if (complianceResult != null && (((ComplianceResult)complianceResult).mismatch || ComplianceResult.ComplianceStatus.outOfDate.name().equals(((ComplianceResult)complianceResult).complianceStatus))) continue;
            return false;
        }
        return true;
    }

    @PropertyProvider(value="Datastore/datastoreCapabilityProfilesCapacity")
    public DatastoreCapabilityProfilesCapacityData getDatastoreCapabilityProfilesCapacity(ManagedObjectReference dsRef) throws Exception {
        DatastoreCapabilityProfilesCapacityData result = new DatastoreCapabilityProfilesCapacityData();
        ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)dsRef.getServerGuid());
        result.hasViewPrivilege = this.hasPrivileges(vcRef, STORAGE_PROFILE_VIEW_PRIVILEGE);
        if (result.hasViewPrivilege) {
            result.profilesData = (CapacityPerCapabilityProfileData[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String)PROPERTY_CAPABILITY_PROFILE_CAPACITY_STAT);
        }
        return result;
    }

    @PropertyProvider(value="Datastore/datastoreCapabilityProfilesData")
    public DatastoreResourceProfilesData getDatastoreCapabilityProfilesData(ManagedObjectReference dsRef) throws Exception {
        return this.getResourceProfilesInternal(dsRef, DS_CAPABILITY_PROFILES);
    }

    @PropertyProvider(value="Datastore/datastoreDefaultProfilesData")
    public DatastoreResourceProfilesData getDatastoreDefaultProfilesData(ManagedObjectReference dsRef) throws Exception {
        return this.getResourceProfilesInternal(dsRef, DS_DEFAULT_RESOURCE_PROFILES);
    }

    private DatastoreResourceProfilesData getResourceProfilesInternal(ManagedObjectReference dsRef, String resourceProfilesProperty) {
        DatastoreResourceProfilesData result = new DatastoreResourceProfilesData();
        ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)dsRef.getServerGuid());
        result.hasViewPrivilege = this.hasPrivileges(vcRef, STORAGE_PROFILE_VIEW_PRIVILEGE);
        if (result.hasViewPrivilege) {
            Map dsProps = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String[])new String[]{resourceProfilesProperty, NAMESPACE_CAPABILITY_METADATA});
            result.profiles = (Profile[])dsProps.get(resourceProfilesProperty);
            result.namespaceCapabilityMetadata = (NamespaceCapabilityMetadata[])dsProps.get(NAMESPACE_CAPABILITY_METADATA);
        }
        return result;
    }

    @PropertyProvider(value="Folder/spbmProfileProvisioningVcData")
    public SpbmVcData getSpbmProfileProvisioningVcData(final ManagedObjectReference vcRootFolder) throws Exception {
        final SpbmVcData spbmVcData = new SpbmVcData();
        spbmVcData.hasViewAndUpdatePrivileges = this.hasPrivileges(vcRootFolder, STORAGE_PROFILE_UPDATE_PRIVILEGE, STORAGE_PROFILE_VIEW_PRIVILEGE);
        if (spbmVcData.hasViewAndUpdatePrivileges) {
            try {
                final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
                ArrayList<Callable<Void>> requests = new ArrayList<Callable<Void>>();
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        spbmVcData.namespaceMetadata = SpbmPropertyProvider.this.retrieveNamespaceMetadata(vcRootFolder.getServerGuid());
                        return null;
                    }
                });
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        spbmVcData.profileNames = SpbmPropertyProvider.this.requestProfileNames(vcRootFolder, "PbmRequirementStorageProfile");
                        return null;
                    }
                });
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        spbmVcData.dataServiceProfiles = SpbmPropertyProvider.this.requestProfileContent(vcRootFolder, "PbmDataServiceStorageProfile");
                        if (spbmVcData.dataServiceProfiles != null) {
                            spbmVcData.dataServiceNames = new String[spbmVcData.dataServiceProfiles.length];
                            for (int i = 0; i < spbmVcData.dataServiceProfiles.length; ++i) {
                                spbmVcData.dataServiceNames[i] = spbmVcData.dataServiceProfiles[i].name;
                            }
                        }
                        return null;
                    }
                });
                List responses = this._threadPoolExecutor.invokeAll(requests);
                for (Future response : responses) {
                    response.get();
                }
                PbmService pbmService = PbmSessionUtil.getService((String)vcRootFolder.getServerGuid(), (PbmServiceFactory)this._pbmServiceFactory);
                spbmVcData.spbmSupportedFeatures = pbmService.getSupportedFeatures();
            }
            catch (ExecutionException ex) {
                spbmVcData.vcErrorMessage = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            }
            catch (Exception ex) {
                spbmVcData.vcErrorMessage = ex.getMessage();
            }
        }
        return spbmVcData;
    }

    private String[] requestProfileNames(ManagedObjectReference vcRef, String profileType) {
        String forwardRelation = "pbmProfiles/@deprecatedInverse";
        ResultSet resultSet = this._queryService.select(new String[]{"name"}).from(new String[]{profileType}).where(forwardRelation, PropertyPredicate.ComparisonOperator.EQUAL, (Object)vcRef).fetch();
        ArrayList<String> profileNames = new ArrayList<String>();
        if (resultSet != null && resultSet.getItems() != null) {
            for (ResourceItem item : resultSet.getItems()) {
                profileNames.add((String)item.get("name"));
            }
        }
        return profileNames.toArray(new String[profileNames.size()]);
    }

    private Profile[] requestProfileContent(ManagedObjectReference vcRef, String profileType) {
        String forwardRelation = "pbmProfiles/@deprecatedInverse";
        ResultSet resultSet = this._queryService.select(new String[]{"profileContent"}).from(new String[]{profileType}).where(forwardRelation, PropertyPredicate.ComparisonOperator.EQUAL, (Object)vcRef).fetch();
        ArrayList<Profile> profileContent = new ArrayList<Profile>();
        if (resultSet != null && resultSet.getItems() != null) {
            for (ResourceItem item : resultSet.getItems()) {
                profileContent.add((Profile)item.get("profileContent"));
            }
        }
        return profileContent.toArray(new Profile[profileContent.size()]);
    }

    private boolean hasPrivileges(ManagedObjectReference entity, String ... privileges) {
        String[] grantedPrivileges = (String[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)entity, (String)"grantedPrivileges");
        return AuthorizationUtil.isPrivilegeGranted((String[])privileges, (String[])grantedPrivileges);
    }

    private ComplianceResult[] getVmComplianceResults(ManagedObjectReference vmRef) throws Exception {
        String vcServiceGuid = vmRef.getServerGuid();
        PbmService pbmService = PbmSessionUtil.getService((String)vcServiceGuid, (PbmServiceFactory)this._pbmServiceFactory);
        Object[] summaryComplianceResult = PbmUtil.getRollupComplianceResult((PbmService)pbmService, (ManagedObjectReference[])new ManagedObjectReference[]{vmRef});
        if (ArrayUtils.isNotEmpty((Object[])summaryComplianceResult) && ((RollupComplianceResult)summaryComplianceResult[0]).result != null) {
            return ((RollupComplianceResult)summaryComplianceResult[0]).result;
        }
        return new ComplianceResult[0];
    }

    private VmComplianceSummaryData populateComplianceSummaryInfo(VmRollupComplianceSummayData vmRollupComplianceSummayData, List<ReplicationGroupAssignmentInfo> replicationGroupAssignments) {
        VmComplianceSummaryData vmComplianceSummaryData = new VmComplianceSummaryData();
        vmComplianceSummaryData.hasSpbmViewPrivilege = true;
        if (vmRollupComplianceSummayData != null) {
            HashSet<String> storagePolicyNames = new HashSet<String>();
            if (vmRollupComplianceSummayData.entityComplianceResults != null) {
                for (ProfileComplianceResultData complianceResultData : vmRollupComplianceSummayData.entityComplianceResults) {
                    if (complianceResultData.storageProfile == null) continue;
                    storagePolicyNames.add(complianceResultData.storageProfile.name);
                }
            }
            vmComplianceSummaryData.oldestCheckTime = vmRollupComplianceSummayData.oldestCheckTime;
            vmComplianceSummaryData.complianceStatus = vmRollupComplianceSummayData.rollupComplianceStatus;
            if (vmRollupComplianceSummayData.profileMismatch) {
                vmComplianceSummaryData.complianceStatus = OUT_OF_DATE_STATUS;
            }
            vmComplianceSummaryData.storagePolicyNames = storagePolicyNames.toArray(new String[storagePolicyNames.size()]);
        }
        if (replicationGroupAssignments != null && !replicationGroupAssignments.isEmpty()) {
            HashSet<String> replicationGroupNames = new HashSet<String>();
            for (ReplicationGroupAssignmentInfo assignmentInfo : replicationGroupAssignments) {
                if (assignmentInfo.replicationGroup == null) continue;
                replicationGroupNames.add(ReplicationGroupUtil.getReplicationGroupName((ReplicationGroupInfo)assignmentInfo.replicationGroup));
            }
            vmComplianceSummaryData.replicationGroupNames = replicationGroupNames.toArray(new String[replicationGroupNames.size()]);
        }
        return vmComplianceSummaryData;
    }

    private NamespaceCapabilityMetadata[] retrieveNamespaceMetadata(String vcGuid) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService((String)vcGuid, (PbmServiceFactory)this._pbmServiceFactory);
        ResourceType resourceType = new ResourceType();
        resourceType.resourceType = ResourceTypeEnum.STORAGE.toString();
        return MetadataUtil.getLocalizedNamespaceCapabilityMetadata((PbmService)pbmService, (ResourceType)resourceType, (String)vcGuid);
    }

    private Map<String, NamespaceCapabilityMetadata> getNamespaceMetadataMap(String vcGuid) {
        try {
            NamespaceCapabilityMetadata[] namespaces = this.retrieveNamespaceMetadata(vcGuid);
            HashMap<String, NamespaceCapabilityMetadata> metadataMap = new HashMap<String, NamespaceCapabilityMetadata>();
            if (namespaces != null) {
                for (NamespaceCapabilityMetadata namespace : namespaces) {
                    metadataMap.put(namespace.namespaceInfo.namespace, namespace);
                }
            }
            return metadataMap;
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve namespace metadata. ", (Throwable)ex);
            return null;
        }
    }

    private static String getDsNameFromPath(String dsPath) {
        int leftSquareBracketIndex = dsPath.indexOf(91);
        int rightSquareBracketIndex = dsPath.indexOf(93);
        if (leftSquareBracketIndex > -1 && rightSquareBracketIndex > -1 && leftSquareBracketIndex + 1 < rightSquareBracketIndex) {
            return dsPath.substring(leftSquareBracketIndex + 1, rightSquareBracketIndex);
        }
        return dsPath;
    }

    private static ManageVmStorageProfilesDatastoreData getDsDataByName(String name, ManageVmStorageProfilesDatastoreData[] dsDataItems) {
        if (dsDataItems == null) {
            return null;
        }
        for (ManageVmStorageProfilesDatastoreData dsData : dsDataItems) {
            if (!name.equals(dsData.name)) continue;
            return dsData;
        }
        return null;
    }
}

