/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory.impl;

import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.file.ResourceDefinitionManager;
import com.vmware.h5.sdk.plugin.migration.file.SpriteImageCreationException;
import com.vmware.h5.sdk.plugin.migration.model.ImageProperty;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.model.ResourceDefinition;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.vise.plugin.manifest.model.Definitions;
import com.vmware.vise.plugin.manifest.model.i18n.LanguageTag;
import com.vmware.vise.plugin.manifest.model.i18n.LocalizationData;
import com.vmware.vise.plugin.manifest.model.icon.IconSpriteSheet;
import com.vmware.vise.plugin.manifest.model.icon.SpriteSheetIconDefinition;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class DefinitionsModelFactory
implements ModelFactory<Definitions> {
    @Override
    public Definitions createModel(PluginBuilderConfig pluginBuilderConfig) {
        Definitions definitions = new Definitions();
        ResourceDefinitionManager resourceDefinitionManager = new ResourceDefinitionManager(pluginBuilderConfig.getConfiguration());
        this.setLocaleDefinitions(definitions, pluginBuilderConfig, resourceDefinitionManager);
        this.setIconDefinitions(definitions, pluginBuilderConfig, resourceDefinitionManager);
        return definitions;
    }

    private void setLocaleDefinitions(Definitions definitions, PluginBuilderConfig pluginBuilderConfig, ResourceDefinitionManager resourceDefinitionManager) {
        LocalizationData localizationData = new LocalizationData();
        HashMap<String, Map<LanguageTag, String>> definitionsMap = new HashMap<String, Map<LanguageTag, String>>();
        ResourceDefinition resourceDefinition = pluginBuilderConfig.getResourceDefinition();
        String resourceFolderName = resourceDefinition.getLocaleResourceFolderName();
        String resourceFileName = resourceDefinition.getBaseLocaleResourceFileName();
        if (resourceFolderName != null && resourceFileName != null) {
            Map<String, Properties> localePropertiesMap = resourceDefinitionManager.getLocalePropertiesMap(resourceFolderName, resourceFileName);
            Set<String> localeSet = localePropertiesMap.keySet();
            localizationData.changeSupportedLocales(localeSet.toArray(new String[localeSet.size()]));
            for (String key : resourceDefinition.getLocaleDefinitionPropertyKeys()) {
                HashMap<LanguageTag, String> languageToValue = new HashMap<LanguageTag, String>();
                for (String locale : localizationData.getSupportedLocales()) {
                    LanguageTag languageTag = this.getLanguageTag(locale);
                    if (languageTag == null) continue;
                    languageToValue.put(languageTag, this.getPropertyValue(key, localePropertiesMap.get(locale)));
                }
                definitionsMap.put(key, languageToValue);
            }
            localizationData.definitions = definitionsMap;
            definitions.localizationData = localizationData;
        }
    }

    private LanguageTag getLanguageTag(String language) {
        for (LanguageTag tag : LanguageTag.values()) {
            if (!tag.getName().equals(language)) continue;
            return tag;
        }
        return null;
    }

    private void setIconDefinitions(Definitions definitions, PluginBuilderConfig pluginBuilderConfig, ResourceDefinitionManager resourceDefinitionManager) {
        HashMap<String, SpriteSheetIconDefinition> iconDefinitionMap = new HashMap<String, SpriteSheetIconDefinition>();
        IconSpriteSheet iconSpriteSheet = new IconSpriteSheet(iconDefinitionMap);
        try {
            ResourceDefinition resourceDefinition = pluginBuilderConfig.getResourceDefinition();
            String cssResourceFilePath = resourceDefinition.getPluginCssResourceName();
            if (cssResourceFilePath != null) {
                String cssResourceFileName = Paths.get(cssResourceFilePath, new String[0]).getFileName().toString();
                Set<String> iconDefinitionPropertyKeys = resourceDefinition.getIconDefinitionPropertyKeys();
                Map<String, String> cssClassesMap = resourceDefinitionManager.getCssClassesMap(cssResourceFilePath, cssResourceFileName, pluginBuilderConfig);
                String cssPrefix = ".";
                ArrayList<ImageProperty> imageProperties = new ArrayList<ImageProperty>();
                Pattern backgroundPattern = Pattern.compile("background\\s*:.*");
                short y = 0;
                for (String iconCss : iconDefinitionPropertyKeys) {
                    String stylesString = cssClassesMap.get("." + iconCss.replace(":", "-"));
                    if (stylesString == null) continue;
                    String[] styles = stylesString.split("\\n");
                    ImageProperty imageProperty = new ImageProperty();
                    imageProperty.setCssName(iconCss);
                    for (String style : styles) {
                        if (!backgroundPattern.matcher(style).matches()) continue;
                        imageProperty.setUri(style.split(":")[1].trim());
                    }
                    SpriteSheetIconDefinition spriteSheetIconDefinition = new SpriteSheetIconDefinition();
                    spriteSheetIconDefinition.x = 0;
                    spriteSheetIconDefinition.y = y;
                    y = (short)(y + 32);
                    iconDefinitionMap.put(iconCss, spriteSheetIconDefinition);
                    imageProperties.add(imageProperty);
                }
                String spriteImage = resourceDefinitionManager.buildSpriteImage(imageProperties);
                if (!PluginMigrationUtils.isStringEmpty(spriteImage)) {
                    String spriteImageFilePath;
                    iconSpriteSheet.uri = spriteImageFilePath = "assets/images/" + spriteImage;
                    definitions.iconSpriteSheet = iconSpriteSheet;
                }
            }
        }
        catch (SpriteImageCreationException ex) {
            System.out.println("Sprite image creation exception " + ex.getMessage());
        }
    }

    private String getPropertyValue(String propertyName, Properties properties) {
        String property = properties.getProperty(propertyName);
        return property != null ? property : "";
    }
}

