/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.file;

import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.h5.sdk.plugin.migration.file.SpriteImageCreationException;
import com.vmware.h5.sdk.plugin.migration.model.ImageProperty;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.vise.plugin.manifest.model.i18n.LanguageTag;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class ResourceDefinitionManager {
    private static final List<String> EXCLUDE_FOLDERS_LIST = Arrays.asList("target", "META-INF", "WEB-INF", "dist", "node_modules");
    private Configuration configuration;

    public ResourceDefinitionManager(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, Properties> getLocalePropertiesMap(String resourceFolderName, String baseResourceFileName) {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        try {
            File localesDir;
            List<Path> paths = this.getResourceFolderPaths(resourceFolderName);
            Path resourceFolderPath = this.getResourceFolderContainingFilesWithSuffix(paths, "properties");
            if (resourceFolderPath != null && (localesDir = resourceFolderPath.toFile()).isDirectory()) {
                File[] files;
                for (File file : files = localesDir.listFiles()) {
                    try {
                        String localePropertiesName;
                        if (!file.getName().endsWith(".properties")) continue;
                        Properties properties = new Properties();
                        properties.load(new FileReader(file));
                        String fileName = file.getName();
                        String locale = fileName.substring(baseResourceFileName.length(), fileName.indexOf(".")).replace("_", "-");
                        String string = localePropertiesName = PluginMigrationUtils.isStringEmpty(locale) ? "en-US" : this.getFullLocaleString(locale.substring(1));
                        if (localePropertiesName == null) continue;
                        propertiesMap.put(localePropertiesName, properties);
                    }
                    catch (IOException ex) {
                        System.out.println(String.format("Unable to read file %s", file.getName()));
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.println(String.format("Unable to find resource folder %s", resourceFolderName));
        }
        return propertiesMap;
    }

    public String buildSpriteImage(List<ImageProperty> imageProperties) throws SpriteImageCreationException {
        List<BufferedImage> images = this.getImages(imageProperties);
        if (!images.isEmpty()) {
            try {
                int totalHeight = 0;
                int maxWidth = 0;
                for (BufferedImage bufferedImage : images) {
                    totalHeight += bufferedImage.getHeight();
                    int width = bufferedImage.getWidth();
                    if (width <= maxWidth) continue;
                    maxWidth = width;
                }
                if (maxWidth == 0 || totalHeight == 0) {
                    throw new SpriteImageCreationException(String.format("Unable to create sprite image file with height %d and width %d", totalHeight, maxWidth));
                }
                BufferedImage spriteImage = new BufferedImage(maxWidth, totalHeight, 2);
                Graphics graphics = spriteImage.getGraphics();
                int y = 0;
                for (BufferedImage image : images) {
                    graphics.drawImage(image, 0, y, null);
                    y += image.getHeight();
                }
                ImageIO.write((RenderedImage)spriteImage, "png", Paths.get(this.configuration.getOutputDir(), "sprite-image.png").toFile());
                System.out.println(String.format("%s sprite image file is generated in the directory %s", "sprite-image.png", this.configuration.getOutputDir()));
                return "sprite-image.png";
            }
            catch (IOException ex) {
                System.out.println("Unable to create final sprite image");
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, String> getCssClassesMap(String cssFilePath, String cssFileName, PluginBuilderConfig pluginBuilderConfig) {
        HashMap<String, String> cssClassesMap;
        block15: {
            BufferedReader bufferedReader;
            block14: {
                List<Path> paths;
                Path resourceFolderPath;
                String webContextPath = pluginBuilderConfig.getManifest().getWebContextPath();
                String pluginId = pluginBuilderConfig.getPluginId();
                cssClassesMap = new HashMap<String, String>();
                bufferedReader = null;
                String[] segments = webContextPath.split("/");
                String webContext = segments[segments.length - 1] + "/";
                String cssPath = cssFilePath;
                if (cssFilePath.startsWith(webContext)) {
                    cssPath = cssFilePath.substring(webContext.length());
                }
                if ((resourceFolderPath = this.getResourceFolderContainingFilesWithSuffix(paths = this.getResourceFolderPaths(cssPath), "css")) == null) break block14;
                File cssFile = resourceFolderPath.toFile();
                bufferedReader = new BufferedReader(new FileReader(cssFile));
                String line = null;
                String cssClass = null;
                StringBuilder sb = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.startsWith(".")) {
                        sb = new StringBuilder();
                        cssClass = line.replace("{", "").trim().replace(pluginId + "-", "");
                        continue;
                    }
                    if (cssClass == null) continue;
                    if (line.contains("}")) {
                        cssClassesMap.put(cssClass, sb.toString());
                        cssClass = null;
                        sb = null;
                        continue;
                    }
                    sb.append(line.trim()).append("\n");
                }
            }
            try {
                bufferedReader.close();
            }
            catch (IOException ex) {
                System.out.println(String.format("Unable to close css file %s", cssFileName));
            }
            break block15;
            catch (IOException ex) {
                try {
                    System.out.println(String.format("Unable to find css assets %s", cssFilePath));
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex2) {
                        System.out.println(String.format("Unable to close css file %s", cssFileName));
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException ex3) {
                    System.out.println(String.format("Unable to close css file %s", cssFileName));
                }
            }
        }
        return cssClassesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage convertSVGToPNG(Path svgPath) {
        File tempFile = null;
        OutputStream outputstream = null;
        OutputStream bos = null;
        try {
            String svgURIInput = svgPath.toUri().toURL().toString();
            TranscoderInput inputSvgImage = new TranscoderInput(svgURIInput);
            tempFile = File.createTempFile("temp", ".png", new File(this.configuration.getOutputDir()));
            outputstream = new FileOutputStream(tempFile);
            TranscoderOutput outputPngImage = new TranscoderOutput(outputstream);
            PNGTranscoder pngConverter = new PNGTranscoder();
            pngConverter.transcode(inputSvgImage, outputPngImage);
            bos = new ByteArrayOutputStream();
            bos.write(Files.readAllBytes(tempFile.toPath()));
            ByteArrayInputStream input = new ByteArrayInputStream(((ByteArrayOutputStream)bos).toByteArray());
            BufferedImage bufferedImage = ImageIO.read(input);
            return bufferedImage;
        }
        catch (Exception ex) {
            System.out.println("Error in creating .png file from .svg file. Please check the version of svg. The svg version should be 1.2");
        }
        finally {
            try {
                bos.flush();
                ((ByteArrayOutputStream)bos).close();
                outputstream.flush();
                outputstream.close();
                tempFile.delete();
            }
            catch (IOException ex) {
                System.out.println("Error in closing streams");
            }
        }
        return null;
    }

    private String getFullLocaleString(String locale) {
        for (LanguageTag tag : LanguageTag.values()) {
            String tagName = tag.getName();
            if (!tagName.equals(locale) && !tagName.startsWith(locale + "-")) continue;
            return tagName;
        }
        return null;
    }

    private List<BufferedImage> getImages(List<ImageProperty> imageProperties) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (ImageProperty imageProperty : imageProperties) {
            String path = PluginMigrationUtils.getPathFromCssUri(imageProperty.getUri());
            try {
                Path imagePath = this.getResourceFolderPath(path);
                File imageFile = imagePath.toFile();
                BufferedImage bufferedImage = null;
                bufferedImage = imageFile.getName().endsWith(".svg") ? this.convertSVGToPNG(imagePath) : ImageIO.read(imageFile);
                if (bufferedImage != null) {
                    Image scaledImage = bufferedImage.getScaledInstance(32, 32, 4);
                    BufferedImage scaledBufferedImage = new BufferedImage(32, 32, 2);
                    scaledBufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
                    images.add(scaledBufferedImage);
                    continue;
                }
                System.out.println("Unable to get the buffered images");
            }
            catch (IOException ex) {
                System.out.println(String.format("Unable to find image asset %s", path));
            }
        }
        return images;
    }

    private Path getResourceFolderContainingFilesWithSuffix(List<Path> paths, String suffix) {
        if (paths != null) {
            if (paths.size() == 1) {
                return paths.get(0);
            }
            for (Path path : paths) {
                File[] listOfFiles;
                File file = path.toFile();
                if (!file.isDirectory()) continue;
                for (File propFile : listOfFiles = file.listFiles()) {
                    if (!propFile.getName().endsWith("." + suffix)) continue;
                    return path;
                }
            }
        }
        return null;
    }

    private Path getResourceFolderPath(String filePath) throws IOException {
        String[] filePaths = filePath.split("/");
        return this.getPath(Paths.get(this.configuration.getProjectDir(), new String[0]), filePaths, false);
    }

    private Path getPath(Path rootPath, String[] folderPath, boolean matchAllPaths) throws IOException {
        List<Path> paths = this.getPaths(rootPath, folderPath, matchAllPaths);
        if (paths.isEmpty()) {
            throw new FileNotFoundException(String.format("Not able to find folder - %s", folderPath[0]));
        }
        return paths.get(0);
    }

    private List<Path> getResourceFolderPaths(String filePath) throws IOException {
        String[] filePaths = filePath.split("/");
        return this.getPaths(Paths.get(this.configuration.getProjectDir(), new String[0]), filePaths, true);
    }

    private List<Path> getPaths(Path rootPath, final String[] folderPath, final boolean matchAllPaths) throws IOException {
        if (folderPath == null || folderPath.length == 0) {
            return null;
        }
        final ArrayList paths = new ArrayList();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                String fileName = path.getFileName().toString();
                if (EXCLUDE_FOLDERS_LIST.contains(fileName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (folderPath[0].equals(fileName)) {
                    paths.add(path);
                    if (!matchAllPaths) {
                        return FileVisitResult.TERMINATE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ArrayList<Path> resolvedPaths = new ArrayList<Path>();
        String[] subPaths = Arrays.copyOfRange(folderPath, 1, folderPath.length);
        for (Path path : paths) {
            if (folderPath.length > 1) {
                try {
                    Path childPath = Paths.get(path.toString(), subPaths);
                    if (childPath == null) continue;
                    resolvedPaths.add(childPath);
                }
                catch (InvalidPathException invalidPathException) {}
                continue;
            }
            resolvedPaths.add(path);
        }
        return resolvedPaths;
    }
}

