/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

public final class RelationshipMetadata {
    private static String RELATIONSHIP_TYPE_REGEX = "\\s+as\\s+";
    private final String _relation;
    private final String _targetType;

    public RelationshipMetadata(String relationship) {
        String[] relData = relationship.split(RELATIONSHIP_TYPE_REGEX);
        if (relData.length < 1 || relData.length > 2) {
            throw new IllegalArgumentException("The relation '" + relationship + "' is not properly specified.");
        }
        this._relation = relData[0].trim();
        this._targetType = relData.length == 2 ? relData[1].trim() : null;
    }

    public String getRelation() {
        return this._relation;
    }

    public String getTargetType() {
        return this._targetType;
    }
}

