/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.DataModelMetadataParser;
import com.vmware.vise.data.query.commands.impl.QueryGenerator;
import java.util.List;
import java.util.Map;

final class RequestProcessor<T extends DataModel> {
    private final DataModelMetadataParser<T> _dataModelParser = new DataModelMetadataParser();
    private final RequestSpec _requestSpec;
    private final List<QuerySpec> _querySpecs;

    public RequestProcessor(Class<T> dataModel, Constraint constraint, Map<String, Object> parameters, ResultSpec resultSpec) {
        this._dataModelParser.parse(dataModel, constraint, parameters);
        this._querySpecs = new QueryGenerator<T>().generateQuerySpecs(this._dataModelParser, resultSpec);
        this._requestSpec = new RequestSpec();
        if (this._querySpecs != null) {
            this._requestSpec.querySpec = this._querySpecs.toArray(new QuerySpec[0]);
        }
    }

    public RequestSpec getRequestSpec() {
        return this._requestSpec;
    }

    public DataModelMetadata<T> getDataModelMetadata() {
        return this._dataModelParser.getDataModelMetadata();
    }

    public List<QuerySpec> getQuerySpecs() {
        return this._querySpecs;
    }
}

