/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataAdapterUtil {
    private static final Logger _logger = LoggerFactory.getLogger(DataAdapterUtil.class);

    DataAdapterUtil() {
    }

    static Callable<DataAdaptersExecutionResult> createAdapterTask(final DataAdapterInfo daInfo, final QuerySpec[] queryBatch, final String adapterType) {
        Validate.notNull(daInfo);
        Validate.notNull(queryBatch);
        Validate.notNull(adapterType);
        Callable<DataAdaptersExecutionResult> adapterTask = new Callable<DataAdaptersExecutionResult>(){

            @Override
            public DataAdaptersExecutionResult call() throws Exception {
                DataAdaptersExecutionResult result = DataAdapterUtil.getResultFromAdapter(daInfo, queryBatch);
                return result;
            }

            public String toString() {
                String str = adapterType + " " + daInfo.adapter.getClass().getName();
                return str;
            }
        };
        return adapterTask;
    }

    static List<DataAdaptersExecutionResult> executeAdapterTasks(ProfiledTaskExecutor executor, List<DataAdapterQueryBatch> daQueryBatches, List<Callable<DataAdaptersExecutionResult>> tasks) throws InterruptedException {
        assert (executor != null);
        assert (daQueryBatches != null && tasks != null);
        assert (daQueryBatches.size() == tasks.size());
        List taskResults = executor.executeTasks(tasks);
        ArrayList<DataAdaptersExecutionResult> results = new ArrayList<DataAdaptersExecutionResult>(taskResults.size());
        for (int i = 0; i < taskResults.size(); ++i) {
            DataAdaptersExecutionResult result;
            ExecutorUtil.TaskResult taskResult = taskResults.get(i);
            Exception taskException = taskResult.getException();
            if (taskException != null) {
                DataAdapterQueryBatch daQueryBatch = daQueryBatches.get(i);
                String adapterName = daQueryBatch.daInfo.adapter.getClass().getName();
                taskException = DataAdapterUtil.processDataAdapterTaskException(taskException, adapterName, executor.getTaskTimeoutInSecs());
                Map<QuerySpec, ResultSetInfo> resultsPerQuerySpec = DataAdapterUtil.constructErrorResultForAdapter(adapterName, daQueryBatch.queryBatch, taskException);
                result = new DataAdaptersExecutionResult(resultsPerQuerySpec, null);
            } else {
                result = (DataAdaptersExecutionResult)taskResult.getResult();
            }
            results.add(result);
        }
        return results;
    }

    private static Exception processDataAdapterTaskException(Exception taskException, String adapterName, long allowedExecutionTimeInSecs) {
        if (!(taskException instanceof TimeoutException)) {
            return taskException;
        }
        String msg = String.format(Utils.getLocalizedString("error.dataAdapterTimeout"), adapterName, allowedExecutionTimeInSecs);
        return new DataServiceException(msg, taskException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataAdaptersExecutionResult getResultFromAdapter(DataAdapterInfo daInfo, QuerySpec[] queryBatch) {
        assert (daInfo != null);
        assert (queryBatch != null);
        try (ViseDsLogConfigurator.ViseDsLogContext logContext = ViseDsLogConfigurator.onDataAdapterStart(daInfo.adapter);){
            DataAdaptersExecutionResult result;
            long startMillis = System.currentTimeMillis();
            Map<QuerySpec, ResultSetInfo> adapterResults = DataAdapterUtil.getDataFromAdapter(daInfo, queryBatch);
            long elapsedTime = System.currentTimeMillis() - startMillis;
            DataAdapterExecutionDetails execDetails = new DataAdapterExecutionDetails(daInfo, logContext.getInvocationId(), elapsedTime, queryBatch);
            DataAdaptersExecutionResult dataAdaptersExecutionResult = result = new DataAdaptersExecutionResult(adapterResults, Arrays.asList(execDetails));
            return dataAdaptersExecutionResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<QuerySpec, ResultSetInfo> getDataFromAdapter(DataAdapterInfo daInfo, QuerySpec[] queryBatch) {
        Response responseFromAdapter;
        assert (daInfo != null && daInfo.adapter != null);
        assert (ArrayUtils.isNotEmpty(queryBatch));
        DataProviderAdapter da = daInfo.adapter;
        String adapterName = daInfo.toString();
        Map<Object, Object> daResults = new IdentityHashMap();
        RequestSpec request = new RequestSpec();
        request.querySpec = queryBatch;
        ExecutionProfiler profiler = SessionUtil.getExecutionProfiler();
        try {
            String adapterLabel = "dataService." + daInfo.toString();
            Object timerKey = profiler.startTimer(adapterLabel);
            try {
                responseFromAdapter = da.getData(request);
            }
            finally {
                profiler.stopTimer(timerKey);
            }
        }
        catch (Exception ex) {
            return DataAdapterUtil.constructErrorResultForAdapter(adapterName, queryBatch, ex);
        }
        catch (AssertionError er) {
            IllegalStateException translated = new IllegalStateException(String.format("Data adapter %s failed with internal assertion error with message `%s'.", adapterName, ((Throwable)((Object)er)).getMessage()), (Throwable)((Object)er));
            return DataAdapterUtil.constructErrorResultForAdapter(adapterName, queryBatch, (Exception)translated);
        }
        ResultSet[] resultsFromAdapter = null;
        if (responseFromAdapter != null) {
            resultsFromAdapter = responseFromAdapter.resultSet;
            ResultUtil.setQueryNamesIntoResults(queryBatch, resultsFromAdapter);
        }
        if (da instanceof DynamicProviderAdapter) {
            DynamicProviderResultSet[] dynamicResultSet = resultsFromAdapter != null ? (DynamicProviderResultSet[])resultsFromAdapter : null;
            daResults = DataAdapterUtil.createResults(queryBatch, dynamicResultSet);
        } else {
            daResults = DataAdapterUtil.createResults(daInfo, queryBatch, resultsFromAdapter);
        }
        if (daResults.size() == 0) {
            DataAdapterUtil.logInabilityToExecuteQueries(adapterName, queryBatch);
            return null;
        }
        if (daResults.size() != queryBatch.length) {
            String errorMsg = "Invalid ResultSet[] size received from adapter " + adapterName + " getData(): " + daResults.size() + ". It should match QuerySpec[] size: " + queryBatch.length;
            _logger.error(errorMsg);
            return DataAdapterUtil.constructErrorResultForAdapter(adapterName, queryBatch, null);
        }
        DataAdapterUtil.logQueryResultsForAdapter(daInfo, daResults);
        return daResults;
    }

    private static void logQueryResultsForAdapter(DataAdapterInfo daInfo, Map<QuerySpec, ResultSetInfo> resultsByQuery) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        String adapterName = daInfo.adapter.getClass().getCanonicalName();
        for (QuerySpec query : resultsByQuery.keySet()) {
            ResultSetInfo resultSetInfo = resultsByQuery.get(query);
            ResultSet resultSet = resultSetInfo.getResultSet();
            if (_logger.isTraceEnabled()) {
                msg.append(String.format("For data adapter '%s' query '%s' returned:\n%s", adapterName, query.name, Utils.renderResultSet(resultSet)));
            } else {
                msg.append(String.format("For data adapter '%s' query '%s' returned '%s' items.", adapterName, query.name, resultSet.items == null ? null : Integer.valueOf(resultSet.items.length)));
            }
            msg.append("\n");
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace(msg.toString());
        } else {
            _logger.debug(msg.toString());
        }
    }

    private static void logInabilityToExecuteQueries(String adapterName, QuerySpec[] queries) {
        String NEW_LINE = System.getProperty("line.separator");
        StringBuilder message = new StringBuilder();
        message.append("Adapter ").append(adapterName).append(" cannot return result for: ").append(NEW_LINE);
        for (QuerySpec query : queries) {
            String renderedQuery = Utils.renderQuerySpec(query);
            message.append(renderedQuery).append(NEW_LINE);
        }
        _logger.debug(message.toString());
    }

    private static Map<QuerySpec, ResultSetInfo> createResults(DataAdapterInfo daInfo, QuerySpec[] queries, ResultSet[] resultsFromAdapter) {
        if (resultsFromAdapter == null) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>(0);
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> results = new IdentityHashMap<QuerySpec, ResultSetInfo>(resultsFromAdapter.length);
        for (int i = 0; i < resultsFromAdapter.length; ++i) {
            String msg;
            String adapterName;
            boolean pagedResult;
            ResultSet result = resultsFromAdapter[i];
            QuerySpec query = queries[i];
            ResultSpec resultSpec = query.resultSpec;
            if (resultSpec == null) {
                resultSpec = new ResultSpec();
            }
            boolean sortedResult = resultSpec.order != null && ArrayUtils.isNotEmpty(resultSpec.order.orderingProperties);
            boolean hasReturnedResult = result != null && result.items != null;
            boolean bl = pagedResult = hasReturnedResult && resultSpec.offset != null && resultSpec.offset > 0 && resultSpec.maxResultCount != null && resultSpec.maxResultCount >= result.items.length;
            if (!pagedResult && hasReturnedResult && _logger.isDebugEnabled()) {
                adapterName = daInfo.adapter.getClass().getName();
                msg = String.format("Data service will page the received '%s' items from adapter '%s' for query '%s' with offset '%s' and maxResultCount '%s'", query.name, result.items.length, adapterName, resultSpec.offset, resultSpec.maxResultCount);
                _logger.debug(msg);
            }
            if (hasReturnedResult && resultSpec.maxResultCount != null && resultSpec.maxResultCount >= 0 && resultSpec.maxResultCount < result.items.length) {
                adapterName = daInfo.adapter.getClass().getName();
                msg = String.format("Too many items were returned for query %s by adapter %s: got %d items and resultSpec.maxResultCount was %s.\nPaging will be applied by the DataService but you should fix your DataAdapterProvider to handle resultSpec correctly!", query.name, adapterName, result.items.length, resultSpec.maxResultCount);
                _logger.warn(msg);
            }
            ResultSetInfo resultInfo = result == null ? ResultSetInfo.newEmptyResultSetInfo(query.name) : ResultSetInfo.getResultSetInfo(result, sortedResult, pagedResult);
            results.put(query, resultInfo);
        }
        return results;
    }

    private static Map<QuerySpec, ResultSetInfo> createResults(QuerySpec[] queries, DynamicProviderResultSet[] dynamicResults) {
        if (dynamicResults == null) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>(0);
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> results = new IdentityHashMap<QuerySpec, ResultSetInfo>(dynamicResults.length);
        for (int i = 0; i < dynamicResults.length; ++i) {
            DynamicProviderResultSet result = dynamicResults[i];
            QuerySpec query = queries[i];
            ResultSetInfo resultInfo = DataAdapterUtil.getResultSetInfo(query.name, result);
            results.put(query, resultInfo);
        }
        return results;
    }

    private static ResultSetInfo getResultSetInfo(String queryName, DynamicProviderResultSet result) {
        if (result == null) {
            ResultSetInfo resultInfo = ResultSetInfo.newEmptyResultSetInfo(queryName);
            return resultInfo;
        }
        ResultSetInfo resultInfo = ResultSetInfo.getResultSetInfo(result, result.sorted, result.paged);
        return resultInfo;
    }

    private static Map<QuerySpec, ResultSetInfo> constructErrorResultForAdapter(String adapterName, QuerySpec[] queries, Exception ex) {
        IdentityHashMap<QuerySpec, ResultSetInfo> adapterResults = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec qs : queries) {
            ResultSetInfo result = DataAdapterUtil.constructErrorResultForAdapter(adapterName, qs, ex);
            adapterResults.put(qs, result);
        }
        return adapterResults;
    }

    private static ResultSetInfo constructErrorResultForAdapter(String adapterName, QuerySpec qs, Exception ex) {
        Exception e = ex;
        if (e == null) {
            e = new DataServiceException(String.format(Utils.getLocalizedString("error.invalidAdapterResult"), adapterName));
        }
        ResultSetInfo result = ResultSetInfo.createErrorResult(e);
        result.getResultSet().queryName = qs.name;
        return result;
    }

    static class DataAdapterQueryBatch {
        DataAdapterInfo daInfo;
        QuerySpec[] queryBatch;

        DataAdapterQueryBatch(DataAdapterInfo daInfo, QuerySpec[] queryBatch) {
            assert (daInfo != null);
            assert (!ArrayUtils.isEmpty(queryBatch));
            this.daInfo = daInfo;
            this.queryBatch = queryBatch;
        }
    }
}

