/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class DerivedPropertyDataImpl
implements DerivedPropertyDataInternal {
    private final Map<String, List<String>> _sourcePropertyNamesByType;
    private final Map<Object, Map<String, Object>> _sourcePropertyValuesByObject;

    DerivedPropertyDataImpl(Map<String, List<String>> sourcePropertyNamesByType, Map<Object, Map<String, Object>> sourcePropertyValuesByObject) {
        if (sourcePropertyNamesByType == null || sourcePropertyNamesByType.isEmpty()) {
            throw new IllegalArgumentException("Source property names cannot be null or empty!");
        }
        if (sourcePropertyValuesByObject == null) {
            throw new IllegalArgumentException("Source property values cannot be null!");
        }
        this._sourcePropertyNamesByType = sourcePropertyNamesByType;
        this._sourcePropertyValuesByObject = sourcePropertyValuesByObject;
    }

    @Override
    public Map<String, List<String>> getSourcePropertyNamesByType() {
        return this._sourcePropertyNamesByType;
    }

    @Override
    public Map<Object, Map<String, Object>> getSourcePropertyValuesByObject() {
        return this._sourcePropertyValuesByObject;
    }

    @Override
    public void addSourcePropertyValuesByObject(Map<Object, Map<String, Object>> sourcePropertyValuesPerObject) {
        if (sourcePropertyValuesPerObject == null || sourcePropertyValuesPerObject.isEmpty()) {
            return;
        }
        for (Object resultObject : sourcePropertyValuesPerObject.keySet()) {
            Map<String, Object> existingSourcePropertyValues = this._sourcePropertyValuesByObject.get(resultObject);
            Map<String, Object> newSourcePropertyValues = sourcePropertyValuesPerObject.get(resultObject);
            if (existingSourcePropertyValues == null) {
                existingSourcePropertyValues = new HashMap<String, Object>();
                this._sourcePropertyValuesByObject.put(resultObject, existingSourcePropertyValues);
            }
            existingSourcePropertyValues.putAll(newSourcePropertyValues);
        }
    }
}

