/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.DerivedPropertyDataImpl;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DerivedPropertyManager {
    private static final Log _logger = LogFactory.getLog(DerivedPropertyManager.class);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;
    private final QuerySpecBuilder _querySpecBuilder;
    private final ObjectReferenceService _objectReferenceService;
    private final SubTypeResolver _subTypeResolver;

    public DerivedPropertyManager(DataServiceExtensionRegistryInternal dataAdapterRegistry, QuerySpecBuilder querySpecBuilder, ObjectReferenceService objectReferenceService, SubTypeResolver subTypeResolver) {
        this._dataAdapterRegistry = dataAdapterRegistry;
        this._querySpecBuilder = querySpecBuilder;
        this._objectReferenceService = objectReferenceService;
        this._subTypeResolver = subTypeResolver;
    }

    Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> replaceDerivedWithSourcePropsInQueries(QuerySpec[] inputQueries) {
        if (ArrayUtil.isNullOrEmpty((Object[])inputQueries)) {
            return new HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>>();
        }
        HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichedQuerySpecsData = new HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>>();
        Map<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> enrichedQueries = this.replaceDerivedWithSourceProps(inputQueries);
        for (QuerySpec inputQuery : inputQueries) {
            Pair<QuerySpec, Map<String, List<String>>> enrichedQueryData = enrichedQueries.get(inputQuery);
            if (enrichedQueryData != null) {
                enrichedQuerySpecsData.put((QuerySpec)enrichedQueryData.first, (Pair<QuerySpec, DerivedPropertyDataInternal>)new Pair((Object)inputQuery, (Object)new DerivedPropertyDataImpl((Map)enrichedQueryData.second, new HashMap<Object, Map<String, Object>>()), false));
                continue;
            }
            enrichedQuerySpecsData.put(inputQuery, (Pair<QuerySpec, DerivedPropertyDataInternal>)new Pair((Object)inputQuery, null, false));
        }
        return enrichedQuerySpecsData;
    }

    private void appendDerivedPropertiesForTypeAndProperties(String type2, Set<String> properties, Map<String, Pair<Set<String>, Set<String>>> derivedAndSourcePropsByType) {
        assert (derivedAndSourcePropsByType != null);
        Map<String, Set<String>> sourcePropertiesByDerivedProperty = this.getSourceProperties(type2, properties);
        if (sourcePropertiesByDerivedProperty.isEmpty()) {
            return;
        }
        derivedAndSourcePropsByType.put(type2, (Pair<Set<String>, Set<String>>)new Pair(sourcePropertiesByDerivedProperty.keySet(), this.mergeSourceProperties(sourcePropertiesByDerivedProperty), true));
    }

    private Map<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> replaceDerivedWithSourceProps(QuerySpec[] inputQueries) {
        HashMap<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> enrichedQuerySpecs = new HashMap<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>>();
        for (QuerySpec inputQuery : inputQueries) {
            HashMap<String, List<String>> sourcePropertiesByType = new HashMap<String, List<String>>();
            QuerySpec enrichedQuery = this.replaceDerivedWithSourceProps(inputQuery, sourcePropertiesByType);
            if (enrichedQuery == null) continue;
            enrichedQuerySpecs.put(inputQuery, (Pair<QuerySpec, Map<String, List<String>>>)new Pair((Object)enrichedQuery, sourcePropertiesByType, true));
        }
        return enrichedQuerySpecs;
    }

    private QuerySpec replaceDerivedWithSourceProps(QuerySpec querySpec, Map<String, List<String>> sourcePropertiesByType) {
        assert (querySpec != null);
        assert (sourcePropertiesByType != null);
        Map<String, Pair<Set<String>, Set<String>>> derivedSourceProperties = this.getSourceProperties(querySpec);
        if (derivedSourceProperties == null || derivedSourceProperties.isEmpty()) {
            return null;
        }
        QuerySpec enrichedQuery = querySpec;
        boolean enriched = false;
        for (String type2 : derivedSourceProperties.keySet()) {
            Pair<Set<String>, Set<String>> derivedSourcePropertiesPair = derivedSourceProperties.get(type2);
            QuerySpec enrichedInnerQuery = this.replaceDerivedWithSourcePropsForType(enrichedQuery, type2, (Set)derivedSourcePropertiesPair.first, (Set)derivedSourcePropertiesPair.second);
            if (enrichedInnerQuery != null) {
                enrichedQuery = enrichedInnerQuery;
                sourcePropertiesByType.put(type2, new ArrayList((Collection)derivedSourcePropertiesPair.second));
                enriched = true;
                continue;
            }
            enriched = false;
            break;
        }
        if (enriched) {
            return enrichedQuery;
        }
        return null;
    }

    private Map<String, Pair<Set<String>, Set<String>>> getSourceProperties(QuerySpec querySpec) {
        if (querySpec == null) {
            return null;
        }
        Map<String, Set<String>> queryProperties = this._querySpecBuilder.getQueryProperties(querySpec, true);
        if (queryProperties == null || queryProperties.size() == 0) {
            return null;
        }
        HashMap<String, Pair<Set<String>, Set<String>>> derivedAndSourcePropsByType = new HashMap<String, Pair<Set<String>, Set<String>>>();
        Set<String> targetTypes = queryProperties.keySet();
        for (String targetType : targetTypes) {
            if ("*".equals(targetType)) continue;
            Set<String> properties = queryProperties.get(targetType);
            this.appendDerivedPropertiesForTypeAndProperties(targetType, properties, derivedAndSourcePropsByType);
            Set<String> subTypes = this._subTypeResolver.getSubTypes(targetType);
            if (subTypes == null || subTypes.isEmpty()) continue;
            for (String subType : subTypes) {
                if (targetTypes.contains(subType)) continue;
                this.appendDerivedPropertiesForTypeAndProperties(subType, properties, derivedAndSourcePropsByType);
            }
        }
        Set<String> typelessProperties = queryProperties.get("*");
        if (typelessProperties != null && !typelessProperties.isEmpty()) {
            Set<String> allRegisteredTypes = this._dataAdapterRegistry.getDerivedPropertyProvidersRegisteredTypes();
            for (String registeredType : allRegisteredTypes) {
                this.appendDerivedPropertiesForTypeAndProperties(registeredType, typelessProperties, derivedAndSourcePropsByType);
            }
        }
        if (derivedAndSourcePropsByType.size() == 0) {
            return null;
        }
        return derivedAndSourcePropsByType;
    }

    private QuerySpec replaceDerivedWithSourcePropsForType(QuerySpec querySpec, String type2, Set<String> derivedProperties, Set<String> sourceProperties) {
        assert (querySpec != null);
        assert (type2 != null);
        if (CollectionUtil.isNullOrEmpty(sourceProperties) || CollectionUtil.isNullOrEmpty(derivedProperties)) {
            return null;
        }
        try {
            HashSet<String> allDerivedProperties = new HashSet<String>(derivedProperties);
            for (String derivedProperty : derivedProperties) {
                allDerivedProperties.add(derivedProperty + ".@formatted");
            }
            ArrayList<PropertySpec> enrichedPropertySpecs = new ArrayList<PropertySpec>();
            boolean typeFound = false;
            boolean enriched = false;
            PropertySpec[] propertySpecs = querySpec.resourceSpec.propertySpecs;
            if (propertySpecs != null) {
                for (PropertySpec propertySpec : propertySpecs) {
                    if (propertySpec == null) continue;
                    PropertySpec enrichedPropertySpec = this.replaceDerivedWithSourceProps(propertySpec, type2, allDerivedProperties, sourceProperties);
                    if (enrichedPropertySpec != null) {
                        typeFound = typeFound || type2.equals(enrichedPropertySpec.type);
                        enriched = true;
                    } else {
                        enrichedPropertySpec = propertySpec;
                    }
                    enrichedPropertySpecs.add(enrichedPropertySpec);
                }
            }
            if (!typeFound) {
                PropertySpec extraPropertySpec = new PropertySpec();
                extraPropertySpec.type = type2;
                extraPropertySpec.propertyNames = sourceProperties.toArray(new String[sourceProperties.size()]);
                enrichedPropertySpecs.add(extraPropertySpec);
                enriched = true;
            }
            if (enriched) {
                QuerySpec enrichedQuerySpec = querySpec.clone();
                enrichedQuerySpec.resourceSpec.propertySpecs = enrichedPropertySpecs.toArray(new PropertySpec[enrichedPropertySpecs.size()]);
                return enrichedQuerySpec;
            }
            return null;
        }
        catch (CloneNotSupportedException cnse) {
            _logger.warn((Object)("Error has occurred while enriching QuerySpec: " + querySpec));
            return null;
        }
    }

    private PropertySpec replaceDerivedWithSourceProps(PropertySpec propertySpec, String type2, Set<String> derivedProperties, Set<String> sourceProperties) throws CloneNotSupportedException {
        assert (propertySpec != null);
        if (!this.canRepalceDerivedProperty(propertySpec, type2)) {
            return null;
        }
        PropertySpec enrichedPropertySpec = propertySpec.clone();
        LinkedHashSet<String> enrichedPropertyNames = new LinkedHashSet<String>();
        enrichedPropertyNames.addAll(Arrays.asList(propertySpec.propertyNames));
        enrichedPropertyNames.removeAll(derivedProperties);
        if (propertySpec.type != null) {
            enrichedPropertyNames.addAll(sourceProperties);
        }
        enrichedPropertySpec.propertyNames = enrichedPropertyNames.toArray(new String[enrichedPropertyNames.size()]);
        return enrichedPropertySpec;
    }

    void collectDerivedPropertyData(Map<QuerySpec, ResultSetInfo> resultsPerQuery, Map<QuerySpec, DerivedPropertyDataInternal> derivedPropertyDataPerQuery) {
        if (resultsPerQuery == null || resultsPerQuery.isEmpty() || derivedPropertyDataPerQuery == null || derivedPropertyDataPerQuery.isEmpty()) {
            return;
        }
        for (QuerySpec query : resultsPerQuery.keySet()) {
            ResultSetInfo result;
            DerivedPropertyDataInternal derivedPropertyData = derivedPropertyDataPerQuery.get(query);
            if (derivedPropertyData == null || (result = resultsPerQuery.get(query)) == null || result.getResultSet() == null) continue;
            this.collectSourcePropertyValues(result, derivedPropertyData);
        }
    }

    private void collectSourcePropertyValues(ResultSetInfo result, DerivedPropertyDataInternal derivedPropertyData) {
        Map<Object, Map<String, Object>> sourcePropertyValuesPerObject = this.getSourcePropertyValues(result, derivedPropertyData.getSourcePropertyNamesByType());
        derivedPropertyData.addSourcePropertyValuesByObject(sourcePropertyValuesPerObject);
    }

    private Map<Object, Map<String, Object>> getSourcePropertyValues(ResultSetInfo queryResult, Map<String, List<String>> sourcePropertyNames) {
        Object[] queryResultItems = queryResult.getResultSet().items;
        if (ArrayUtil.isNullOrEmpty((Object[])queryResultItems)) {
            return new HashMap<Object, Map<String, Object>>();
        }
        HashMap<Object, Map<String, Object>> sourcePropertyValues = new HashMap<Object, Map<String, Object>>();
        for (Object queryResultItem : queryResultItems) {
            Object queryResourceObject = ((ResultItem)queryResultItem).resourceObject;
            String queryResourceType = this._objectReferenceService.getResourceObjectType(queryResourceObject);
            List<String> sourceProperties = sourcePropertyNames.get(queryResourceType);
            Object[] queryPropertyValues = ((ResultItem)queryResultItem).properties;
            HashMap<String, Object> sourcePropertyValuesPerObject = (HashMap<String, Object>)sourcePropertyValues.get(queryResourceObject);
            if (sourcePropertyValuesPerObject == null) {
                sourcePropertyValuesPerObject = new HashMap<String, Object>();
            }
            if (!ArrayUtil.isNullOrEmpty(sourceProperties) && !ArrayUtil.isNullOrEmpty((Object[])queryPropertyValues)) {
                for (Object queryPropertyValue : queryPropertyValues) {
                    if (queryPropertyValue == null || !sourceProperties.contains(((PropertyValue)queryPropertyValue).propertyName)) continue;
                    sourcePropertyValuesPerObject.put(((PropertyValue)queryPropertyValue).propertyName, ((PropertyValue)queryPropertyValue).value);
                }
            }
            sourcePropertyValues.put(queryResourceObject, sourcePropertyValuesPerObject);
        }
        return sourcePropertyValues;
    }

    private final Map<String, Set<String>> getSourceProperties(String type2, Set<String> requestProperties) {
        Collection<PropertyProviderInfo> propertyProviders = this._dataAdapterRegistry.getDerivedPropertyProviders(type2, requestProperties);
        if (propertyProviders.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        IdentityHashSet propertyProviderAdapters = new IdentityHashSet();
        for (PropertyProviderInfo providerInfo : propertyProviders) {
            propertyProviderAdapters.add(providerInfo.propertyProvider);
        }
        return this.getSourcePropertiesFromPropertyAdapters((Set<PropertyProviderAdapter>)propertyProviderAdapters, type2, requestProperties);
    }

    private final Map<String, Set<String>> getSourcePropertiesFromPropertyAdapters(Set<PropertyProviderAdapter> propertyProviderAdapters, String type2, Set<String> requestProperties) {
        if (requestProperties == null || requestProperties.size() == 0) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> sourceProperties = new HashMap<String, Set<String>>();
        for (PropertyProviderAdapter propertyProviderAdapter : propertyProviderAdapters) {
            Object[] registeredTypes = this._dataAdapterRegistry.getProvidedTypeInfos(propertyProviderAdapter);
            if (ArrayUtil.isNullOrEmpty((Object[])registeredTypes)) continue;
            for (Object typeInfo : registeredTypes) {
                if (!type2.equals(((TypeInfo)typeInfo).type) || ((TypeInfo)typeInfo).derivedProperties == null) continue;
                for (DerivedPropertyInfo derivedPropertyInfo : ((TypeInfo)typeInfo).derivedProperties) {
                    if (!requestProperties.contains(derivedPropertyInfo.propertyName)) continue;
                    HashSet<String> srcProperties = (HashSet<String>)sourceProperties.get(derivedPropertyInfo.propertyName);
                    if (srcProperties == null) {
                        srcProperties = new HashSet<String>();
                        sourceProperties.put(derivedPropertyInfo.propertyName, srcProperties);
                    }
                    for (String srcProperty : derivedPropertyInfo.sourcePropertyNames) {
                        srcProperties.add(srcProperty);
                    }
                }
            }
        }
        return sourceProperties;
    }

    private final Set<String> mergeSourceProperties(Map<String, Set<String>> sourcePropertiesMap) {
        HashSet<String> mergedSourceProperties = new HashSet<String>();
        for (Set<String> sourceProperty : sourcePropertiesMap.values()) {
            mergedSourceProperties.addAll(sourceProperty);
        }
        return mergedSourceProperties;
    }

    private boolean canRepalceDerivedProperty(PropertySpec propertySpec, String type2) {
        return StringUtil.isNullOrEmpty((String)propertySpec.relation) && (propertySpec.type == null || type2.equals(propertySpec.type)) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }
}

