/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.impl.DataServiceThreadPoolFactory;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ProfiledTaskExecutor {
    private static final String DS_THREAD_POOL_NAME = "data-service-pool";
    private final ExecutorService _executor = DataServiceThreadPoolFactory.newCachedThreadPool("data-service-pool", Config.THREAD_POOL_CORE_SIZE, Config.THREAD_POOL_MAXIMUM_SIZE, new ThreadPoolExecutor.AbortPolicy());
    private final long _timeoutInMillis;

    ProfiledTaskExecutor(long timeoutInMillis) {
        this._timeoutInMillis = timeoutInMillis;
    }

    <T> List<ExecutorUtil.TaskResult<T>> executeTasks(List<Callable<T>> tasks) throws InterruptedException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{tasks});
        try {
            List taskResults = ExecutorUtil.executeTasks(tasks, (Executor)this._executor, (long)this._timeoutInMillis, (TimeUnit)TimeUnit.MILLISECONDS, (boolean)true, (boolean)true, (boolean)false);
            return taskResults;
        }
        catch (RejectedExecutionException e) {
            throw new DataServiceException("The Data Service thread pool 'data-service-pool' rejected a task.", e);
        }
        catch (TimeoutException e) {
            String msg = String.format(Utils.getLocalizedString("error.dataServiceTimeout"), this.getTaskTimeoutInSecs());
            throw new DataServiceException(msg, e);
        }
    }

    long getTaskTimeoutInSecs() {
        return this._timeoutInMillis / 1000L;
    }

    void shutdown() {
        this._executor.shutdown();
    }
}

