/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.ResultSet;

public final class ResultSetInfo {
    private final ResultSet _resultSet;
    private final boolean _sorted;
    private final boolean _paged;

    private ResultSetInfo(ResultSet resultSet, boolean sorted, boolean paged) {
        this._resultSet = resultSet;
        if (resultSet == null || resultSet.items == null || resultSet.items.length == 0) {
            this._sorted = true;
            this._paged = true;
        } else {
            this._sorted = sorted;
            this._paged = paged;
        }
    }

    public static ResultSetInfo getResultSetInfo(ResultSet resultSet, boolean sorted, boolean paged) {
        ResultSetInfo resultSetInfo = new ResultSetInfo(resultSet, sorted, paged);
        return resultSetInfo;
    }

    public static ResultSetInfo getResultSetInfo(ResultSet resultSet, boolean sorted) {
        boolean paged = false;
        ResultSetInfo resultSetInfo = new ResultSetInfo(resultSet, sorted, paged);
        return resultSetInfo;
    }

    public static ResultSetInfo getResultSetInfo(ResultSetInfo original, ResultSet resultSet) {
        ResultSetInfo resultSetInfo = new ResultSetInfo(resultSet, original.isSorted(), original.isPaged());
        return resultSetInfo;
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public boolean isSorted() {
        return this._sorted;
    }

    public boolean isPaged() {
        return this._paged;
    }

    public int getItemCount() {
        if (this._resultSet == null || this._resultSet.items == null) {
            return 0;
        }
        int itemCount = this._resultSet.items.length;
        return itemCount;
    }

    public static ResultSetInfo newEmptyResultSetInfo(String queryName) {
        ResultSet rs = new ResultSet();
        rs.queryName = queryName == null ? "" : queryName;
        boolean sorted = true;
        boolean paged = true;
        ResultSetInfo resultSetInfo = ResultSetInfo.getResultSetInfo(rs, sorted, paged);
        return resultSetInfo;
    }

    public static ResultSetInfo newEmptyResultSetInfo() {
        return ResultSetInfo.newEmptyResultSetInfo(null);
    }

    public static ResultSetInfo createErrorResult(Exception error) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = error;
        boolean sorted = true;
        boolean paged = true;
        ResultSetInfo resultSetInfo = ResultSetInfo.getResultSetInfo(resultSet, sorted, paged);
        return resultSetInfo;
    }
}

