/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class SubTypeResolver {
    private final ObjectModelProviderRegistryInternal _objectModelProviderRegistry;
    private static final String MANAGED_ENTITY_TYPE = "ManagedEntity";
    private final SetMultimap<String, String> _subTypesByType;

    public SubTypeResolver(ObjectModelProviderRegistryInternal objectModelProviderRegistry) {
        if (objectModelProviderRegistry == null) {
            throw new IllegalArgumentException("objectModelProviderRegistry shouldn't be null");
        }
        this._objectModelProviderRegistry = objectModelProviderRegistry;
        this._subTypesByType = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    public Set<String> getSubTypes(String type2) {
        Set subTypes = this._subTypesByType.get((Object)type2);
        if (subTypes != null) {
            subTypes = Collections.unmodifiableSet(subTypes);
        }
        return subTypes;
    }

    public void updateSubTypes(String type2) {
        assert (type2 != null);
        String[] superTypes = this.getSuperTypes(type2);
        if (superTypes == null) {
            return;
        }
        this.updateSubTypes(type2, superTypes);
    }

    private void updateSubTypes(String type2, String[] superTypes) {
        int i;
        assert (type2 != null);
        assert (superTypes != null);
        int meSuperTypeIdx = -1;
        for (i = 0; i < superTypes.length; ++i) {
            if (!MANAGED_ENTITY_TYPE.equals(superTypes[i])) continue;
            meSuperTypeIdx = i;
            break;
        }
        for (i = meSuperTypeIdx - 1; i >= 0; --i) {
            String superType = superTypes[i];
            for (int j = i - 1; j >= 0; --j) {
                this._subTypesByType.put((Object)superType, (Object)superTypes[j]);
            }
            this._subTypesByType.put((Object)superType, (Object)type2);
        }
    }

    private String[] getSuperTypes(String type2) {
        List<ObjectModelProvider> objectModelProviders = this._objectModelProviderRegistry.getAllObjectModelProviders();
        if (objectModelProviders == null) {
            return null;
        }
        for (ObjectModelProvider objectModelProvider : objectModelProviders) {
            String[] superTypes = objectModelProvider.getSuperTypes(type2);
            if (superTypes == null) continue;
            return superTypes;
        }
        return null;
    }
}

