/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DerivedPropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingUtil {
    private static final Logger _logger = LoggerFactory.getLogger(ProfilingUtil.class);

    public static void logSlowExecutions(QuerySpec[] querySpecs, long elapsedTimeForAllQueries, DataAdaptersExecutionResult daExecResult, List<PropertyProvidersExecutionResult> ppExecResults) {
        boolean slowQueryBatchDetected;
        if (!_logger.isWarnEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)ProfilingUtil.logDataProviderDetails(daExecResult));
        for (PropertyProvidersExecutionResult ppExecResult : ppExecResults) {
            sb.append((CharSequence)ProfilingUtil.logPropertyProviderDetails(ppExecResult));
        }
        boolean slowExecutionDetected = sb.length() > 0;
        boolean bl = slowQueryBatchDetected = elapsedTimeForAllQueries > Config.QUERY_BATCH_TIME_THRESHOLD;
        if (slowExecutionDetected || slowQueryBatchDetected) {
            StringBuilder warningMsg = new StringBuilder();
            warningMsg.append("The Data Service detected slow execution:\n");
            String providerInvocation = ViseDsLogConfigurator.getProviderInvocation();
            if (providerInvocation != null) {
                warningMsg.append("DataService is called by provider invocation: " + providerInvocation + "\n");
            }
            if (slowQueryBatchDetected) {
                warningMsg.append("The query batch execution took too long: ").append(elapsedTimeForAllQueries).append(" milliseconds.\n");
            }
            if (slowExecutionDetected) {
                warningMsg.append(sb.toString());
            }
            warningMsg.append("\nThe queries in the batch sent to the Data Service are:\n").append(Utils.renderQuerySpecs(querySpecs));
            _logger.warn(warningMsg.toString());
        }
    }

    public static void logQSpecsIfMaxResultCountIsWrong(QuerySpec[] querySpecs) {
        if (_logger.isDebugEnabled()) {
            Vector<QuerySpec> badQSs = new Vector<QuerySpec>();
            for (QuerySpec qs : querySpecs) {
                ResultSpec rs;
                if (qs == null || (rs = qs.resultSpec) != null && rs.maxResultCount != null && rs.maxResultCount >= 0 && rs.maxResultCount <= 1000) continue;
                badQSs.add(qs);
            }
            if (!badQSs.isEmpty()) {
                _logger.debug("ResultSpec.maxResultCount is wrong.\nThe following are names of QuerySpecs that do not specify maxResultCount or it is above 1000:\n" + Utils.getQueryNames(badQSs));
            }
        }
    }

    private static StringBuilder logDataProviderDetails(DataAdaptersExecutionResult execResult) {
        StringBuilder sb = new StringBuilder();
        if (execResult == null) {
            return sb;
        }
        if (execResult.getAdaptersExecutionDetails() != null) {
            for (DataAdapterExecutionDetails daStat : execResult.getAdaptersExecutionDetails()) {
                long elapsedTime;
                if (daStat == null || (elapsedTime = daStat.getElapsedTime()) <= Config.DATA_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                sb.append("\nA ").append(DataProviderAdapter.class.getSimpleName()).append(" (").append(daStat.getDataAdapterInfo()).append(")").append(" execution took too long: ").append(elapsedTime).append(" milliseconds.").append("\nInvocation id: ").append(daStat.getInvocationId()).append("\nQuery names: ").append(Utils.getQueryNames(daStat.getQuerySpecs())).append('\n');
            }
        }
        return sb;
    }

    private static StringBuilder logPropertyProviderDetails(PropertyProvidersExecutionResult execResult) {
        long elapsedTime;
        StringBuilder sb = new StringBuilder();
        if (execResult == null) {
            return sb;
        }
        if (execResult.getPropertyProvidersExecDetails() != null) {
            for (PropertyProviderExecutionDetails ppStat : execResult.getPropertyProvidersExecDetails()) {
                if (ppStat == null || (elapsedTime = ppStat.getElapsedTime()) <= Config.PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                if (ppStat instanceof DerivedPropertyProviderExecutionDetails) {
                    sb.append("\nA ").append(DerivedPropertyProviderAdapter.class.getSimpleName()).append(" (").append(ppStat.getPropertyProvider()).append(")").append(" execution took too long: ").append(elapsedTime).append(" milliseconds.").append("\nInvocation id: ").append(ppStat.getInvocationId()).append("\nQuery name: ").append(ppStat.getQuerySpec().name).append("\nThe derived properties processed: ").append(Arrays.toString(ppStat.getPropertySpecs())).append("\nTo compute the derived properties requested properties: ").append(Arrays.toString(((DerivedPropertyProviderExecutionDetails)ppStat).getSourcePropertyNamesByType().entrySet().toArray())).append('\n');
                    continue;
                }
                sb.append("\nA ").append(PropertyProviderAdapter.class.getSimpleName()).append(" (").append(Utils.renderPropertyProvider(ppStat.getPropertyProvider())).append(")").append(" execution took too long: ").append(elapsedTime).append(" milliseconds.").append("\nInvocation id: ").append(ppStat.getInvocationId()).append("\nQuery name: ").append(ppStat.getQuerySpec().name).append("\nThe properties processed: ").append(Arrays.toString(ppStat.getPropertySpecs())).append('\n');
            }
        }
        if (execResult.getDynamicAdaptersExecDetails() != null) {
            for (DataAdapterExecutionDetails daStat : execResult.getDynamicAdaptersExecDetails()) {
                if (daStat == null || (elapsedTime = daStat.getElapsedTime()) <= Config.DATA_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                sb.append("\nA dynamic adapter ").append(DataProviderAdapter.class.getSimpleName()).append(" (").append(daStat.getDataAdapterInfo()).append(")").append(" execution took too long: ").append(elapsedTime).append(" milliseconds. The dynamic adapter was executed after").append(" the property providers to provide the properties that").append(" were not covered by the property providers.").append("\nInvocation id: ").append(daStat.getInvocationId()).append("\nQuery names: ").append(Utils.getQueryNames(daStat.getQuerySpecs())).append('\n');
            }
        }
        return sb;
    }
}

