/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform;

import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransformUtil {
    private static final Log _logger = LogFactory.getLog(TransformUtil.class);

    private TransformUtil() {
    }

    public static <T> Transformer.Result<T> executeTransformers(Collection<Transformer<T, T>> transformers, T obj) {
        Transformer.Result<Object> transformResult = new Transformer.Result<T>(obj);
        for (Transformer<T, T> transformer : transformers) {
            TransformationException error = null;
            Transformer.Result<T> currentResult = null;
            boolean isTransformed = false;
            try {
                currentResult = transformer.transform(transformResult.getData());
                isTransformed = transformResult.isTransformed() || currentResult.isTransformed();
                error = TransformUtil.getCompositeError(transformResult.getError(), currentResult.getError());
            }
            catch (Exception e) {
                error = TransformUtil.getCompositeError(transformResult.getError(), e);
                String message = String.format("Invalid transformation for: %1$s", transformer.getClass().getName());
                _logger.error((Object)message, (Throwable)e);
            }
            Object resultData = currentResult == null ? null : (Object)currentResult.getData();
            transformResult = new Transformer.Result<Object>(resultData, isTransformed, error);
        }
        return transformResult;
    }

    public static TransformationException getCompositeError(Exception first, Exception second) {
        if (first == null) {
            return TransformUtil.newTransformationException(second);
        }
        if (second == null) {
            return TransformUtil.newTransformationException(first);
        }
        int MSG_SEPARATOR = 59;
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(first.getMessage()).append(';').append(second.getMessage());
        TransformationException error = new TransformationException(errorMessage.toString());
        return error;
    }

    private static TransformationException newTransformationException(Exception exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof TransformationException) {
            return (TransformationException)exception;
        }
        return new TransformationException(exception);
    }
}

