/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.transform.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormattingPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private static final Log _logger = LogFactory.getLog(FormattingPropertyConstraintTransformer.class);

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propConstr = (PropertyConstraint)constraint;
        String propName = propConstr.propertyName;
        if (propName == null) {
            _logger.error((Object)"The 'propertyName' of the PropertyConstraint is null");
            return new Transformer.Result<Constraint>(constraint);
        }
        boolean isTransformed = false;
        if (propName.contains(".@formatted")) {
            propName = Utils.getStringBeforeSubStr(propName, ".@formatted");
            isTransformed = true;
        }
        PropertyConstraint modifiedConstraint = propConstr;
        if (isTransformed) {
            modifiedConstraint = new PropertyConstraint();
            modifiedConstraint.comparableValue = propConstr.comparableValue;
            modifiedConstraint.comparator = propConstr.comparator;
            modifiedConstraint.targetType = propConstr.targetType;
            modifiedConstraint.propertyName = propName;
        }
        return new Transformer.Result<Constraint>(modifiedConstraint, isTransformed);
    }
}

