/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.transform.Transformer;
import java.util.ArrayList;
import java.util.HashMap;

public final class NormalizeConstraintTransformer
implements Transformer<Constraint, Constraint> {
    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof CompositeConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        CompositeConstraint compositeConstr = (CompositeConstraint)constraint;
        boolean madeModification = this.removeDuplicateChildren(compositeConstr);
        return new Transformer.Result<Constraint>(compositeConstr, madeModification, null);
    }

    private boolean removeDuplicateChildren(CompositeConstraint compositeConstr) {
        Constraint[] children = compositeConstr.nestedConstraints;
        HashMap<Object, ObjectIdentityConstraint> uniqueIdentityConstraints = new HashMap<Object, ObjectIdentityConstraint>();
        ArrayList<Constraint> nestedConstraints = new ArrayList<Constraint>(children.length);
        for (Constraint nestedConstraint : children) {
            if (nestedConstraint instanceof ObjectIdentityConstraint) {
                ObjectIdentityConstraint oic = (ObjectIdentityConstraint)nestedConstraint;
                uniqueIdentityConstraints.put(oic.target, oic);
                continue;
            }
            nestedConstraints.add(nestedConstraint);
        }
        nestedConstraints.addAll(uniqueIdentityConstraints.values());
        boolean madeModification = false;
        if (nestedConstraints.size() != children.length) {
            madeModification = true;
            Constraint[] newNestedConstraint = nestedConstraints.toArray(new Constraint[nestedConstraints.size()]);
            compositeConstr.nestedConstraints = newNestedConstraint;
        }
        return madeModification;
    }
}

